/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.scene.Parent;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractViewerContributionItem;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractZoomAction;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ZoomComboContributionItem
extends AbstractViewerContributionItem {
    public static final String ZOOM_COMBO_CONTRIBUTION_ITEM_ID = "ZoomComboContributionItem";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+\\.\\d+|\\.\\d+|\\d+)");
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    private ToolItem toolItem;
    private Combo zoomCombo;
    private ChangeListener<? super Number> zoomListener;
    private AbstractZoomAction zoomAction = this.createZoomAction();
    private List<IAction> additionalActions = new ArrayList<IAction>();

    static {
        PERCENT_FORMAT.setGroupingUsed(false);
        PERCENT_FORMAT.setMinimumFractionDigits(0);
        PERCENT_FORMAT.setMaximumFractionDigits(0);
    }

    public ZoomComboContributionItem(IAction ... additionalActions) {
        this.setId(ZOOM_COMBO_CONTRIBUTION_ITEM_ID);
        this.additionalActions.addAll(Arrays.asList(additionalActions));
    }

    protected AbstractZoomAction createZoomAction() {
        return new AbstractZoomAction("Zoom"){

            @Override
            protected double determineZoomFactor(double currentZoomFactor, Event event) {
                return (Double)event.data * 1.0 / currentZoomFactor;
            }
        };
    }

    public void dispose() {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.dispose();
        }
    }

    public void fill(Composite parent) {
        throw new UnsupportedOperationException();
    }

    public void fill(CoolBar parent, int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(Menu menu, int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(ToolBar tb, int index) {
        this.toolItem = new ToolItem(tb, 2, index);
        this.zoomCombo = new Combo((Composite)tb, 4);
        this.zoomCombo.setItems(this.getItems().toArray(new String[0]));
        this.toolItem.setWidth(this.zoomCombo.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.toolItem.setControl((Control)this.zoomCombo);
        this.zoomCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 10 || e.keyCode == 13) {
                    double zoom = ZoomComboContributionItem.this.toZoomFactor(ZoomComboContributionItem.this.zoomCombo.getText());
                    if (zoom > 0.0) {
                        Event event = new Event();
                        event.data = zoom;
                        ZoomComboContributionItem.this.zoomAction.runWithEvent(event);
                    } else {
                        ZoomComboContributionItem.this.updateComboText();
                    }
                }
            }
        });
        this.zoomCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ZoomComboContributionItem.this.zoomCombo.getSelectionIndex();
                if (selectionIndex < 0) {
                    return;
                }
                List<Double> zoomFactors = ZoomComboContributionItem.this.getZoomFactors();
                if (selectionIndex >= zoomFactors.size()) {
                    ((IAction)ZoomComboContributionItem.this.additionalActions.get(selectionIndex - zoomFactors.size())).runWithEvent(null);
                } else {
                    Event event = new Event();
                    event.data = zoomFactors.get(selectionIndex);
                    ZoomComboContributionItem.this.zoomAction.runWithEvent(event);
                }
            }
        });
        this.updateComboText();
    }

    protected List<String> getItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (Double zoomFactor : this.getZoomFactors()) {
            items.add(this.toPercentText(zoomFactor));
        }
        for (IAction a : this.additionalActions) {
            items.add(a.getText());
        }
        return items;
    }

    protected double getMaximumPermissibleZoomFactor() {
        return 64.0;
    }

    protected double getMinimumPermissibleZoomFactor() {
        return 0.001;
    }

    protected List<Double> getZoomFactors() {
        return Arrays.asList(0.125, 0.25, 0.3333333333333333, 0.5, 0.6666666666666666, 0.75, 1.0, 1.25, 1.5, 2.0, 3.0, 4.0, 8.0);
    }

    @Override
    protected void register() {
        if (this.zoomListener != null) {
            throw new IllegalStateException("Zoom listener is already registered.");
        }
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            InfiniteCanvas infiniteCanvas = (InfiniteCanvas)canvas;
            this.zoomListener = (a, o, n) -> this.showZoomFactor((Number)n);
            infiniteCanvas.getContentTransform().mxxProperty().addListener(this.zoomListener);
            this.showZoomFactor(infiniteCanvas.getContentTransform().getMxx());
        }
    }

    @Override
    public void setAdaptable(IViewer viewer) {
        super.setAdaptable(viewer);
        this.zoomAction.setAdaptable(viewer);
        for (IAction a : this.additionalActions) {
            if (!(a instanceof IAdaptable.Bound)) continue;
            ((IAdaptable.Bound)a).setAdaptable((IAdaptable)viewer);
        }
    }

    protected void showZoomFactor(Number zoomFactor) {
        if (this.zoomCombo != null) {
            String text = this.toPercentText(zoomFactor.doubleValue());
            this.zoomCombo.setText(text);
        }
    }

    protected String toPercentText(double zoomFactor) {
        return PERCENT_FORMAT.format(zoomFactor);
    }

    protected double toZoomFactor(String percentText) {
        Matcher matcher = NUMBER_PATTERN.matcher(percentText);
        if (matcher.find()) {
            try {
                double zoom = PERCENT_FORMAT.parse(matcher.group(1)).doubleValue() / 100.0;
                return Math.min(this.getMaximumPermissibleZoomFactor(), Math.max(this.getMinimumPermissibleZoomFactor(), zoom));
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }
        return -1.0;
    }

    @Override
    protected void unregister() {
        if (this.zoomListener == null) {
            throw new IllegalStateException("Zoom listener not yet registered.");
        }
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            ((InfiniteCanvas)canvas).getContentTransform().mxxProperty().removeListener(this.zoomListener);
            this.zoomListener = null;
        }
    }

    protected void updateComboText() {
        Parent canvas;
        if (this.isEnabled() && (canvas = this.getViewer().getCanvas()) instanceof InfiniteCanvas) {
            InfiniteCanvas infiniteCanvas = (InfiniteCanvas)canvas;
            this.showZoomFactor(infiniteCanvas.getContentTransform().getMxx());
        }
    }
}

