/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.parts;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.services.IDisposable;

public class ContentSelectionProvider
implements ISelectionProvider,
IDisposable {
    private final SelectionObserver selectionObserver = new SelectionObserver();
    private List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private IViewer viewer;
    private SelectionModel selectionModel;

    public ContentSelectionProvider(IViewer viewer) {
        this.viewer = viewer;
        this.selectionModel = (SelectionModel)viewer.getAdapter(SelectionModel.class);
        this.selectionModel.getSelectionUnmodifiable().addListener((ListChangeListener)this.selectionObserver);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void dispose() {
        if (this.selectionModel != null) {
            this.selectionModel.getSelectionUnmodifiable().removeListener((ListChangeListener)this.selectionObserver);
        }
    }

    public ISelection getSelection() {
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (!this.selectionModel.getSelectionUnmodifiable().isEmpty()) {
            ObservableList selectedContentParts = this.selectionModel.getSelectionUnmodifiable();
            ArrayList<Object> selectedContentElements = new ArrayList<Object>(selectedContentParts.size());
            for (IContentPart cp : selectedContentParts) {
                selectedContentElements.add(cp.getContent());
            }
            selection = new StructuredSelection(selectedContentElements);
        }
        return selection;
    }

    protected IViewer getViewer() {
        return this.viewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            if (!this.selectionModel.getSelectionUnmodifiable().isEmpty()) {
                this.selectionModel.clearSelection();
            }
        } else if (selection instanceof StructuredSelection) {
            Object[] selected = ((StructuredSelection)selection).toArray();
            ArrayList<IContentPart> parts = new ArrayList<IContentPart>(selected.length);
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object content = objectArray[n2];
                IContentPart part = (IContentPart)this.viewer.getContentPartMap().get(content);
                if (part != null) {
                    parts.add(part);
                }
                ++n2;
            }
            if (!this.selectionModel.getSelectionUnmodifiable().equals(parts)) {
                this.selectionModel.setSelection(parts);
            }
        }
    }

    private class SelectionObserver
    implements ListChangeListener<IContentPart<? extends Node>> {
        private SelectionObserver() {
        }

        public void onChanged(ListChangeListener.Change<? extends IContentPart<? extends Node>> c) {
            final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)ContentSelectionProvider.this, ContentSelectionProvider.this.getSelection());
            for (final ISelectionChangedListener l : ContentSelectionProvider.this.selectionChangedListeners) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(e);
                    }
                });
            }
        }
    }
}

