/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.behaviors;

import javafx.collections.SetChangeListener;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.zest.fx.models.HidingModel;

public abstract class AbstractHidingBehavior
extends AbstractBehavior {
    private SetChangeListener<Node> hidingModelObserver = new SetChangeListener<Node>(){

        public void onChanged(SetChangeListener.Change<? extends Node> change) {
            AbstractHidingBehavior.this.onHidingModelChange(change);
        }
    };
    private boolean isHidden;

    protected abstract boolean determineHiddenStatus();

    protected void doActivate() {
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.hiddenProperty().addListener(this.hidingModelObserver);
    }

    protected void doDeactivate() {
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.hiddenProperty().removeListener(this.hidingModelObserver);
    }

    protected HidingModel getHidingModel() {
        return (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
    }

    protected void hide() {
        this.getHost().getVisual().setVisible(false);
        this.getHost().getVisual().setMouseTransparent(true);
    }

    protected boolean isHidden() {
        return this.isHidden;
    }

    protected void onHidingModelChange(SetChangeListener.Change<? extends Node> change) {
        boolean wasHidden = this.isHidden;
        this.isHidden = this.determineHiddenStatus();
        if (wasHidden && !this.isHidden) {
            this.show();
        } else if (!wasHidden && this.isHidden) {
            this.hide();
        }
    }

    protected void show() {
        this.getHost().getVisual().setVisible(true);
        this.getHost().getVisual().setMouseTransparent(false);
    }
}

