/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.behaviors.HoverBehavior;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeFocusOperation;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.zest.fx.operations.HideOperation;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class HidePolicy
extends AbstractPolicy {
    protected ITransactionalOperation createDeselectOperation(NodePart part) {
        return new DeselectOperation(part.getRoot().getViewer(), Collections.singletonList(part));
    }

    protected ITransactionalOperation createHideOperation(NodePart part) {
        return new HideOperation(part.getRoot().getViewer(), part);
    }

    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Hide");
    }

    protected ITransactionalOperation createUnfocusOperation(NodePart part) {
        IViewer viewer = part.getRoot().getViewer();
        FocusModel focusModel = (FocusModel)viewer.getAdapter((TypeToken)new TypeToken<FocusModel>(){});
        if (focusModel != null && focusModel.getFocus() == part) {
            return new ChangeFocusOperation(viewer, null);
        }
        return null;
    }

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    public void hide() {
        ITransactionalOperation deselectOperation;
        this.checkInitialized();
        AbstractCompositeOperation revOp = (AbstractCompositeOperation)this.getOperation();
        ITransactionalOperation unfocusOperation = this.createUnfocusOperation(this.getHost());
        if (unfocusOperation != null) {
            revOp.add((IUndoableOperation)unfocusOperation);
        }
        if ((deselectOperation = this.createDeselectOperation(this.getHost())) != null) {
            revOp.add((IUndoableOperation)deselectOperation);
        }
        revOp.add((IUndoableOperation)new ClearHoverHandlesOperation((IContentPart<? extends Node>)this.getHost()));
        ITransactionalOperation hideOperation = this.createHideOperation(this.getHost());
        if (hideOperation != null) {
            revOp.add((IUndoableOperation)hideOperation);
        }
        this.locallyExecuteOperation();
    }

    public class ClearHoverHandlesOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private HoverModel hoverModel;
        private HoverBehavior hoverBehavior;
        private IVisualPart<? extends Node> hoveredPart;

        public ClearHoverHandlesOperation(IContentPart<? extends Node> part) {
            super("ClearHoverHandles");
            this.hoveredPart = part;
            this.hoverModel = (HoverModel)part.getViewer().getAdapter(HoverModel.class);
            this.hoverBehavior = (HoverBehavior)part.getRoot().getAdapter(HoverBehavior.class);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.hoverModel.getHover() == this.hoveredPart) {
                this.hoverModel.clearHover();
                this.hoverBehavior.deactivate();
                this.hoverBehavior.activate();
            }
            return Status.OK_STATUS;
        }

        public boolean isContentRelevant() {
            return false;
        }

        public boolean isNoOp() {
            return false;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }
}

