/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.internal.ui.rulers.GuideFigure;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.swt.graphics.Cursor;

public class RulerDragTracker
extends SimpleDragTracker {
    protected RulerEditPart source;
    private IFigure guide;
    private IFigure guideline;

    public RulerDragTracker(RulerEditPart source) {
        this.source = source;
        this.guide = new GuideFigure(!source.isHorizontal());
        this.guide.setVisible(false);
        this.guideline = new GuideEditPart.GuideLineFigure();
        this.guideline.setVisible(false);
    }

    @Override
    protected void eraseSourceFeedback() {
        if (this.guide.getParent() != null) {
            this.guide.getParent().remove(this.guide);
        }
        if (this.guideline.getParent() != null) {
            this.guideline.getParent().remove(this.guideline);
        }
    }

    @Override
    protected Command getCommand() {
        if (this.isCreationValid() && !this.isDelete()) {
            return this.source.getRulerProvider().getCreateGuideCommand(this.getCurrentPosition());
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    protected String getCommandName() {
        return "create child";
    }

    protected int getCurrentPositionZoomed() {
        Point pt = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)pt);
        int position = this.source.isHorizontal() ? pt.x : pt.y;
        return position;
    }

    protected int getCurrentPosition() {
        int position = this.getCurrentPositionZoomed();
        ZoomManager zoomManager = this.source.getZoomManager();
        if (zoomManager != null) {
            position = (int)Math.round((double)position / zoomManager.getZoom());
        }
        return position;
    }

    @Override
    protected String getDebugName() {
        return "Guide creation";
    }

    @Override
    protected Cursor getDefaultCursor() {
        if (this.isDelete()) {
            return super.getDefaultCursor();
        }
        if (this.isCreationValid()) {
            return this.source.isHorizontal() ? SharedCursors.SIZEE : SharedCursors.SIZEN;
        }
        return SharedCursors.NO;
    }

    @Override
    protected boolean handleButtonDown(int button) {
        this.stateTransition(1, 4);
        this.showSourceFeedback();
        return true;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        return true;
    }

    protected boolean isCreationValid() {
        if (this.getState() == 8) {
            return false;
        }
        int position = this.getCurrentPosition();
        Iterator guides = this.source.getRulerProvider().getGuides().iterator();
        while (guides.hasNext()) {
            int guidePos = this.source.getRulerProvider().getGuidePosition(guides.next());
            if (Math.abs(guidePos - position) >= 5) continue;
            return false;
        }
        return true;
    }

    protected boolean isDelete() {
        int max;
        int min;
        int pos;
        if (!this.source.isHorizontal()) {
            pos = this.getLocation().x;
            Rectangle zone = this.guide.getBounds().getExpanded(20, 0);
            min = zone.x;
            max = min + zone.width;
        } else {
            pos = this.getLocation().y;
            Rectangle zone = this.guide.getBounds().getExpanded(0, 20);
            min = zone.y;
            max = min + zone.height;
        }
        return pos < min || pos > max;
    }

    @Override
    protected boolean movedPastThreshold() {
        return true;
    }

    @Override
    protected void showSourceFeedback() {
        if (this.guide.getParent() == null) {
            this.getCurrentViewer().deselectAll();
            this.source.getFigure().add(this.guide);
        }
        if (this.guideline.getParent() == null) {
            this.source.getGuideLayer().add(this.guideline);
        }
        this.source.setLayoutConstraint(null, this.guide, new Integer(this.getCurrentPositionZoomed()));
        Rectangle bounds = Rectangle.SINGLETON;
        if (this.source.isHorizontal()) {
            bounds.x = this.getCurrentPositionZoomed();
            bounds.y = this.source.getGuideLayer().getBounds().y;
            bounds.width = 1;
            bounds.height = this.source.getGuideLayer().getBounds().height;
        } else {
            bounds.x = this.source.getGuideLayer().getBounds().x;
            bounds.y = this.getCurrentPositionZoomed();
            bounds.width = this.source.getGuideLayer().getBounds().width;
            bounds.height = 1;
        }
        this.guideline.setBounds(bounds);
        this.guide.setVisible(this.isCreationValid() && !this.isDelete());
        this.guideline.setVisible(this.isCreationValid() && !this.isDelete());
        this.guideline.validate();
    }
}

