/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.archive.ArchiveFormats;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_archive")
class Archive
extends TextBuiltin {
    @Argument(index=0, metaVar="metaVar_treeish")
    private ObjectId tree;
    @Option(name="--format", metaVar="metaVar_archiveFormat", usage="usage_archiveFormat")
    private String format;
    @Option(name="--prefix", metaVar="metaVar_archivePrefix", usage="usage_archivePrefix")
    private String prefix;
    @Option(name="--output", aliases={"-o"}, metaVar="metaVar_file", usage="usage_archiveOutput")
    private String output;

    static {
        ArchiveFormats.registerAll();
    }

    Archive() {
    }

    @Override
    protected void run() throws Exception {
        if (this.tree == null) {
            throw Archive.die(CLIText.get().treeIsRequired);
        }
        OutputStream stream = null;
        try {
            try {
                stream = this.output != null ? new FileOutputStream(this.output) : this.outs;
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (Git git = new Git(this.db);){
                        ArchiveCommand cmd = git.archive().setTree(this.tree).setFormat(this.format).setPrefix(this.prefix).setOutputStream(stream);
                        if (this.output != null) {
                            cmd.setFilename(this.output);
                        }
                        cmd.call();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    throw Archive.die(e.getMessage(), (Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                throw Archive.die(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (this.output != null && stream != null) {
                stream.close();
            }
        }
    }
}

