/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.wizards.NoExecutableWizardPage;
import org.eclipse.linuxtools.rpm.ui.editor.wizards.Messages;
import org.eclipse.linuxtools.rpm.ui.editor.wizards.SpecfileNewWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SpecfileNewWizard
extends Wizard
implements INewWizard {
    private SpecfileNewWizardPage page;
    private ISelection selection;

    public SpecfileNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        if (!UiUtils.fileExists("/usr/bin/rpmdev-newspec")) {
            this.addPage((IWizardPage)new NoExecutableWizardPage());
        } else {
            this.page = new SpecfileNewWizardPage(this.selection);
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean performFinish() {
        String containerName = this.page.getProjectName();
        String fileName = this.page.getFileName();
        InputStream contentInputStream = this.openContentStream();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(containerName, fileName, contentInputStream, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            SpecfileLog.logError(e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SpecfileNewWizard_0, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String projectName, String fileName, InputStream contentInputStream, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.SpecfileNewWizard_1) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(projectName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.valueOf(Messages.SpecfileNewWizard_2) + projectName + Messages.SpecfileNewWizard_3);
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = contentInputStream;
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.SpecfileNewWizard_4);
        this.getShell().getDisplay().asyncExec(() -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String contents = this.page.getContent();
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        IStatus status = Status.error((String)message);
        throw new CoreException(status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

