/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class CommentRemover {
    private CommentRemover() {
    }

    public static String execWithFile(String filename) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(filename));){
                String line;
                StringBuilder buffer = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    buffer.append(line.concat("\n"));
                }
                return CommentRemover.exec(buffer.toString(), false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String exec(String contents) {
        return CommentRemover.exec(contents, true);
    }

    private static String exec(String contents, boolean standardizeLineBreaks) {
        if (contents == null || contents.isEmpty()) {
            return "";
        }
        if (standardizeLineBreaks) {
            contents = CommentRemover.doStandardizeLineBreaks(contents);
        }
        boolean inQuotes = false;
        boolean inComment = false;
        int c = 0;
        StringBuilder buffer = new StringBuilder();
        do {
            char nxtchar;
            char curchar = contents.charAt(c++);
            char c2 = nxtchar = c < contents.length() ? contents.charAt(c) : (char)'\u0000';
            if (!inQuotes) {
                if (!inComment) {
                    if (curchar == '#' || curchar == '/' && nxtchar == '/') {
                        buffer.append('\n');
                        c = contents.indexOf(10, c);
                        if (c == -1) break;
                        ++c;
                        continue;
                    }
                    if (curchar == '/' && nxtchar == '*') {
                        inComment = true;
                        ++c;
                        continue;
                    }
                } else if (curchar == '*' && nxtchar == '/') {
                    inComment = false;
                    ++c;
                    continue;
                }
            }
            if (!inComment) {
                if (curchar == '\"') {
                    inQuotes = !inQuotes;
                } else if (curchar == '\n' && inQuotes) {
                    inQuotes = false;
                }
                buffer.append(curchar);
                continue;
            }
            if (curchar != '\n') continue;
            buffer.append(curchar);
        } while (c < contents.length());
        return buffer.toString();
    }

    private static String doStandardizeLineBreaks(String contents) {
        return contents.replaceAll("(\\r\\n)|(\\n)", "\n");
    }
}

