/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.uicore.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.modisco.infra.browser.uicore.internal.adapters.ElementID;
import org.eclipse.modisco.infra.browser.uicore.internal.adapters.ElementIDAdapterFactory;
import org.eclipse.modisco.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.modisco.infra.browser.uicore.internal.extensions.IconProvidersRegistry;
import org.eclipse.modisco.infra.browser.uicore.internal.extensions.NameProvidersRegistry;
import org.eclipse.modisco.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.BigListItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ContainerLink;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.URIAttribute;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.common.core.internal.utils.StringUtils;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.FacetAttribute;
import org.eclipse.modisco.infra.facet.FacetReference;
import org.eclipse.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.modisco.infra.facet.Shortcut;
import org.eclipse.modisco.infra.facet.core.FacetContext;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

@Deprecated
public class ModelElementItem
implements ITreeElement,
IAdaptable {
    private final AppearanceConfiguration appearanceConfiguration;
    private final EObject fModelElement;
    private ITreeElement treeParent;
    private int order = -1;
    private final HashMap<EReference, LinkItem> linkItems = new HashMap();
    private final HashMap<EAttribute, AttributeItem> attributeItems = new HashMap();
    private ContainerLink containmentLinkItem = null;
    private EObject oldContainer = null;
    private URIAttribute uriAttribute = null;
    private final FacetContext facetContext;
    private int cachedChildrenModCount = -1;
    private List<Object> cachedChildren = null;

    public ModelElementItem(EObject eObject, ITreeElement treeParent, AppearanceConfiguration appearanceConfiguration) {
        if (eObject == null) {
            throw new IllegalArgumentException("eObject is null");
        }
        this.fModelElement = eObject;
        this.treeParent = treeParent;
        this.appearanceConfiguration = appearanceConfiguration;
        this.facetContext = appearanceConfiguration.getFacetContext();
    }

    public synchronized List<Object> getChildren() {
        if (this.cachedChildren == null || this.cachedChildrenModCount != this.appearanceConfiguration.getModCount()) {
            this.cachedChildren = new ArrayList<Object>();
            if (this.appearanceConfiguration.isShowContainer()) {
                this.addContainer(this.fModelElement, this.cachedChildren);
            }
            if (this.appearanceConfiguration.isShowURI()) {
                this.addURIAttribute(this.cachedChildren);
            }
            this.addVirtualElements(this.cachedChildren);
            if (this.appearanceConfiguration.isShowAttributes()) {
                List<AttributeItem> attributes = this.createAttributes();
                if (this.appearanceConfiguration.isSortLinks()) {
                    this.sortAttributes(attributes);
                }
                this.cachedChildren.addAll(attributes);
            }
            ArrayList<Object> elementsInCollapsedLinks = new ArrayList<Object>();
            ArrayList<LinkItem> links = this.createLinks(elementsInCollapsedLinks);
            CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
            ListIterator<Object> listIterator = elementsInCollapsedLinks.listIterator();
            while (listIterator.hasNext()) {
                ModelElementItem modelElementItem;
                EObject eObject;
                Object next = listIterator.next();
                if (!(next instanceof ModelElementItem) || customizationEngine.isTypeVisible((eObject = (modelElementItem = (ModelElementItem)next).getEObject()).eClass(), eObject)) continue;
                listIterator.remove();
            }
            if (this.appearanceConfiguration.isSortInstances()) {
                BigListItem.sortElements(elementsInCollapsedLinks);
            }
            this.cachedChildren.addAll(elementsInCollapsedLinks);
            if (this.appearanceConfiguration.isSortLinks()) {
                this.sortLinks(links);
            }
            if (this.appearanceConfiguration.isSortLinksByType()) {
                this.sortLinksByType(links);
            }
            this.cachedChildren.addAll(links);
            this.cachedChildrenModCount = this.appearanceConfiguration.getModCount();
        }
        return this.cachedChildren;
    }

    protected void addVirtualElements(List<Object> children) {
    }

    private List<AttributeItem> createAttributes() {
        ArrayList<AttributeItem> attributes = new ArrayList<AttributeItem>();
        EClass eClass = this.fModelElement.eClass();
        BasicEList allAttributes = new BasicEList();
        allAttributes.addAll((Collection)eClass.getEAllAttributes());
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        try {
            EList allAttributes2 = this.facetContext.getAttributes(this.fModelElement);
            allAttributes.addAll((Collection)allAttributes2);
        }
        catch (ModelQueryException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        for (EAttribute attribute : allAttributes) {
            EClass containingEClass = attribute instanceof FacetAttribute ? attribute.getEContainingClass() : eClass;
            if (!customizationEngine.isAttributeVisible(containingEClass, attribute.getName(), this.fModelElement)) continue;
            boolean empty = false;
            if (!this.appearanceConfiguration.isShowEmptyAttributes()) {
                Object value = this.localEGet((EStructuralFeature)attribute);
                if (attribute.isMany()) {
                    empty = ((List)value).size() == 0;
                } else {
                    boolean bl = empty = value == null;
                }
            }
            if (!this.appearanceConfiguration.isShowEmptyAttributes() && empty) continue;
            AttributeItem attributeItem = this.attributeItems.get(attribute);
            if (attributeItem == null) {
                attributeItem = new AttributeItem(this.fModelElement, this, attribute, this.appearanceConfiguration);
                this.attributeItems.put(attribute, attributeItem);
            }
            attributes.add(attributeItem);
        }
        return attributes;
    }

    private ArrayList<LinkItem> createLinks(List<Object> elementsInCollapsedLinks) {
        ArrayList<LinkItem> links = new ArrayList<LinkItem>();
        EClass eClass = this.fModelElement.eClass();
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        ArrayList allReferences = new ArrayList();
        allReferences.addAll(eClass.getEAllReferences());
        try {
            allReferences.addAll(this.facetContext.getReferences(this.fModelElement));
        }
        catch (ModelQueryException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        for (EReference reference : allReferences) {
            EClass containingEClass = reference instanceof FacetReference ? reference.getEContainingClass() : this.fModelElement.eClass();
            if (customizationEngine.isLinkCollapsed(containingEClass, reference)) {
                Object ref = this.localEGet((EStructuralFeature)reference);
                if (reference.isMany()) {
                    List childrenList = (List)ref;
                    if (childrenList == null) continue;
                    for (EObject eObject : childrenList) {
                        ModelElementItem modelElementItem = this.appearanceConfiguration.getItemsFactory().createModelElementItem(eObject, this, this.appearanceConfiguration);
                        elementsInCollapsedLinks.add(modelElementItem);
                    }
                    continue;
                }
                if (!(ref instanceof EObject)) continue;
                EObject eObject = (EObject)ref;
                ModelElementItem modelElementItem = this.appearanceConfiguration.getItemsFactory().createModelElementItem(eObject, this, this.appearanceConfiguration);
                elementsInCollapsedLinks.add(modelElementItem);
                continue;
            }
            if (!customizationEngine.isReferenceVisible(containingEClass, reference.getName(), this.fModelElement) || reference.isDerived() && !this.appearanceConfiguration.isShowDerivedLinks()) continue;
            LinkItem linkItem = this.linkItems.get(reference);
            if (linkItem == null) {
                linkItem = this.appearanceConfiguration.getItemsFactory().createLinkItem(this.fModelElement, this, reference, this.appearanceConfiguration);
                this.linkItems.put(reference, linkItem);
            }
            if (!this.appearanceConfiguration.isShowEmptyLinks() && !linkItem.hasChildren()) continue;
            links.add(linkItem);
        }
        return links;
    }

    private void addContainer(EObject eObject, List<Object> children) {
        if (eObject.eContainer() != null) {
            if (this.containmentLinkItem == null || this.oldContainer != eObject.eContainer()) {
                this.containmentLinkItem = new ContainerLink(eObject, this, eObject.eContainer(), this.appearanceConfiguration);
                this.oldContainer = eObject.eContainer();
            }
            children.add(this.containmentLinkItem);
        } else if (this.appearanceConfiguration.isShowEmptyLinks()) {
            this.containmentLinkItem = new ContainerLink(eObject, this, null, this.appearanceConfiguration);
            this.oldContainer = null;
            children.add(this.containmentLinkItem);
        }
    }

    private void addURIAttribute(List<Object> children) {
        if (this.uriAttribute == null) {
            this.uriAttribute = new URIAttribute(this.fModelElement, this.treeParent, this.appearanceConfiguration);
        }
        children.add(this.uriAttribute);
    }

    private void sortLinks(List<LinkItem> links) {
        Collections.sort(links, new Comparator<LinkItem>(){

            @Override
            public int compare(LinkItem o1, LinkItem o2) {
                String name1 = o1.getReference().getName();
                String name2 = o2.getReference().getName();
                return name1.compareTo(name2);
            }
        });
    }

    private void sortLinksByType(List<LinkItem> links) {
        Collections.sort(links, new Comparator<LinkItem>(){

            @Override
            public int compare(LinkItem o1, LinkItem o2) {
                int r1 = ModelElementItem.getReferenceRank(o1.getReference());
                int r2 = ModelElementItem.getReferenceRank(o2.getReference());
                return r1 - r2;
            }
        });
    }

    public static int getReferenceRank(EReference reference) {
        EReference opposite = reference.getEOpposite();
        boolean rankContainmentAndOpposite = false;
        int rankContainment = 10;
        int rankOppositeContainment = 20;
        int rankOpposite = 30;
        int rankOther = 40;
        int rank = reference.isContainment() ? (opposite != null ? 0 : 10) : (opposite != null ? (opposite.isContainment() ? 20 : 30) : 40);
        if (reference.isDerived()) {
            ++rank;
        }
        return rank;
    }

    private void sortAttributes(List<AttributeItem> attributes) {
        Collections.sort(attributes, new Comparator<AttributeItem>(){

            @Override
            public int compare(AttributeItem o1, AttributeItem o2) {
                String name1 = o1.getAttribute().getName();
                String name2 = o2.getAttribute().getName();
                return name1.compareTo(name2);
            }
        });
    }

    @Override
    public String getText() {
        EClass eClass = this.fModelElement.eClass();
        String label = this.appearanceConfiguration.isShowFullQualifiedNames() ? ModelUtils.getMetaclassQualifiedName((EClassifier)eClass) : eClass.getName();
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        boolean hideMetaclassName = customizationEngine.isHideMetaclassName(eClass, this.fModelElement);
        String ordering = this.appearanceConfiguration.isShowOrdering() && this.order != -1 ? " [" + this.order + "]" : "";
        String id = this.appearanceConfiguration.isShowElementIDs() ? " {" + this.getElementID() + "}" : "";
        String metaclass = !hideMetaclassName ? "[" + label + "] " : "";
        return String.valueOf(metaclass) + this.getName() + ordering + id;
    }

    public long getElementID() {
        ElementID elementID = (ElementID)ElementIDAdapterFactory.getInstance().adapt((Notifier)this.fModelElement, ElementID.class);
        return elementID.getID();
    }

    public String getName() {
        return ModelElementItem.getDisplayName(this.fModelElement, this.appearanceConfiguration);
    }

    public static String getDisplayName(EObject eObject, AppearanceConfiguration appearanceConfiguration) {
        CustomizationEngine customizationEngine = appearanceConfiguration.getCustomizationEngine();
        String customizedLabel = customizationEngine.getTypeLabel(eObject);
        if (customizedLabel != null) {
            return customizedLabel;
        }
        String providedName = ModelElementItem.getProvidedName(eObject);
        if (providedName != null) {
            return providedName;
        }
        String nameFromRegistry = ModelElementItem.getNameFromAdapter(eObject, (AdapterFactory)appearanceConfiguration.getAdapterFactory());
        if (nameFromRegistry != null) {
            return nameFromRegistry;
        }
        return ModelUtils.getDefaultName((EObject)eObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNameFromAdapter(EObject eObject, AdapterFactory adapter) {
        IItemLabelProvider itemLabelProvider;
        EObject eObject2 = eObject;
        synchronized (eObject2) {
            itemLabelProvider = (IItemLabelProvider)adapter.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        if (itemLabelProvider instanceof ReflectiveItemProvider) {
            return null;
        }
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return null;
    }

    public static String getProvidedName(EObject eObject) {
        NameProvidersRegistry nameProvidersRegistry = NameProvidersRegistry.getInstance();
        String name = nameProvidersRegistry.getName(eObject);
        if (name != null) {
            return StringUtils.truncateBeforeNewline((String)name);
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Color getForeground() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getTypeColor(this.fModelElement);
        if (color != null) {
            return color;
        }
        return null;
    }

    @Override
    public Color getBackground() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getTypeBackgroundColor(this.fModelElement);
        if (color != null) {
            return color;
        }
        return null;
    }

    @Override
    public Font getFont() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Font customizedFont = customizationEngine.getCustomizedTypeFont(this.fModelElement, this.appearanceConfiguration.getCustomFont());
        if (customizedFont != null) {
            return customizedFont;
        }
        return null;
    }

    @Override
    public Image getImage() {
        Image image = ModelElementItem.getImageFor(this.fModelElement, this.appearanceConfiguration);
        if (image != null) {
            return image;
        }
        String className = this.fModelElement.eClass().getName();
        URI imageURI = URI.createURI((String)(String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/obj16/Item").toString()) + "#" + className));
        return ExtendedImageRegistry.getInstance().getImage((Object)imageURI);
    }

    public static Image getImageFor(EObject eObject, AppearanceConfiguration appearanceConfiguration) {
        try {
            CustomizationEngine customizationEngine = appearanceConfiguration.getCustomizationEngine();
            for (Facet facet : appearanceConfiguration.getFacetContext().getFacets(eObject)) {
                Image customizedIcon = customizationEngine.getInstanceIcon(eObject, (EClass)facet);
                if (customizedIcon != null) {
                    return customizedIcon;
                }
                Image customizedIcon2 = customizationEngine.getFacetMainIcon(eObject, (EClass)facet);
                if (customizedIcon2 == null) continue;
                return customizedIcon2;
            }
            Image customizedIcon = customizationEngine.getInstanceIcon(eObject, eObject.eClass());
            if (customizedIcon != null) {
                return customizedIcon;
            }
            Image customizedIcon2 = customizationEngine.getTypeIcon(eObject, eObject.eClass());
            if (customizedIcon2 != null) {
                return customizedIcon2;
            }
            IconProvidersRegistry iconProvidersRegistry = IconProvidersRegistry.getInstance();
            Image icon = iconProvidersRegistry.getIcon(eObject);
            if (icon != null) {
                return icon;
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)appearanceConfiguration.getAdapterFactory().adapt((Notifier)eObject, IItemLabelProvider.class);
            if (itemLabelProvider != null) {
                Object image = itemLabelProvider.getImage((Object)eObject);
                return ExtendedImageRegistry.getInstance().getImage(image);
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error retrieving image", (Plugin)Activator.getDefault());
        }
        return null;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    public void setTreeParent(ITreeElement treeParent) {
        this.treeParent = treeParent;
    }

    public EObject getEObject() {
        return this.fModelElement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelElementItem) {
            ModelElementItem other = (ModelElementItem)obj;
            return this.fModelElement.equals(other.fModelElement);
        }
        return false;
    }

    public int hashCode() {
        return this.fModelElement.hashCode();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object localEGet(EStructuralFeature structuralFeature) {
        Object result = null;
        if (structuralFeature instanceof FacetStructuralFeature || structuralFeature instanceof Shortcut) {
            try {
                result = this.facetContext.get(this.fModelElement, structuralFeature);
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                result = null;
            }
        } else {
            try {
                Resource e = this.fModelElement.eResource();
                synchronized (e) {
                    result = this.fModelElement.eGet(structuralFeature);
                }
            }
            catch (Exception e) {
                MoDiscoLogger.logError((String)("Error getting value of feature '" + ((ENamedElement)structuralFeature.eContainer()).getName() + "::" + structuralFeature.getName() + "' on instance of '" + this.fModelElement.eClass().getName() + "'"), (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EObject.class) {
            return this.fModelElement;
        }
        return null;
    }

    public AppearanceConfiguration getAppearanceConfiguration() {
        return this.appearanceConfiguration;
    }

    public String toString() {
        return String.valueOf(ModelElementItem.class.getSimpleName()) + "(" + this.getText() + ")";
    }
}

