/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class DefinitionListBlock
extends Block {
    private static final Pattern START_PATTERN = Pattern.compile("\\s*([^\\s:][^:]+)(:{2,})(?:(?:\\s+(.+))|(?:$))");
    private Matcher matcher;
    private boolean blockItemIsOpen;
    private boolean lastLineWasEmpty;
    private final Deque<Integer> levels = new ArrayDeque<Integer>();

    protected int processLineContent(String line, int offset) {
        if (this.matcher.reset(line).matches()) {
            this.handleItem();
            return -1;
        }
        if (line.isEmpty()) {
            this.lastLineWasEmpty = true;
            return -1;
        }
        if (this.lastLineWasEmpty && this.blockItemIsOpen) {
            this.lastLineWasEmpty = false;
            this.setClosed(true);
            return 0;
        }
        this.lastLineWasEmpty = false;
        if (!this.blockItemIsOpen) {
            this.openItemBlock(line, 0);
        } else {
            this.builder.characters(" ");
            this.markupLanguage.emitMarkupLine(this.parser, this.state, 0, line, 0);
        }
        return -1;
    }

    private void handleItem() {
        String key = this.matcher.group(1);
        String value = this.matcher.group(3);
        int keyOffset = this.matcher.start(1);
        int level = this.matcher.group(2).length();
        if (this.isCurrentLevel(level)) {
            this.closeItemBlockIfOpen();
        } else if (this.isNewLevel(level)) {
            this.openLevel(level);
        } else {
            this.dropToLevel(level);
        }
        this.state.setLineCharacterOffset(keyOffset);
        this.state.setLineSegmentEndOffset(keyOffset + key.length());
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes(null, "hdlist1", null, null));
        this.markupLanguage.emitMarkupLine(this.parser, this.state, keyOffset, key, 0);
        this.builder.endBlock();
        if (value != null) {
            int valueOffset = this.matcher.start(3);
            this.openItemBlock(value, valueOffset);
        }
    }

    private void openLevel(int level) {
        if (!this.isCurrentLevel(0) && !this.blockItemIsOpen) {
            this.openItemBlock("", 0);
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, (Attributes)new ListAttributes());
        this.levels.push(level);
        this.blockItemIsOpen = false;
    }

    private boolean isCurrentLevel(int level) {
        return this.levels.isEmpty() ? level == 0 : this.levels.peek().equals(level);
    }

    private boolean isNewLevel(int level) {
        return !this.levels.contains(level);
    }

    private void dropToLevel(int level) {
        this.closeItemBlockIfOpen();
        while (!this.levels.isEmpty() && !this.levels.peek().equals(level)) {
            this.builder.endBlock();
            this.levels.pop();
            if (this.isCurrentLevel(0)) continue;
            this.builder.endBlock();
        }
    }

    private void openItemBlock(String value, int valueOffset) {
        this.state.setLineCharacterOffset(valueOffset);
        this.state.setLineSegmentEndOffset(valueOffset + value.length());
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
        this.markupLanguage.emitMarkupLine(this.parser, this.state, valueOffset, value, 0);
        this.blockItemIsOpen = true;
    }

    private void closeItemBlockIfOpen() {
        if (this.blockItemIsOpen) {
            this.builder.endBlock();
            this.blockItemIsOpen = false;
        }
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = START_PATTERN.matcher(line);
            if (this.matcher.matches()) {
                this.lastLineWasEmpty = false;
                return true;
            }
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.dropToLevel(0);
        }
        super.setClosed(closed);
    }
}

