/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ParameterizedBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class ColorBlock
extends ParameterizedBlock {
    private final Pattern startPattern;
    private final Pattern endPattern;
    private final DocumentBuilder.BlockType blockType = DocumentBuilder.BlockType.DIV;
    private int blockLineCount = 0;
    private Matcher matcher;
    private boolean nesting = false;
    private String color;

    public ColorBlock() {
        this.startPattern = Pattern.compile("^\\{color(?::([^\\}]*))?\\}(.*)");
        this.endPattern = Pattern.compile("(\\{color\\})(.*)");
    }

    public int processLineContent(String line, int offset) {
        int end = line.length();
        if (this.blockLineCount == 0) {
            this.setOptions(this.matcher.group(1));
            Attributes attributes = new Attributes();
            if (this.color != null) {
                attributes.setCssStyle(String.format("color: %s;", this.color));
            }
            offset = this.matcher.start(2);
            this.builder.beginBlock(this.blockType, attributes);
            this.nesting = true;
            end = offset;
        } else {
            boolean terminating = false;
            Matcher endMatcher = this.endPattern.matcher(line);
            if (offset < end) {
                if (offset > 0) {
                    endMatcher.region(offset, end);
                }
                if (endMatcher.find()) {
                    terminating = true;
                    end = endMatcher.start(2);
                } else {
                    end = offset;
                }
            }
            if (terminating) {
                this.setClosed(true);
            }
        }
        ++this.blockLineCount;
        return end == line.length() ? -1 : end;
    }

    public boolean beginNesting() {
        return this.nesting;
    }

    public int findCloseOffset(String line, int lineOffset) {
        Matcher endMatcher = this.endPattern.matcher(line);
        if (lineOffset != 0) {
            endMatcher.region(lineOffset, line.length());
        }
        if (endMatcher.find()) {
            return endMatcher.start();
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset > 0) {
            return false;
        }
        this.blockLineCount = 0;
        this.color = null;
        this.nesting = false;
        this.matcher = this.startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    @Override
    protected void setOption(String option) {
        this.color = option;
    }

    @Override
    protected void setOption(String key, String value) {
    }
}

