/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.pages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.ocl.examples.debug.vm.ui.pages.SWTFactory;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class VMBreakpointPage
extends PropertyPage {
    protected Button fEnabledButton;
    protected Button fHitCountButton;
    protected Text fHitCountText;
    protected Combo fSuspendPolicy;
    protected List<String> fErrorMessages = new ArrayList<String>();
    public static final String ATTR_DELETE_ON_CANCEL = "org.eclipse.ocl.examples.debug.vm.ui.ATTR_DELETE_ON_CANCEL";
    protected static final String EMPTY_STRING = "";
    private static final String fgHitCountErrorMessage = DebugVMUIMessages.BreakpointPage_HitCountErrorMessage;

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean delOnCancel;
                VMLineBreakpoint breakpoint = VMBreakpointPage.this.getBreakpoint();
                boolean bl = delOnCancel = breakpoint.getMarker().getAttribute(VMBreakpointPage.ATTR_DELETE_ON_CANCEL) != null;
                if (delOnCancel) {
                    breakpoint.getMarker().setAttribute(VMBreakpointPage.ATTR_DELETE_ON_CANCEL, null);
                    breakpoint.setRegistered(true);
                }
                VMBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            DebugVMUIPlugin.statusDialog(e.getStatus());
            DebugVMUIPlugin.log(e);
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage(this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected void doStore() throws CoreException {
        VMLineBreakpoint breakpoint = this.getBreakpoint();
        this.storeHitCount(breakpoint);
        this.storeEnabled(breakpoint);
    }

    private void storeEnabled(VMLineBreakpoint breakpoint) throws CoreException {
        breakpoint.setEnabled(this.fEnabledButton.getSelection());
    }

    private void storeHitCount(VMLineBreakpoint breakpoint) throws CoreException {
        int hitCount = -1;
        if (this.fHitCountButton.getSelection()) {
            try {
                hitCount = Integer.parseInt(this.fHitCountText.getText());
            }
            catch (NumberFormatException e) {
                DebugVMUIPlugin.log((IStatus)new Status(4, "org.eclipse.ocl.examples.debug.vm.ui", 4, MessageFormat.format("JavaBreakpointPage allowed input of invalid string for hit count value: {0}.", this.fHitCountText.getText()), (Throwable)e));
            }
        }
        breakpoint.setHitCount(hitCount);
    }

    protected Control createContents(Composite parent) {
        this.setTitle(DebugVMUIMessages.BreakpointPage_ModulePrepareBreakpoint);
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        try {
            this.createLabels(mainComposite);
            this.createEnabledButton(mainComposite);
            this.createHitCountEditor(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
        }
        catch (CoreException e) {
            DebugVMUIPlugin.log(e);
        }
        this.setValid(true);
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getShell().addShellListener(new ShellListener(){

                    public void shellActivated(ShellEvent e) {
                        Shell shell = (Shell)e.getSource();
                        shell.setText(MessageFormat.format(DebugVMUIMessages.BreakpointPage_CreateBreakpointForModule, VMBreakpointPage.this.getName((IAdaptable)VMBreakpointPage.this.getBreakpoint())));
                        shell.removeShellListener((ShellListener)this);
                    }

                    public void shellClosed(ShellEvent e) {
                    }

                    public void shellDeactivated(ShellEvent e) {
                    }

                    public void shellDeiconified(ShellEvent e) {
                    }

                    public void shellIconified(ShellEvent e) {
                    }
                });
            }
        }
        catch (CoreException e) {
            DebugVMUIPlugin.log(e);
        }
        return mainComposite;
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)ClassUtil.getAdapter((IAdaptable)element, IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getLabel((Object)element);
        }
        return EMPTY_STRING;
    }

    protected void createLabels(Composite parent) throws CoreException {
        Composite labelComposite = this.createComposite(parent, 2);
        String typeName = this.getBreakpoint().getUnitURI().toPlatformString(true);
        if (typeName != null) {
            this.createLabel(labelComposite, DebugVMUIMessages.BreakpointPage_Module);
            Text text = SWTFactory.createText(labelComposite, 8, 1, typeName);
            text.setBackground(parent.getBackground());
        }
        this.createTypeSpecificLabels(labelComposite);
    }

    private void createHitCountEditor(Composite parent) throws CoreException {
        Composite hitCountComposite = this.createComposite(parent, 2);
        this.fHitCountButton = this.createCheckButton(hitCountComposite, DebugVMUIMessages.BreakpointPage_HitCount);
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VMBreakpointPage.this.fHitCountText.setEnabled(VMBreakpointPage.this.fHitCountButton.getSelection());
                VMBreakpointPage.this.hitCountChanged();
            }
        });
        int hitCount = this.getBreakpoint().getHitCount();
        String hitCountString = EMPTY_STRING;
        if (hitCount > 0) {
            hitCountString = Integer.valueOf(hitCount).toString();
            this.fHitCountButton.setSelection(true);
        } else {
            this.fHitCountButton.setSelection(false);
        }
        this.fHitCountText = this.createText(hitCountComposite, hitCountString);
        if (hitCount <= 0) {
            this.fHitCountText.setEnabled(false);
        }
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VMBreakpointPage.this.hitCountChanged();
            }
        });
    }

    private void hitCountChanged() {
        if (!this.fHitCountButton.getSelection()) {
            this.removeErrorMessage(fgHitCountErrorMessage);
            return;
        }
        String hitCountText = this.fHitCountText.getText();
        int hitCount = -1;
        try {
            hitCount = Integer.parseInt(hitCountText);
        }
        catch (NumberFormatException e1) {
            this.addErrorMessage(fgHitCountErrorMessage);
            return;
        }
        if (hitCount < 1) {
            this.addErrorMessage(fgHitCountErrorMessage);
        } else {
            this.removeErrorMessage(fgHitCountErrorMessage);
        }
    }

    protected void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, DebugVMUIMessages.BreakpointPage_Enabled);
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected VMLineBreakpoint getBreakpoint() {
        return (VMLineBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
    }

    protected Text createText(Composite parent, String initialValue) {
        return SWTFactory.createText(parent, 2052, 1, initialValue);
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        return SWTFactory.createComposite(parent, parent.getFont(), numColumns, 1, 768, 0, 0);
    }

    protected Button createCheckButton(Composite parent, String text) {
        return SWTFactory.createCheckButton(parent, text, null, false, 1);
    }

    protected Label createLabel(Composite parent, String text) {
        return SWTFactory.createLabel(parent, text, 1);
    }

    protected Button createRadioButton(Composite parent, String text) {
        return SWTFactory.createRadioButton(parent, text, 1);
    }

    public boolean performCancel() {
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getBreakpoint().delete();
            }
        }
        catch (CoreException e) {
            DebugVMUIPlugin.statusDialog(DebugVMUIMessages.BreakpointPage_CancelBreakpointCreationError, e.getStatus());
        }
        return super.performCancel();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }
}

