/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public final class AbsoftErrorParser
implements IErrorParser {
    private Pattern errorLineRegex = Pattern.compile("\\S+ f90fe: ERROR \\S+, File = (\\S+), Line = (\\d+), Column = \\d+");
    private boolean expectingErrorMessage = false;
    private Matcher errorLineMatcher = null;
    private String filename = null;
    private int lineNum = 0;

    public boolean processLine(String thisLine, ErrorParserManager eoParser) {
        if (this.isErrorLine(thisLine)) {
            this.rememberInfoFromErrorLine(thisLine);
            this.expectingErrorMessage = true;
        } else if (this.expectingErrorMessage) {
            this.generateMarker(thisLine, eoParser);
            this.expectingErrorMessage = false;
        }
        return false;
    }

    private boolean isErrorLine(String thisLine) {
        this.errorLineMatcher = this.errorLineRegex.matcher(thisLine);
        return this.errorLineMatcher.matches();
    }

    private void rememberInfoFromErrorLine(String thisLine) {
        this.filename = this.errorLineMatcher.group(1);
        this.lineNum = Integer.parseInt(this.errorLineMatcher.group(2));
    }

    private void generateMarker(String lineContainingErrorMessage, ErrorParserManager eoParser) {
        String errorMessage = lineContainingErrorMessage.trim();
        IFile file = eoParser.findFilePath(this.filename);
        eoParser.generateMarker((IResource)file, this.lineNum, errorMessage, 2, null);
    }
}

