/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerServerSettings;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class ZendDebuggerSettingsUtil {
    private ZendDebuggerSettingsUtil() {
    }

    public static String getDebugHosts(String phpServerId) {
        IDebuggerSettings debuggerSettings = DebuggerSettingsManager.INSTANCE.findSettings(phpServerId, "org.eclipse.php.debug.core.zendDebugger");
        String debugHosts = "";
        if (debuggerSettings instanceof ZendDebuggerServerSettings) {
            debugHosts = debuggerSettings.getAttribute("clientIp");
        }
        return debugHosts;
    }

    public static int getResponseTimeout(DebugSessionStartedNotification startedNotification) {
        String debugQuery = startedNotification.getQuery();
        String originalURLTrigger = "&original_url=";
        int originalURLStart = debugQuery.indexOf(originalURLTrigger);
        String originalURL = debugQuery.substring(originalURLStart + originalURLTrigger.length());
        int responseTimeout = -1;
        try {
            URL uRL = new URL(originalURL);
        }
        catch (MalformedURLException ex) {
            return responseTimeout;
        }
        Server server = ServersManager.findByURL((String)originalURL);
        if (server != null) {
            IDebuggerSettings debuggerSettings = DebuggerSettingsManager.INSTANCE.findSettings(server.getUniqueId(), "org.eclipse.php.debug.core.zendDebugger");
            String debugClientPort = null;
            if (debuggerSettings instanceof ZendDebuggerServerSettings) {
                debugClientPort = debuggerSettings.getAttribute("responseTimeout");
            }
            try {
                responseTimeout = Integer.valueOf(debugClientPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseTimeout;
    }

    public static int getDebugPort(String phpServerOrExeId) {
        IDebuggerSettings debuggerSettings = DebuggerSettingsManager.INSTANCE.findSettings(phpServerOrExeId, "org.eclipse.php.debug.core.zendDebugger");
        String debugClientPort = null;
        debugClientPort = debuggerSettings.getAttribute("clientPort");
        int debugPort = -1;
        try {
            debugPort = Integer.valueOf(debugClientPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return debugPort;
    }
}

