/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsUtil;
import org.eclipse.php.internal.debug.core.zend.model.PHPValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class WatchExpressionFactoryAdapter
implements IWatchExpressionFactoryAdapter {
    private final String STATIC_MEMBER_PATTERN = "{0}::${1}";

    public String createWatchExpression(IVariable variable) throws CoreException {
        PHPVariable phpVariable;
        Expression expression;
        if (variable instanceof PHPVariable && (expression = (Expression)(phpVariable = (PHPVariable)variable).getAdapter(Expression.class)).hasFacet(IVariableFacet.Facet.MOD_STATIC)) {
            String className = ExpressionsUtil.fetchStaticMemberClassName(expression);
            return MessageFormat.format("{0}::${1}", className, expression.getLastName());
        }
        IValue value = variable.getValue();
        if (value instanceof PHPValue) {
            PHPValue phpValue = (PHPValue)value;
            return phpValue.getExpression().getFullName();
        }
        return variable.getName();
    }
}

