/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.formatter.core;

import org.eclipse.php.internal.formatter.core.EmbeddedCSSFormatterForPHPCode;
import org.eclipse.php.internal.formatter.core.HTMLElementFormatterForPHPCode;
import org.eclipse.php.internal.formatter.core.HTMLTextFormatterForPHPCode;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.w3c.dom.Node;

class HTMLFormatterFactoryForPHPCode {
    private static HTMLFormatterFactoryForPHPCode fInstance = null;
    protected StructuredFormatPreferencesXML fFormatPreferences = null;

    static synchronized HTMLFormatterFactoryForPHPCode getInstance() {
        if (fInstance == null) {
            fInstance = new HTMLFormatterFactoryForPHPCode();
        }
        return fInstance;
    }

    protected IStructuredFormatter createFormatter(Node node, IStructuredFormatPreferences formatPreferences) {
        Object formatter = null;
        switch (node.getNodeType()) {
            case 1: {
                formatter = new HTMLElementFormatterForPHPCode();
                break;
            }
            case 3: {
                if (this.isEmbeddedCSS(node)) {
                    formatter = new EmbeddedCSSFormatterForPHPCode();
                    break;
                }
                formatter = new HTMLTextFormatterForPHPCode();
                break;
            }
            default: {
                formatter = new HTMLFormatter();
            }
        }
        formatter.setFormatPreferences(formatPreferences);
        return formatter;
    }

    private boolean isEmbeddedCSS(Node node) {
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return false;
        }
        boolean isStyleNode = name.equalsIgnoreCase("STYLE");
        if (isStyleNode && node.getTextContent().indexOf("<?") != -1) {
            return false;
        }
        return isStyleNode;
    }

    private HTMLFormatterFactoryForPHPCode() {
    }
}

