/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ems.core;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.internal.ems.core.EMSCorePlugin;

public final class EnvManagerProjectProperties
implements IEnvManagerConfig {
    private static final QualifiedName[] PROPERTY_KEYS = new QualifiedName[]{new QualifiedName("org.eclipse.ptp.ems.core", ".envConfig"), new QualifiedName("org.eclipse.ptp.ems.core", ".envConfig2"), new QualifiedName("org.eclipse.ptp.ems.core", ".envConfig3"), new QualifiedName("org.eclipse.ptp.ems.core", ".envConfig4"), new QualifiedName("org.eclipse.ptp.ems.core", ".envConfig5")};
    private static final int MAX_PROJECT_PROPERTY_LENGTH = 2048;
    private final IProject project;

    public EnvManagerProjectProperties(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        this.project = project;
    }

    private EnvManagerConfigString loadProperties() {
        try {
            return new EnvManagerConfigString(this.assembleStringFromProperties());
        }
        catch (CoreException e) {
            EMSCorePlugin.log(e);
            throw new Error(e);
        }
    }

    private String assembleStringFromProperties() throws CoreException {
        StringBuilder sb = new StringBuilder();
        QualifiedName[] qualifiedNameArray = PROPERTY_KEYS;
        int n = PROPERTY_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            QualifiedName key = qualifiedNameArray[n2];
            sb.append(this.emptyIfNull(this.project.getPersistentProperty(key)));
            ++n2;
        }
        return sb.toString();
    }

    private String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    private void save(EnvManagerConfigString properties) {
        try {
            String[] strings = this.splitString(properties.toString());
            assert (PROPERTY_KEYS.length == strings.length);
            int i = 0;
            while (i < strings.length) {
                this.project.setPersistentProperty(PROPERTY_KEYS[i], strings[i]);
                ++i;
            }
        }
        catch (CoreException e) {
            EMSCorePlugin.log(e);
            throw new Error(e);
        }
    }

    private String[] splitString(String string) throws CoreException {
        String[] result = new String[PROPERTY_KEYS.length];
        int maxLength = PROPERTY_KEYS.length * 2048;
        if (string.length() > maxLength) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.ems.core", "Environment configuration text cannot exceed " + maxLength + " characters"));
        }
        int i = 0;
        while (i < result.length) {
            int startIndex = i * 2048;
            if (startIndex < string.length()) {
                int endIndex = Math.min(startIndex + 2048, string.length());
                result[i] = string.substring(startIndex, endIndex);
            } else {
                result[i] = "";
            }
            ++i;
        }
        return result;
    }

    @Override
    public void setEnvMgmtEnabled(boolean enabled) {
        EnvManagerConfigString properties = this.loadProperties();
        properties.setEnvMgmtEnabled(enabled);
        this.save(properties);
    }

    @Override
    public boolean isEnvMgmtEnabled() {
        return this.loadProperties().isEnvMgmtEnabled();
    }

    @Override
    public void setManualConfig(boolean enabled) {
        EnvManagerConfigString properties = this.loadProperties();
        properties.setManualConfig(enabled);
        this.save(properties);
    }

    @Override
    public boolean isManualConfigEnabled() {
        return this.loadProperties().isManualConfigEnabled();
    }

    @Override
    public void setManualConfigText(String manualConfigText) {
        EnvManagerConfigString properties = this.loadProperties();
        properties.setManualConfigText(manualConfigText);
        this.save(properties);
    }

    @Override
    public String getManualConfigText() {
        return this.loadProperties().getManualConfigText();
    }

    @Override
    public void setConnectionName(String connectionName) {
        EnvManagerConfigString properties = this.loadProperties();
        properties.setConnectionName(connectionName);
        this.save(properties);
    }

    @Override
    public String getConnectionName() {
        return this.loadProperties().getConnectionName();
    }

    @Override
    public void setConfigElements(List<String> selectedModules) {
        EnvManagerConfigString properties = this.loadProperties();
        properties.setConfigElements(selectedModules);
        this.save(properties);
    }

    @Override
    public List<String> getConfigElements() {
        return this.loadProperties().getConfigElements();
    }
}

