/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.utils.SortingUtils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.index.NamedElementCollector;

public class TestSuiteElementCollector
extends NamedElementCollector {
    private final List<IQ7NamedElement> manualyOrderedElements = new ArrayList<IQ7NamedElement>();
    private final List<IQ7NamedElement> elementsToSort = new ArrayList<IQ7NamedElement>();
    private final List<String> names;
    private final boolean respectManualOrder;
    private List<IQ7NamedElement> result;

    public TestSuiteElementCollector(List<String> names, boolean respectManualOrder) {
        this.names = names;
        this.respectManualOrder = respectManualOrder;
    }

    @Override
    public boolean visit(IQ7Element element) {
        try {
            if (element instanceof ITestSuite && (this.names.contains("*") || this.names.contains(((IQ7NamedElement)element).getElementName()))) {
                this.processSuite((ITestSuite)element);
                return false;
            }
        }
        catch (ModelException modelException) {}
        return true;
    }

    @Override
    public boolean endVisit(IQ7Element element) {
        return false;
    }

    @Override
    public List<IQ7NamedElement> getElements() {
        if (this.result == null) {
            if (this.respectManualOrder) {
                this.result = new ArrayList<IQ7NamedElement>();
                this.result.addAll(this.elementsToSort);
                SortingUtils.sortNamedElements(this.result);
                this.result.addAll(this.manualyOrderedElements);
            } else {
                this.result = this.elementsToSort;
                SortingUtils.sortNamedElements(this.result);
            }
        }
        return this.result;
    }

    private void processSuite(ITestSuite suite) {
        try {
            boolean ordered = this.respectManualOrder && suite.getTestSuite().isManuallyOrdered();
            EList items = suite.getTestSuite().getItems();
            for (TestSuiteItem testSuiteItem : items) {
                String id = testSuiteItem.getNamedElementId();
                IQ7NamedElement[] childs = suite.getQ7Project().findNamedElement(id);
                if (childs == null || childs.length <= 0) continue;
                IQ7NamedElement[] iQ7NamedElementArray = childs;
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement tcase = iQ7NamedElementArray[n2];
                    if (tcase == null) {
                        RcpttPlugin.log(String.format("Can't resolve reference %s in %s", id, testSuiteItem.getNamedElemetName()), null);
                    }
                    if (tcase instanceof ITestCase) {
                        if (ordered) {
                            this.manualyOrderedElements.add(tcase);
                        } else {
                            this.elementsToSort.add(tcase);
                        }
                    } else if (tcase instanceof ITestSuite) {
                        this.processSuite((ITestSuite)tcase);
                    }
                    ++n2;
                }
            }
            this.result = null;
        }
        catch (ModelException e) {
            RcpttPlugin.log("Failed to locate testsuite testcases:" + suite.getPath().toString(), (Throwable)((Object)e));
        }
    }
}

