/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.dispatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.dispatch.IScriptletExtension;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.dispatch.Messages;
import org.eclipse.rcptt.ecl.runtime.FQName;
import org.eclipse.rcptt.ecl.runtime.ICommandService;

public enum ScriptletExtensionManager {
    INSTANCE;

    private Map<FQName, ScriptletExtensionPack> byQname = new HashMap<FQName, ScriptletExtensionPack>();
    private Map<String, ScriptletExtensionPack> byName = new HashMap<String, ScriptletExtensionPack>();
    private static final String EXT = "org.eclipse.rcptt.ecl.dispatch.scriptletExtension";
    public static final String PLUGIN_ID = "org.eclipse.rcptt.ecl.dispatch";

    private ScriptletExtensionManager() {
        this.loadScriptlets();
    }

    private void loadScriptlets() {
        HashMap exts = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String name = config.getAttribute("name");
            String ns = config.getAttribute("namespace");
            try {
                FQName fqn = FQName.fromAttributes((String)ns, (String)name);
                if (!exts.containsKey(fqn)) {
                    exts.put(fqn, new ArrayList());
                }
                ((List)exts.get(fqn)).add(config);
            }
            catch (CoreException e) {
                CorePlugin.log((Throwable)e);
            }
            ++n2;
        }
        for (Map.Entry entry : exts.entrySet()) {
            ArrayList<IScriptletExtension> scriptlets = new ArrayList<IScriptletExtension>();
            for (IConfigurationElement element : (List)entry.getValue()) {
                try {
                    scriptlets.add((IScriptletExtension)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    CorePlugin.log((Throwable)e);
                }
            }
            FQName key = (FQName)entry.getKey();
            ScriptletExtensionPack pack = new ScriptletExtensionPack(scriptlets.toArray(new IScriptletExtension[scriptlets.size()]));
            this.byQname.put(key, pack);
            this.byName.put(key.name, pack);
        }
    }

    public ICommandService getScriptletExtension(Command scriptlet) throws CoreException {
        FQName fqn = FQName.fromCommand((Command)scriptlet);
        ScriptletExtensionPack extPack = this.byQname.get(fqn);
        if (extPack == null) {
            return null;
        }
        IScriptletExtension suitableExt = null;
        IScriptletExtension[] iScriptletExtensionArray = extPack.exts;
        int n = extPack.exts.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptletExtension ext = iScriptletExtensionArray[n2];
            if (ext.canHandle(scriptlet)) {
                if (suitableExt != null) {
                    this.errorNotUnique(FQName.fromCommand((Command)scriptlet));
                }
                suitableExt = ext;
            }
            ++n2;
        }
        return suitableExt;
    }

    private void errorNotUnique(FQName fqn) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, Messages.bind((String)Messages.NotUniqueExtension, (Object)fqn.name));
        throw new CoreException((IStatus)status);
    }

    private class ScriptletExtensionPack {
        public final IScriptletExtension[] exts;

        protected ScriptletExtensionPack(IScriptletExtension[] exts) {
            this.exts = exts;
        }
    }
}

