/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class Resources {
    public static boolean containsOnlyProjects(IResource[] resources) {
        int types = Resources.getSelectedResourceTypes(resources);
        return types == 4;
    }

    private static int getSelectedResourceTypes(IResource[] resources) {
        int types = 0;
        int i = 0;
        while (i < resources.length) {
            types |= resources[i].getType();
            ++i;
        }
        return types;
    }

    public static IStatus checkInSync(IResource resource) {
        return Resources.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = Resources.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return Status.OK_STATUS;
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, Messages.format((String)RefactoringCoreMessages.Resources_outOfSync, (Object)BasicElementLabels.getPathLabel((IPath)resource.getFullPath(), (boolean)false)), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, RefactoringCoreMessages.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }
}

