/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

class ComparisonCompactor {
    private static final String ELLIPSIS = "...";
    private int fContextLength;
    private String fExpected;
    private String fActual;
    private int fPrefix;
    private int fSuffix;

    public ComparisonCompactor(int contextLength, String expected, String actual) {
        this.fContextLength = contextLength;
        this.fExpected = expected;
        this.fActual = actual;
    }

    String compact() {
        if (this.fExpected == null || this.fActual == null || this.areStringsEqual()) {
            return ComparisonCompactor.format(this.fExpected, this.fActual);
        }
        this.findCommonPrefix();
        this.findCommonSuffix();
        String expected = this.compactString(this.fExpected);
        String actual = this.compactString(this.fActual);
        return ComparisonCompactor.format(expected, actual);
    }

    private static final String format(String expected, String actual) {
        return String.format("expected:<%s> but was:<%s>", expected, actual);
    }

    private String compactString(String source) {
        String result = source.substring(this.fPrefix, source.length() - this.fSuffix + 1);
        if (this.fPrefix > 0) {
            result = String.valueOf(this.computeCommonPrefix()) + result;
        }
        if (this.fSuffix > 0) {
            result = String.valueOf(result) + this.computeCommonSuffix();
        }
        return result;
    }

    private void findCommonPrefix() {
        this.fPrefix = 0;
        int end = Math.min(this.fExpected.length(), this.fActual.length());
        while (this.fPrefix < end) {
            if (this.fExpected.charAt(this.fPrefix) != this.fActual.charAt(this.fPrefix)) break;
            ++this.fPrefix;
        }
    }

    private void findCommonSuffix() {
        int expectedSuffix = this.fExpected.length() - 1;
        int actualSuffix = this.fActual.length() - 1;
        while (actualSuffix >= this.fPrefix && expectedSuffix >= this.fPrefix) {
            if (this.fExpected.charAt(expectedSuffix) != this.fActual.charAt(actualSuffix)) break;
            --actualSuffix;
            --expectedSuffix;
        }
        this.fSuffix = this.fExpected.length() - expectedSuffix;
    }

    private String computeCommonPrefix() {
        return String.valueOf(this.fPrefix > this.fContextLength ? ELLIPSIS : "") + this.fExpected.substring(Math.max(0, this.fPrefix - this.fContextLength), this.fPrefix);
    }

    private String computeCommonSuffix() {
        int end = Math.min(this.fExpected.length() - this.fSuffix + 1 + this.fContextLength, this.fExpected.length());
        return String.valueOf(this.fExpected.substring(this.fExpected.length() - this.fSuffix + 1, end)) + (this.fExpected.length() - this.fSuffix + 1 < this.fExpected.length() - this.fContextLength ? ELLIPSIS : "");
    }

    private boolean areStringsEqual() {
        return this.fExpected.equals(this.fActual);
    }
}

