/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.remote.telnet.core.TelnetCodes;
import org.eclipse.remote.telnet.internal.core.Logger;

class TelnetOption
implements TelnetCodes {
    protected static final String[] optionNames = new String[]{"BINARY", "ECHO", "RECONNECTION", "SUPPRESS GO AHEAD", "MSG SIZE NEGOTIATION", "STATUS", "TIMING MARK", "REMOTE CTRL TRANS+ECHO", "OUTPUT LINE WIDTH", "OUTPUT PAGE SIZE", "OUTPUT CR DISPOSITION", "OUTPUT HORIZ TABSTOPS", "OUTPUT HORIZ TAB DISPOSITION", "OUTPUT FORMFEED DISPOSITION", "OUTPUT VERTICAL TABSTOPS", "OUTPUT VT DISPOSITION", "OUTPUT LF DISPOSITION", "EXTENDED ASCII", "LOGOUT", "BYTE MACRO", "DATA ENTRY TERMINAL", "SUPDUP", "SUPDUP OUTPUT", "SEND LOCATION", "TERMINAL TYPE", "END OF RECORD", "TACACS USER IDENTIFICATION", "OUTPUT MARKING", "TERMINAL LOCATION NUMBER", "3270 REGIME", "X.3 PAD", "NEGOTIATE ABOUT WINDOW SIZE", "TERMINAL SPEED", "REMOTE FLOW CONTROL", "LINEMODE", "X DISPLAY LOCATION", "ENVIRONMENT OPTION", "AUTHENTICATION OPTION", "ENCRYPTION OPTION", "NEW ENVIRONMENT OPTION", "TN3270E", "XAUTH", "CHARSET", "REMOTE SERIAL PORT", "COM PORT CONTROL OPTION", "SUPPRESS LOCAL ECHO", "START TLS", "KERMIT", "SEND URL", "FORWARD X", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "TELOPT PRAGMA LOGON", "TELOPT SSPI LOGON", "TELOPT PRAGMA HEARTBEAT", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "EXTENDED OPTIONS LIST"};
    protected static final int NEGOTIATION_NOT_STARTED = 0;
    protected static final int NEGOTIATION_IN_PROGRESS = 1;
    protected static final int NEGOTIATION_DONE = 2;
    protected static final int NEGOTIATION_IGNORE_DURATION = 30000;
    protected int negotiationState = 0;
    protected Date negotiationCompletionTime = new Date(0L);
    protected int negotiationCount = 0;
    protected byte option = 0;
    protected OutputStream outputStream;
    protected boolean local = true;
    protected boolean enabled = false;
    protected boolean desired = false;

    TelnetOption(byte option, boolean desired, boolean local, OutputStream outputStream) {
        this.option = option;
        this.desired = desired;
        this.local = local;
        this.outputStream = outputStream;
    }

    public String optionName() {
        return optionNames[this.option & 0xFF];
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newValue) {
        Logger.log("Enabling " + (this.local ? "local" : "remote") + " option " + this.optionName());
        this.enabled = newValue;
    }

    public boolean isDesired() {
        return this.desired;
    }

    public void setDesired(boolean newValue) {
        if (newValue) {
            Logger.log("Setting " + (this.local ? "local" : "remote") + " option " + this.optionName() + " as desired.");
        }
        this.desired = newValue;
    }

    public void negotiate() {
        if (this.negotiationState == 0 && this.desired) {
            if (this.local) {
                Logger.log("Starting negotiation for local option " + this.optionName());
                this.sendWill();
            } else {
                Logger.log("Starting negotiation for remote option " + this.optionName());
                this.sendDo();
            }
            this.negotiationState = 1;
        }
    }

    public void handleWill() {
        if (this.negotiationState == 2 && this.ignoreNegotiation()) {
            Logger.log("Ignoring superfluous WILL command from remote endpoint.");
            return;
        }
        if (this.negotiationState == 1) {
            if (this.desired) {
                this.enabled = true;
                Logger.log("Enabling remote option " + this.optionName() + ".");
                this.endNegotiation();
            } else {
                Logger.log("Server answered DONT with WILL!");
                this.enabled = false;
                Logger.log("Disabling remote option " + this.optionName() + ".");
                this.endNegotiation();
            }
        } else if (this.desired) {
            this.sendDo();
            this.enabled = true;
            Logger.log("Enabling remote option " + this.optionName() + ".");
            this.endNegotiation();
        } else {
            this.sendDont();
            this.enabled = false;
            Logger.log("Disabling remote option " + this.optionName() + ".");
            this.endNegotiation();
        }
    }

    public void handleWont() {
        if (this.negotiationState == 2 && this.ignoreNegotiation()) {
            Logger.log("Ignoring superfluous WONT command from remote endpoint.");
            return;
        }
        if (this.negotiationState == 1) {
            this.enabled = false;
            Logger.log("Disabling remote option " + this.optionName() + ".");
            this.endNegotiation();
        } else {
            this.sendDont();
            this.enabled = false;
            Logger.log("Disabling remote option " + this.optionName() + ".");
            this.endNegotiation();
        }
    }

    public void handleDo() {
        if (this.negotiationState == 2 && this.ignoreNegotiation()) {
            Logger.log("Ignoring superfluous DO command from remote endpoint.");
            return;
        }
        if (this.negotiationState == 1) {
            if (this.desired) {
                this.enabled = true;
                Logger.log("Enabling local option " + this.optionName() + ".");
                this.endNegotiation();
            } else {
                Logger.log("Server answered WONT with DO!");
                this.enabled = false;
                Logger.log("Disabling local option " + this.optionName() + ".");
                this.endNegotiation();
            }
        } else if (this.desired) {
            this.sendWill();
            this.enabled = true;
            Logger.log("Enabling local option " + this.optionName() + ".");
            this.endNegotiation();
        } else {
            this.sendWont();
            this.enabled = false;
            Logger.log("Disabling local option " + this.optionName() + ".");
            this.endNegotiation();
        }
    }

    public void handleDont() {
        if (this.negotiationState == 2 && this.ignoreNegotiation()) {
            Logger.log("Ignoring superfluous DONT command from remote endpoint.");
            return;
        }
        if (this.negotiationState == 1) {
            this.enabled = false;
            Logger.log("Disabling local option " + this.optionName() + ".");
            this.endNegotiation();
        } else {
            this.sendWont();
            this.enabled = false;
            Logger.log("Disabling local option " + this.optionName() + ".");
            this.endNegotiation();
        }
    }

    public void handleSubnegotiation(byte[] subnegotiationData, int count) {
        switch (this.option) {
            case 24: {
                if (subnegotiationData[1] != 1) {
                    Logger.log("Invalid TERMINAL-TYPE subnegotiation command from remote endpoint: " + (subnegotiationData[1] & 0xFF));
                    break;
                }
                byte[] byArray = new byte[11];
                byArray[0] = -1;
                byArray[1] = -6;
                byArray[2] = 24;
                byArray[4] = 120;
                byArray[5] = 116;
                byArray[6] = 101;
                byArray[7] = 114;
                byArray[8] = 109;
                byArray[9] = -1;
                byArray[10] = -16;
                byte[] terminalTypeData = byArray;
                try {
                    this.outputStream.write(terminalTypeData);
                }
                catch (IOException ex) {
                    Logger.log("IOException sending TERMINAL-TYPE subnegotiation!");
                    Logger.logException(ex);
                }
                break;
            }
            default: {
                Logger.log("SHOULD NOT BE REACHED: Called for option " + this.optionName());
            }
        }
    }

    public void sendSubnegotiation(Object[] subnegotiationData) {
        switch (this.option) {
            case 31: {
                byte[] byArray = new byte[9];
                byArray[0] = -1;
                byArray[1] = -6;
                byArray[2] = 31;
                byArray[7] = -1;
                byArray[8] = -16;
                byte[] NAWSData = byArray;
                int width = (Integer)subnegotiationData[0];
                int height = (Integer)subnegotiationData[1];
                NAWSData[3] = (byte)(width >>> 8 & 0xFF);
                NAWSData[4] = (byte)(width & 0xFF);
                NAWSData[5] = (byte)(height >>> 8 & 0xFF);
                NAWSData[6] = (byte)(height & 0xFF);
                Logger.log("sending terminal size to remote endpoint: width = " + width + ", height = " + height + ".");
                final byte[] NAWSDataFinal = NAWSData;
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            TelnetOption.this.outputStream.write(NAWSDataFinal);
                        }
                        catch (IOException ex) {
                            Logger.log("IOException sending NAWS subnegotiation!");
                            Logger.logException(ex);
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
                break;
            }
            default: {
                Logger.log("SHOULD NOT BE REACHED: Called for option " + this.optionName());
            }
        }
    }

    protected boolean notYetNegotiated() {
        return this.negotiationState == 0;
    }

    protected void endNegotiation() {
        Logger.log("Ending negotiation #" + this.negotiationCount + " for " + (this.local ? "local" : "remote") + " option " + this.optionName());
        this.negotiationState = 2;
        this.negotiationCompletionTime.setTime(System.currentTimeMillis());
        ++this.negotiationCount;
    }

    protected boolean ignoreNegotiation() {
        return System.currentTimeMillis() - this.negotiationCompletionTime.getTime() < 30000L;
    }

    protected void sendDo() {
        Logger.log("Sending DO " + this.optionName());
        this.sendCommand((byte)-3);
    }

    protected void sendDont() {
        Logger.log("Sending DONT " + this.optionName());
        this.sendCommand((byte)-2);
    }

    protected void sendWill() {
        Logger.log("Sending WILL " + this.optionName());
        this.sendCommand((byte)-5);
    }

    protected void sendWont() {
        Logger.log("Sending WONT " + this.optionName());
        this.sendCommand((byte)-4);
    }

    protected void sendCommand(byte command) {
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        byte[] data = byArray;
        data[1] = command;
        data[2] = this.option;
        try {
            this.outputStream.write(data);
        }
        catch (IOException ex) {
            Logger.log("IOException sending command " + command);
            Logger.logException(ex);
        }
    }
}

