/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.RootServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.rse.ui.widgets.services.ServicesForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ServicesPropertyPage
extends SystemBasePropertyPage {
    protected ServicesForm _form;
    protected String _hostname;
    protected IRSESystemType _hosttype;
    protected ServiceElement _rootElement;

    protected Control createContentArea(Composite parent) {
        this._form = new ServicesForm(parent.getShell(), this.getMessageLine());
        this._form.createContents(parent);
        this.initServices();
        SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.ServicesPropertyPage");
        return parent;
    }

    protected boolean verifyPageContents() {
        return this._form.verify();
    }

    protected void initServices() {
        ServiceElement[] elements = this.getServiceElements();
        this._rootElement = new RootServiceElement(elements);
        this._form.init(this._rootElement);
    }

    protected ISubSystem getServiceSubSystem() {
        return (ISubSystem)this.getElement();
    }

    protected abstract ServiceElement[] getServiceElements();

    protected abstract ISubSystemConfiguration getCurrentSubSystemConfiguration();

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.commitChanges();
            return this.applyValues(this.getServiceSubSystem().getConnectorService());
        }
        return result;
    }

    protected void commitChanges() {
        this._rootElement.commit();
    }

    protected void revertChanges() {
        this._rootElement.revert();
    }

    public boolean applyValues(IConnectorService connectorService) {
        ISubSystemConfiguration currentFactory;
        FactoryServiceElement selectedService = (FactoryServiceElement)this._form.getSelectedService();
        ISubSystemConfiguration factory = selectedService.getFactory();
        if (factory != (currentFactory = this.getCurrentSubSystemConfiguration())) {
            this.getServiceSubSystem().switchServiceFactory(factory);
        }
        return true;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    public void setSystemType(IRSESystemType systemType) {
        this._hosttype = systemType;
    }

    public String getHostname() {
        return this._hostname;
    }

    public IRSESystemType getSystemType() {
        return this._hosttype;
    }

    public boolean performCancel() {
        this._rootElement.revert();
        return super.performCancel();
    }
}

