/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.WrappedTrackedNodePosition;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstMenuBuilder
extends AstTypeBuilder<AstMenuBuilder> {
    private MethodDeclaration m_execAction;

    protected AstMenuBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public AstMenuBuilder insert() {
        super.insert();
        if (!(AstUtils.isInstanceOf((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), (String)this.getFactory().getScoutApi().AbstractButton().fqn()) || AstUtils.isInstanceOf((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), (String)this.getFactory().getScoutApi().AbstractGroupBox().fqn()) || AstUtils.isInstanceOf((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), (String)this.getFactory().getScoutApi().AbstractImageField().fqn()))) {
            this.addGetConfiguredMenuTypes();
        }
        this.m_execAction = ((AstMethodBuilder)((AstMethodBuilder)this.getFactory().newExecMethod(this.getFactory().getScoutApi().AbstractAction().execActionMethodName()).in(this.get())).insert()).get();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            links.addLinkedPositionProposalsHierarchy("SUPER_TYPE", this.getFactory().getScoutApi().IMenu().fqn());
        }
        return this;
    }

    public MethodDeclaration getExecAction() {
        return this.m_execAction;
    }

    protected void addGetConfiguredMenuTypes() {
        AST ast = this.getFactory().getAst();
        IScoutApi scoutApi = this.getFactory().getScoutApi();
        Type iMenuTypeType = this.getFactory().newTypeReference(scoutApi.IMenuType().fqn());
        Type setType = this.getFactory().newTypeReference(Set.class.getName());
        ParameterizedType returnType = ast.newParameterizedType(setType);
        WildcardType extendsIMenuType = ast.newWildcardType();
        extendsIMenuType.setBound(iMenuTypeType, true);
        returnType.typeArguments().add(extendsIMenuType);
        MethodInvocation hashSet = ast.newMethodInvocation();
        String methodName = this.getFactory().getScoutApi().CollectionUtility().hashSetMethodName();
        Type collectionUtilityType = this.getFactory().newTypeReference(scoutApi.CollectionUtility().fqn());
        hashSet.setName(ast.newSimpleName(methodName));
        String collectionUtilityRef = collectionUtilityType.toString();
        hashSet.setExpression((Expression)ast.newSimpleName(collectionUtilityRef));
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression((Expression)hashSet);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        ((AstMethodBuilder)((AbstractAstBuilder)((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.getFactory().newMethod(this.getFactory().getScoutApi().AbstractMenu().getConfiguredMenuTypesMethodName()).withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType((Type)returnType)).withBody(body)).in(this.get())).insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            int offset = collectionUtilityRef.length() + methodName.length() + 2;
            WrappedTrackedNodePosition typeNamePos = new WrappedTrackedNodePosition(this.getFactory().getRewrite().track((ASTNode)hashSet), offset, -offset - 1);
            links.addLinkedPosition(typeNamePos, true, "MENU_TYPE");
            MenuTypeLinkedProposal menuTypeLinkedProposal = this.getMenuTypeLinkedProposal();
            if (menuTypeLinkedProposal != null) {
                this.getFactory().getImportRewrite().addImport(menuTypeLinkedProposal.m_typeFqn, this.getFactory().getContext());
                for (String defaultVal : menuTypeLinkedProposal.m_defaultValues) {
                    hashSet.arguments().add(ast.newQualifiedName((Name)ast.newSimpleName(menuTypeLinkedProposal.m_typeSimpleName), ast.newSimpleName(defaultVal)));
                }
                if (menuTypeLinkedProposal.m_menuTypeProposals.size() > 1) {
                    for (String menuTypeProposal : menuTypeLinkedProposal.m_menuTypeProposals) {
                        links.addLinkedPositionProposal("MENU_TYPE", menuTypeProposal);
                    }
                }
            }
        }
    }

    private MenuTypeLinkedProposal getMenuTypeLinkedProposal() {
        IScoutApi scoutApi;
        ITypeBinding hierarchy = this.getFactory().getDeclaringTypeBinding();
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)(scoutApi = this.getFactory().getScoutApi()).AbstractTable().fqn())) {
            MenuTypeLinkedProposal tableMenuType = new MenuTypeLinkedProposal(scoutApi.TableMenuType().fqn(), scoutApi.TableMenuType().SingleSelection(), scoutApi.TableMenuType().MultiSelection());
            tableMenuType.addProposal(scoutApi.TableMenuType().EmptySpace());
            tableMenuType.addProposal(scoutApi.TableMenuType().EmptySpace(), scoutApi.TableMenuType().Header());
            tableMenuType.addProposal(scoutApi.TableMenuType().EmptySpace(), scoutApi.TableMenuType().SingleSelection(), scoutApi.TableMenuType().MultiSelection());
            return tableMenuType;
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)scoutApi.AbstractValueField().fqn())) {
            MenuTypeLinkedProposal valueFieldMenuType = new MenuTypeLinkedProposal(scoutApi.ValueFieldMenuType().fqn(), scoutApi.ValueFieldMenuType().NotNull());
            valueFieldMenuType.addProposal(scoutApi.ValueFieldMenuType().Null());
            valueFieldMenuType.addProposal(scoutApi.ValueFieldMenuType().Null(), scoutApi.ValueFieldMenuType().NotNull());
            return valueFieldMenuType;
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)scoutApi.AbstractTree().fqn()) || AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)scoutApi.AbstractTreeNode().fqn())) {
            MenuTypeLinkedProposal calMenuType = new MenuTypeLinkedProposal(scoutApi.TreeMenuType().fqn(), scoutApi.TreeMenuType().SingleSelection(), scoutApi.TreeMenuType().MultiSelection());
            calMenuType.addProposal(scoutApi.TreeMenuType().EmptySpace());
            calMenuType.addProposal(scoutApi.TreeMenuType().SingleSelection(), scoutApi.TreeMenuType().MultiSelection(), scoutApi.TreeMenuType().EmptySpace());
            return calMenuType;
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)scoutApi.AbstractTabBox().fqn())) {
            return new MenuTypeLinkedProposal(scoutApi.TabBoxMenuType().fqn(), scoutApi.TabBoxMenuType().Header());
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)scoutApi.AbstractCalendarItemProvider().fqn()) || AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)scoutApi.AbstractCalendar().fqn())) {
            MenuTypeLinkedProposal calMenuType = new MenuTypeLinkedProposal(scoutApi.CalendarMenuType().fqn(), scoutApi.CalendarMenuType().CalendarComponent());
            calMenuType.addProposal(scoutApi.CalendarMenuType().EmptySpace());
            calMenuType.addProposal(scoutApi.CalendarMenuType().CalendarComponent());
            calMenuType.addProposal(scoutApi.CalendarMenuType().EmptySpace(), scoutApi.CalendarMenuType().CalendarComponent());
            return calMenuType;
        }
        return null;
    }

    private static final class MenuTypeLinkedProposal {
        private final String m_typeFqn;
        private final String m_typeSimpleName;
        private final List<String> m_defaultValues;
        private final List<String> m_menuTypeProposals;

        private MenuTypeLinkedProposal(String typeFqn, String ... defaultValues) {
            this.m_typeFqn = typeFqn;
            this.m_typeSimpleName = JavaTypes.simpleName((CharSequence)typeFqn);
            this.m_defaultValues = new ArrayList<String>(defaultValues.length);
            Collections.addAll(this.m_defaultValues, defaultValues);
            this.m_menuTypeProposals = new ArrayList<String>();
            this.addProposal(defaultValues);
        }

        private void addProposal(String ... simpleNames) {
            String builder = "";
            if (simpleNames != null && simpleNames.length > 0) {
                builder = IntStream.range(1, simpleNames.length).mapToObj(i -> ", " + this.m_typeSimpleName + "." + simpleNames[i]).collect(Collectors.joining("", this.m_typeSimpleName + "." + simpleNames[0], ""));
            }
            this.m_menuTypeProposals.add(builder);
        }
    }
}

