/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.swt.tools.internal.JNIType;

public class ASTType
implements JNIType {
    String name;

    public ASTType(String name) {
        this.name = name;
    }

    public ASTType(TypeResolver resolver, Type type, int extraDimensions) {
        this.name = this.from(resolver, type, extraDimensions);
    }

    String from(TypeResolver resolver, Type type, int extraDimensions) {
        String name = "";
        String str = type.toString();
        if (type.isPrimitiveType()) {
            if (str.equals("void")) {
                name = "V";
            } else if (str.equals("int")) {
                name = "I";
            } else if (str.equals("boolean")) {
                name = "Z";
            } else if (str.equals("long")) {
                name = "J";
            } else if (str.equals("short")) {
                name = "S";
            } else if (str.equals("char")) {
                name = "C";
            } else if (str.equals("byte")) {
                name = "B";
            } else if (str.equals("float")) {
                name = "F";
            } else if (str.equals("double")) {
                name = "D";
            }
        } else if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            name = this.from(resolver, arrayType.getElementType(), arrayType.getDimensions());
        } else if (str.indexOf(46) != -1) {
            name = "L" + type.toString().replace('.', '/') + ";";
        } else if (str.equals("String")) {
            name = "Ljava/lang/String;";
        } else if (str.equals("Class")) {
            name = "Ljava/lang/Class;";
        } else if (str.equals("Object")) {
            name = "Ljava/lang/Object;";
        } else {
            String qualifiedName = resolver != null ? resolver.resolve(str) : str;
            name = "L" + qualifiedName.replace('.', '/') + ";";
        }
        int i = 0;
        while (i < extraDimensions) {
            name = "[" + name;
            ++i;
        }
        return name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ASTType)) {
            return false;
        }
        return ((ASTType)obj).name.equals(this.name);
    }

    @Override
    public JNIType getComponentType() {
        if (!this.name.startsWith("[")) {
            throw new RuntimeException();
        }
        return new ASTType(this.name.substring(1));
    }

    @Override
    public String getName() {
        if (this.isPrimitive()) {
            if (this.name.equals("V")) {
                return "void";
            }
            if (this.name.equals("I")) {
                return "int";
            }
            if (this.name.equals("Z")) {
                return "boolean";
            }
            if (this.name.equals("J")) {
                return "long";
            }
            if (this.name.equals("S")) {
                return "short";
            }
            if (this.name.equals("C")) {
                return "char";
            }
            if (this.name.equals("B")) {
                return "byte";
            }
            if (this.name.equals("F")) {
                return "float";
            }
            if (this.name.equals("D")) {
                return "double";
            }
        }
        if (this.isArray()) {
            return this.name;
        }
        return this.name.substring(1, this.name.length() - 1).replace('/', '.');
    }

    @Override
    public String getSimpleName() {
        String name = this.getName();
        if (this.isArray() || this.isPrimitive()) {
            return name;
        }
        int index = name.lastIndexOf(46) + 1;
        return name.substring(index, name.length());
    }

    @Override
    public String getTypeSignature() {
        if (this.isPrimitive()) {
            return this.name;
        }
        if (this.isArray()) {
            return "[" + this.getComponentType().getTypeSignature();
        }
        return this.name;
    }

    @Override
    public String getTypeSignature1() {
        if (this.isPrimitive()) {
            if (this.name.equals("V")) {
                return "Void";
            }
            if (this.name.equals("I")) {
                return "Int";
            }
            if (this.name.equals("Z")) {
                return "Boolean";
            }
            if (this.name.equals("J")) {
                return "Long";
            }
            if (this.name.equals("S")) {
                return "Short";
            }
            if (this.name.equals("C")) {
                return "Char";
            }
            if (this.name.equals("B")) {
                return "Byte";
            }
            if (this.name.equals("F")) {
                return "Float";
            }
            if (this.name.equals("D")) {
                return "Double";
            }
        }
        if (this.name.equals("Ljava/lang/String;")) {
            return "String";
        }
        return "Object";
    }

    @Override
    public String getTypeSignature2() {
        if (this.isPrimitive()) {
            if (this.name.equals("V")) {
                return "void";
            }
            if (this.name.equals("I")) {
                return "jint";
            }
            if (this.name.equals("Z")) {
                return "jboolean";
            }
            if (this.name.equals("J")) {
                return "jlong";
            }
            if (this.name.equals("S")) {
                return "jshort";
            }
            if (this.name.equals("C")) {
                return "jchar";
            }
            if (this.name.equals("B")) {
                return "jbyte";
            }
            if (this.name.equals("F")) {
                return "jfloat";
            }
            if (this.name.equals("D")) {
                return "jdouble";
            }
        }
        if (this.name.equals("Ljava/lang/String;")) {
            return "jstring";
        }
        if (this.name.equals("Ljava/lang/Class;")) {
            return "jclass";
        }
        if (this.isArray()) {
            return String.valueOf(this.getComponentType().getTypeSignature2()) + "Array";
        }
        return "jobject";
    }

    @Override
    public String getTypeSignature3() {
        if (this.isPrimitive()) {
            if (this.name.equals("V")) {
                return "void";
            }
            if (this.name.equals("I")) {
                return "int";
            }
            if (this.name.equals("Z")) {
                return "boolean";
            }
            if (this.name.equals("J")) {
                return "long";
            }
            if (this.name.equals("S")) {
                return "short";
            }
            if (this.name.equals("C")) {
                return "char";
            }
            if (this.name.equals("B")) {
                return "byte";
            }
            if (this.name.equals("F")) {
                return "float";
            }
            if (this.name.equals("D")) {
                return "double";
            }
        }
        if (this.name.equals("Ljava/lang/String;")) {
            return "String";
        }
        if (this.isArray()) {
            return String.valueOf(this.getComponentType().getTypeSignature3()) + "[]";
        }
        return this.getName();
    }

    @Override
    public String getTypeSignature4(boolean struct) {
        if (this.isPrimitive()) {
            if (this.name.equals("V")) {
                return "void";
            }
            if (this.name.equals("I")) {
                return "jint";
            }
            if (this.name.equals("Z")) {
                return "jboolean";
            }
            if (this.name.equals("J")) {
                return "jlong";
            }
            if (this.name.equals("S")) {
                return "jshort";
            }
            if (this.name.equals("C")) {
                return "jchar";
            }
            if (this.name.equals("B")) {
                return "jbyte";
            }
            if (this.name.equals("F")) {
                return "jfloat";
            }
            if (this.name.equals("D")) {
                return "jdouble";
            }
        }
        if (this.name.equals("Ljava/lang/String;")) {
            return "jstring";
        }
        if (this.isArray()) {
            String sig = this.getComponentType().getTypeSignature4(struct);
            return struct ? sig : String.valueOf(sig) + " *";
        }
        String sig = this.getSimpleName();
        return struct ? sig : String.valueOf(sig) + " *";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isArray() {
        return this.name.startsWith("[");
    }

    @Override
    public boolean isPrimitive() {
        return !this.name.startsWith("L") && !this.name.startsWith("[");
    }

    @Override
    public boolean isType(String type) {
        return this.getName().equals(type);
    }

    public String toString() {
        return this.name;
    }

    static interface TypeResolver {
        public String findPath(String var1);

        public String resolve(String var1);
    }
}

