/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.TerminalStyle;

public class TerminalTextDataStore
implements ITerminalTextData {
    private char[][] fChars;
    private TerminalStyle[][] fStyle;
    private int fWidth = 0;
    private int fHeight;
    private int fMaxHeight;
    private int fCursorColumn;
    private int fCursorLine;
    private final BitSet fWrappedLines = new BitSet();

    public TerminalTextDataStore() {
        this.fChars = new char[0][];
        this.fStyle = new TerminalStyle[0][];
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    @Override
    public int getWidth() {
        return this.fWidth;
    }

    @Override
    public int getHeight() {
        return this.fHeight;
    }

    @Override
    public void setDimensions(int height, int width) {
        assert (height >= 0 || this.throwRuntimeException());
        assert (width >= 0 || this.throwRuntimeException());
        if (height > this.fChars.length) {
            int h = 4 * height / 3;
            if (this.fMaxHeight > 0 && h > this.fMaxHeight) {
                h = this.fMaxHeight;
            }
            this.fStyle = (TerminalStyle[][])this.resizeArray(this.fStyle, height);
            this.fChars = (char[][])this.resizeArray(this.fChars, height);
        }
        if (height > this.fHeight) {
            int i = this.fHeight;
            while (i < height) {
                this.cleanLine(i);
                ++i;
            }
        }
        this.fWidth = width;
        this.fHeight = height;
    }

    private Object resizeArray(Object origArray, int newSize) {
        int oldSize = Array.getLength(origArray);
        if (oldSize == newSize) {
            return origArray;
        }
        Class<?> elementType = origArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(origArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    @Override
    public LineSegment[] getLineSegments(int line, int column, int len) {
        TerminalStyle[] styles = this.fStyle[line];
        char[] chars = this.fChars[line];
        int col = column;
        int n = column + len;
        if (styles == null) {
            styles = new TerminalStyle[n];
        } else if (styles.length < n) {
            styles = (TerminalStyle[])this.resizeArray(styles, n);
        }
        if (chars == null) {
            chars = new char[n];
        } else if (chars.length < n) {
            chars = (char[])this.resizeArray(chars, n);
        }
        TerminalStyle style = styles[column];
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>();
        int i = column;
        while (i < n) {
            if (styles[i] != style) {
                segments.add(new LineSegment(col, new String(chars, col, i - col), style));
                style = styles[i];
                col = i;
            }
            ++i;
        }
        if (col < n) {
            segments.add(new LineSegment(col, new String(chars, col, n - col), style));
        }
        return segments.toArray(new LineSegment[segments.size()]);
    }

    @Override
    public char getChar(int line, int column) {
        assert (column < this.fWidth || this.throwRuntimeException());
        if (this.fChars[line] == null || column >= this.fChars[line].length) {
            return '\u0000';
        }
        return this.fChars[line][column];
    }

    @Override
    public TerminalStyle getStyle(int line, int column) {
        assert (column < this.fWidth || this.throwRuntimeException());
        if (this.fStyle[line] == null || column >= this.fStyle[line].length) {
            return null;
        }
        return this.fStyle[line][column];
    }

    void ensureLineLength(int iLine, int length) {
        if (length > this.fWidth) {
            throw new RuntimeException();
        }
        if (this.fChars[iLine] == null) {
            this.fChars[iLine] = new char[length];
        } else if (this.fChars[iLine].length < length) {
            this.fChars[iLine] = (char[])this.resizeArray(this.fChars[iLine], length);
        }
        if (this.fStyle[iLine] == null) {
            this.fStyle[iLine] = new TerminalStyle[length];
        } else if (this.fStyle[iLine].length < length) {
            this.fStyle[iLine] = (TerminalStyle[])this.resizeArray(this.fStyle[iLine], length);
        }
    }

    @Override
    public void setChar(int line, int column, char c, TerminalStyle style) {
        this.ensureLineLength(line, column + 1);
        this.fChars[line][column] = c;
        this.fStyle[line][column] = style;
    }

    @Override
    public void setChars(int line, int column, char[] chars, TerminalStyle style) {
        this.setChars(line, column, chars, 0, chars.length, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, int start, int len, TerminalStyle style) {
        this.ensureLineLength(line, column + len);
        int i = 0;
        while (i < len) {
            this.fChars[line][column + i] = chars[i + start];
            this.fStyle[line][column + i] = style;
            ++i;
        }
    }

    @Override
    public void scroll(int startLine, int size, int shift) {
        assert (startLine + size <= this.getHeight() || this.throwRuntimeException());
        if (shift < 0) {
            int i = startLine;
            while (i < startLine + size + shift) {
                this.fChars[i] = this.fChars[i - shift];
                this.fStyle[i] = this.fStyle[i - shift];
                this.fWrappedLines.set(i, this.fWrappedLines.get(i - shift));
                ++i;
            }
            this.cleanLines(Math.max(startLine, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
        } else {
            int i = startLine + size - 1;
            while (i >= startLine && i - shift >= 0) {
                this.fChars[i] = this.fChars[i - shift];
                this.fStyle[i] = this.fStyle[i - shift];
                this.fWrappedLines.set(i, this.fWrappedLines.get(i - shift));
                --i;
            }
            this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
        }
    }

    private void cleanLines(int line, int len) {
        int i = line;
        while (i < line + len) {
            this.cleanLine(i);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int line = 0;
        while (line < this.getHeight()) {
            if (line > 0) {
                buff.append("\n");
            }
            int column = 0;
            while (column < this.fWidth) {
                buff.append(this.getChar(line, column));
                ++column;
            }
            ++line;
        }
        return buff.toString();
    }

    @Override
    public ITerminalTextDataSnapshot makeSnapshot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLine() {
        if (this.fMaxHeight > 0 && this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    @Override
    public void copy(ITerminalTextData source) {
        this.fWidth = source.getWidth();
        int n = source.getHeight();
        if (this.getHeight() != n) {
            this.fChars = new char[n][];
            this.fStyle = new TerminalStyle[n][];
        }
        int i = 0;
        while (i < n) {
            this.copyLine(source, i, i);
            ++i;
        }
        this.fHeight = n;
        this.fCursorLine = source.getCursorLine();
        this.fCursorColumn = source.getCursorColumn();
    }

    @Override
    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        int i = 0;
        while (i < length) {
            this.copyLine(source, i + sourceStartLine, i + destStartLine);
            ++i;
        }
    }

    @Override
    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        this.fChars[destLine] = source.getChars(sourceLine);
        this.fStyle[destLine] = source.getStyles(sourceLine);
        this.fWrappedLines.set(destLine, source.isWrappedLine(sourceLine));
    }

    @Override
    public char[] getChars(int line) {
        if (this.fChars[line] == null) {
            return null;
        }
        return (char[])this.fChars[line].clone();
    }

    @Override
    public TerminalStyle[] getStyles(int line) {
        if (this.fStyle[line] == null) {
            return null;
        }
        return (TerminalStyle[])this.fStyle[line].clone();
    }

    public void setLine(int line, char[] chars, TerminalStyle[] styles) {
        this.fChars[line] = (char[])chars.clone();
        this.fStyle[line] = (TerminalStyle[])styles.clone();
        this.fWrappedLines.clear(line);
    }

    @Override
    public void setMaxHeight(int height) {
        this.fMaxHeight = height;
    }

    @Override
    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    @Override
    public void cleanLine(int line) {
        this.fChars[line] = null;
        this.fStyle[line] = null;
        this.fWrappedLines.clear(line);
    }

    @Override
    public int getCursorColumn() {
        return this.fCursorColumn;
    }

    @Override
    public int getCursorLine() {
        return this.fCursorLine;
    }

    @Override
    public void setCursorColumn(int column) {
        this.fCursorColumn = column;
    }

    @Override
    public void setCursorLine(int line) {
        this.fCursorLine = line;
    }

    @Override
    public boolean isWrappedLine(int line) {
        return this.fWrappedLines.get(line);
    }

    @Override
    public void setWrappedLine(int line) {
        this.fWrappedLines.set(line);
    }
}

