/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.RawRule;
import org.eclipse.tm4e.core.internal.grammar.dependencies.IncludeReference;
import org.eclipse.tm4e.core.internal.rule.BeginEndRule;
import org.eclipse.tm4e.core.internal.rule.BeginWhileRule;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.IRuleFactoryHelper;
import org.eclipse.tm4e.core.internal.rule.IncludeOnlyRule;
import org.eclipse.tm4e.core.internal.rule.MatchRule;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.types.IRawCaptures;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class RuleFactory {
    private static final System.Logger LOGGER = System.getLogger(RuleFactory.class.getName());

    private static CaptureRule createCaptureRule(IRuleFactoryHelper helper, @Nullable String name, @Nullable String contentName, RuleId retokenizeCapturedWithRuleId) {
        return helper.registerRule(id -> new CaptureRule((RuleId)id, name, contentName, retokenizeCapturedWithRuleId));
    }

    public static RuleId getCompiledRuleId(IRawRule desc, IRuleFactoryHelper helper, IRawRepository repository) {
        if (desc.getId() == null) {
            helper.registerRule(ruleId -> {
                desc.setId((RuleId)ruleId);
                String ruleMatch = desc.getMatch();
                if (ruleMatch != null) {
                    return new MatchRule((RuleId)ruleId, desc.getName(), ruleMatch, RuleFactory._compileCaptures(desc.getCaptures(), helper, repository));
                }
                String begin = desc.getBegin();
                if (begin == null) {
                    IRawRepository repository1 = desc.getRepository() == null ? repository : IRawRepository.merge(repository, desc.getRepository());
                    Collection<IRawRule> patterns = desc.getPatterns();
                    if (patterns == null && desc.getInclude() != null) {
                        patterns = List.of(new RawRule().setInclude(desc.getInclude()));
                    }
                    return new IncludeOnlyRule((RuleId)ruleId, desc.getName(), desc.getContentName(), RuleFactory._compilePatterns(patterns, helper, repository1));
                }
                String ruleWhile = desc.getWhile();
                if (ruleWhile != null) {
                    return new BeginWhileRule((RuleId)ruleId, desc.getName(), desc.getContentName(), begin, RuleFactory._compileCaptures(NullSafetyHelper.defaultIfNull(desc.getBeginCaptures(), desc.getCaptures()), helper, repository), ruleWhile, RuleFactory._compileCaptures(NullSafetyHelper.defaultIfNull(desc.getWhileCaptures(), desc.getCaptures()), helper, repository), RuleFactory._compilePatterns(desc.getPatterns(), helper, repository));
                }
                return new BeginEndRule((RuleId)ruleId, desc.getName(), desc.getContentName(), begin, RuleFactory._compileCaptures(NullSafetyHelper.defaultIfNull(desc.getBeginCaptures(), desc.getCaptures()), helper, repository), desc.getEnd(), RuleFactory._compileCaptures(NullSafetyHelper.defaultIfNull(desc.getEndCaptures(), desc.getCaptures()), helper, repository), desc.isApplyEndPatternLast(), RuleFactory._compilePatterns(desc.getPatterns(), helper, repository));
            });
        }
        return NullSafetyHelper.castNonNull(desc.getId());
    }

    private static List<@Nullable CaptureRule> _compileCaptures(@Nullable IRawCaptures captures, IRuleFactoryHelper helper, IRawRepository repository) {
        if (captures == null) {
            return Collections.emptyList();
        }
        int maximumCaptureId = 0;
        for (String captureId : captures.getCaptureIds()) {
            int numericCaptureId = RuleFactory.parseInt(captureId, 10);
            if (numericCaptureId <= maximumCaptureId) continue;
            maximumCaptureId = numericCaptureId;
        }
        ArrayList<CaptureRule> r = new ArrayList<CaptureRule>();
        int i = 0;
        while (i <= maximumCaptureId) {
            r.add(null);
            ++i;
        }
        for (String captureId : captures.getCaptureIds()) {
            int numericCaptureId = RuleFactory.parseInt(captureId, 10);
            IRawRule rule = captures.getCapture(captureId);
            RuleId retokenizeCapturedWithRuleId = rule.getPatterns() == null ? RuleId.NO_RULE : RuleFactory.getCompiledRuleId(captures.getCapture(captureId), helper, repository);
            r.set(numericCaptureId, RuleFactory.createCaptureRule(helper, rule.getName(), rule.getContentName(), retokenizeCapturedWithRuleId));
        }
        return r;
    }

    private static int parseInt(String string, int base) {
        try {
            return Integer.parseInt(string, base);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CompilePatternsResult _compilePatterns(@Nullable Collection<IRawRule> patterns, IRuleFactoryHelper helper, IRawRepository repository) {
        if (patterns == null) {
            return new CompilePatternsResult(new RuleId[0], false);
        }
        ArrayList<RuleId> r = new ArrayList<RuleId>();
        for (IRawRule pattern : patterns) {
            Rule rule;
            Object externalIncludedRule;
            Object externalGrammar;
            Object externalGrammarName;
            RuleId ruleId;
            block24: {
                ruleId = null;
                String patternInclude = pattern.getInclude();
                if (patternInclude != null) {
                    IncludeReference reference = IncludeReference.parseInclude(patternInclude);
                    switch (reference.kind) {
                        case Base: {
                            ruleId = RuleFactory.getCompiledRuleId(repository.getBase(), helper, repository);
                            break;
                        }
                        case Self: {
                            ruleId = RuleFactory.getCompiledRuleId(repository.getSelf(), helper, repository);
                            break;
                        }
                        case RelativeReference: {
                            IRawRule localIncludedRule = repository.getRule(reference.ruleName);
                            if (localIncludedRule != null) {
                                ruleId = RuleFactory.getCompiledRuleId(localIncludedRule, helper, repository);
                                break;
                            }
                            LOGGER.log(System.Logger.Level.WARNING, "CANNOT find rule for scopeName [{0}]. I am [{1}]", patternInclude, repository.getBase().getName());
                            break;
                        }
                        case TopLevelReference: 
                        case TopLevelRepositoryReference: {
                            externalGrammarName = reference.scopeName;
                            String externalGrammarInclude = reference.kind == IncludeReference.Kind.TopLevelRepositoryReference ? reference.ruleName : null;
                            externalGrammar = helper.getExternalGrammar((String)externalGrammarName, repository);
                            if (externalGrammar != null) {
                                IRawRepository externalGrammarRepo = externalGrammar.getRepository();
                                if (externalGrammarInclude != null) {
                                    externalIncludedRule = externalGrammarRepo.getRule(externalGrammarInclude);
                                    if (externalIncludedRule != null) {
                                        ruleId = RuleFactory.getCompiledRuleId((IRawRule)externalIncludedRule, helper, externalGrammarRepo);
                                        break;
                                    }
                                    LOGGER.log(System.Logger.Level.WARNING, "CANNOT find rule for scopeName [{0}]. I am [{1}]", patternInclude, repository.getBase().getName());
                                    break;
                                }
                                ruleId = RuleFactory.getCompiledRuleId(externalGrammarRepo.getSelf(), helper, externalGrammarRepo);
                                break;
                            }
                            LOGGER.log(System.Logger.Level.WARNING, "CANNOT find grammar for scopeName [{0}]. I am [{1}]", patternInclude, repository.getBase().getName());
                        }
                    }
                } else {
                    ruleId = RuleFactory.getCompiledRuleId(pattern, helper, repository);
                }
                if (ruleId == null) continue;
                try {
                    rule = helper.getRule(ruleId);
                }
                catch (IndexOutOfBoundsException ex) {
                    rule = null;
                    if (patternInclude != null) break block24;
                    ex.printStackTrace();
                }
            }
            boolean skipRule = false;
            Rule rule2 = rule;
            if (rule2 instanceof IncludeOnlyRule && (externalGrammarName = (IncludeOnlyRule)rule2) == (IncludeOnlyRule)rule2) {
                void ior;
                if (ior.hasMissingPatterns && ior.patterns.length == 0) {
                    skipRule = true;
                }
            } else {
                 instanceOfPatternExpressionValue = rule;
                if ( instanceOfPatternExpressionValue instanceof BeginEndRule && (externalGrammar = (BeginEndRule) instanceOfPatternExpressionValue) == (BeginEndRule) instanceOfPatternExpressionValue) {
                    void ber;
                    if (ber.hasMissingPatterns && ber.patterns.length == 0) {
                        skipRule = true;
                    }
                } else {
                    void bwr;
                     instanceOfPatternExpressionValue = rule;
                    if ( instanceOfPatternExpressionValue instanceof BeginWhileRule && (externalIncludedRule = (BeginWhileRule) instanceOfPatternExpressionValue) == (BeginWhileRule) instanceOfPatternExpressionValue && bwr.hasMissingPatterns && bwr.patterns.length == 0) {
                        skipRule = true;
                    }
                }
            }
            if (skipRule) {
                LOGGER.log(System.Logger.Level.WARNING, "REMOVING RULE ENTIRELY DUE TO EMPTY PATTERNS THAT ARE MISSING");
                continue;
            }
            r.add(ruleId);
        }
        return new CompilePatternsResult((RuleId[])r.toArray(RuleId[]::new), patterns.size() != r.size());
    }

    private RuleFactory() {
    }
}

