/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class ClassEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        MethodInvocation invocation;
        if (expression instanceof TypeLiteral) {
            TypeLiteral typeLiteral = (TypeLiteral)expression;
            ITypeBinding binding = AstNodeUtils.getTypeBinding(typeLiteral.getType());
            return ClassEvaluator.loadClass(context, binding);
        }
        if (expression instanceof MethodInvocation && ClassEvaluator.isThisInvocation(invocation = (MethodInvocation)expression) && AstNodeUtils.isMethodInvocation((ASTNode)invocation, "getClass()")) {
            TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)invocation);
            ITypeBinding binding = AstNodeUtils.getTypeBinding(typeDeclaration);
            return ClassEvaluator.loadClass(context, binding);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static boolean isThisInvocation(MethodInvocation invocation) {
        Expression expression = invocation.getExpression();
        return expression == null || expression instanceof ThisExpression;
    }

    private static Object loadClass(EvaluationContext context, ITypeBinding binding) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        String className = AstNodeUtils.getFullyQualifiedName(binding, true);
        return ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)className);
    }
}

