/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle.pure.field;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.AbstractPureBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class FieldSource
extends AbstractPureBundleSource {
    private static final String BUNDLE_COMMENT = "Field ResourceBundle: ";
    private final String m_fieldName;

    @Override
    protected String getBundleComment() {
        return BUNDLE_COMMENT + this.m_fieldName;
    }

    public static List<AbstractSource> getPossibleSources(JavaInfo root, IPackageFragment pkg) throws Exception {
        Object[] nonJavaResources;
        ArrayList sources = Lists.newArrayList();
        Object[] objectArray = nonJavaResources = pkg.getNonJavaResources();
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream is;
            String firstLine;
            IFile file;
            String fileName;
            Object o = objectArray[n2];
            if (o instanceof IFile && (fileName = (file = (IFile)o).getName()).endsWith(".properties") && fileName.indexOf(95) == -1 && (firstLine = IOUtils2.readFirstLine((InputStream)(is = file.getContents(true)))) != null && firstLine.startsWith("#Field ResourceBundle: ")) {
                String fieldName = firstLine.substring(1 + BUNDLE_COMMENT.length());
                try {
                    String bundleName = String.valueOf(pkg.getElementName()) + "." + StringUtils.substring((String)fileName, (int)0, (int)(-".properties".length()));
                    FieldSource source = new FieldSource(root, bundleName, fieldName);
                    sources.add(source);
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
            ++n2;
        }
        return sources;
    }

    @Override
    public void attachPossible() throws Exception {
        FieldSource.addField(this.m_root, this.m_bundleName, this.m_fieldName);
    }

    public static AbstractSource get(JavaInfo component, GenericProperty property, Expression expression, List<AbstractSource> sources) throws Exception {
        ExpressionInfo expressionInfo = FieldSource.getExpressionInfo(component, expression);
        if (expressionInfo != null) {
            String bundleName = expressionInfo.m_bundleName;
            String fieldName = expressionInfo.m_fieldName;
            FieldSource source = FieldSource.getNewOrExistingSource(component, bundleName, fieldName, sources);
            source.onKeyAdd(component, expressionInfo.m_key);
            return source;
        }
        return null;
    }

    private static FieldSource getNewOrExistingSource(JavaInfo component, String bundleName, String fieldName, List<AbstractSource> sources) throws Exception {
        for (AbstractSource abstractSource : sources) {
            if (!(abstractSource instanceof FieldSource)) continue;
            FieldSource source = (FieldSource)abstractSource;
            if (!source.m_bundleName.equals(bundleName)) continue;
            return source;
        }
        return new FieldSource(component.getRootJava(), bundleName, fieldName);
    }

    private static ExpressionInfo getExpressionInfo(JavaInfo component, Expression expression) {
        if (expression instanceof MethodInvocation) {
            SimpleName fieldExpression;
            boolean is_getString;
            MethodInvocation getString_invocation = (MethodInvocation)expression;
            boolean bl = is_getString = getString_invocation.getName().getIdentifier().equals("getString") && getString_invocation.arguments().size() == 1 && getString_invocation.arguments().get(0) instanceof StringLiteral;
            if (!is_getString) {
                return null;
            }
            if (getString_invocation.getExpression() instanceof SimpleName && AstNodeUtils.getFullyQualifiedName((Expression)(fieldExpression = (SimpleName)getString_invocation.getExpression()), false).equals("java.util.ResourceBundle")) {
                EditorState editorState = EditorState.get(component.getEditor());
                ASTNode assignment = ExecutionFlowUtils.getLastAssignment(editorState.getFlowDescription(), (ASTNode)fieldExpression);
                if (!(assignment instanceof VariableDeclarationFragment)) {
                    return null;
                }
                VariableDeclarationFragment fieldAssignment = (VariableDeclarationFragment)assignment;
                Expression fieldInitializer = fieldAssignment.getInitializer();
                String bundleName = FieldSource.getBundleName_for_getBundle(fieldInitializer);
                if (bundleName == null) {
                    return null;
                }
                StringLiteral keyLiteral = (StringLiteral)getString_invocation.arguments().get(0);
                String key = keyLiteral.getLiteralValue();
                ExpressionInfo expressionInfo = new ExpressionInfo(expression, bundleName, fieldExpression.getIdentifier(), keyLiteral, key);
                expression.setProperty("NLS_EXPRESSION_INFO", (Object)expressionInfo);
                return expressionInfo;
            }
        }
        return null;
    }

    private static String getBundleName_for_getBundle(Expression expression) {
        TagElement tagElement;
        BodyDeclaration declaration = AstNodeUtils.getEnclosingNode((ASTNode)expression, BodyDeclaration.class);
        if (declaration != null && (tagElement = AstNodeUtils.getJavaDocTag(declaration, "@wbp.nls.resourceBundle")) != null && tagElement.fragments().size() == 1) {
            return tagElement.fragments().get(0).toString().trim();
        }
        if (expression instanceof MethodInvocation) {
            boolean is_getBundleWithLocale;
            MethodInvocation invocation = (MethodInvocation)expression;
            boolean is_getBundle = invocation.getName().getIdentifier().equals("getBundle") && invocation.arguments().size() == 1 && invocation.arguments().get(0) instanceof StringLiteral;
            boolean bl = is_getBundleWithLocale = invocation.getName().getIdentifier().equals("getBundle") && invocation.arguments().size() == 2 && invocation.arguments().get(0) instanceof StringLiteral && AstNodeUtils.getFullyQualifiedName((Expression)invocation.arguments().get(1), false).equals("java.util.Locale");
            if (!is_getBundle && !is_getBundleWithLocale) {
                return null;
            }
            Expression bundleExpression = invocation.getExpression();
            String bundleTypeName = AstNodeUtils.getFullyQualifiedName(bundleExpression, true);
            if (!bundleTypeName.equals("java.util.ResourceBundle")) {
                return null;
            }
            StringLiteral bundleNameLiteral = (StringLiteral)invocation.arguments().get(0);
            return bundleNameLiteral.getLiteralValue();
        }
        return null;
    }

    public FieldSource(JavaInfo root, String bundleName, String fieldName) throws Exception {
        super(root, bundleName);
        this.m_fieldName = fieldName;
    }

    @Override
    public String getTypeTitle() throws Exception {
        return "ResourceBundle in field '" + this.m_fieldName + "'";
    }

    @Override
    protected IKeyGeneratorStrategy getKeyGeneratorStrategy() {
        return KEY_GENERATOR;
    }

    @Override
    protected Expression apply_renameKey_replaceKeyExpression(AstEditor editor, Expression keyExpression, String newKey) throws Exception {
        String newSource = StringConverter.INSTANCE.toJavaSource(this.m_root, newKey);
        return editor.replaceExpression(keyExpression, newSource);
    }

    @Override
    protected AbstractBundleSource.BasicExpressionInfo apply_externalize_replaceExpression(GenericProperty property, String key) throws Exception {
        Expression expression = property.getExpression();
        String code = String.valueOf(this.m_fieldName) + ".getString(" + StringConverter.INSTANCE.toJavaSource(this.m_root, key) + ")";
        ExpressionInfo expressionInfo = (ExpressionInfo)this.replaceExpression_getInfo(expression, code);
        this.addNonNLSComment(expressionInfo.m_keyExpression);
        return expressionInfo;
    }

    @Override
    protected void apply_removeNonNLSComments(AbstractBundleSource.BasicExpressionInfo basicExpressionInfo) throws Exception {
        ExpressionInfo expressionInfo = (ExpressionInfo)basicExpressionInfo;
        this.removeNonNLSComment((StringLiteral)expressionInfo.m_keyExpression);
    }

    public static FieldSource apply_create(IEditableSource editable, JavaInfo root, Object o) throws Exception {
        SourceParameters parameters = (SourceParameters)o;
        String bundleName = parameters.m_propertyBundleName;
        String fieldName = parameters.m_fieldName;
        FieldSource.createPropertyBundleFile(parameters.m_propertyPackage, parameters.m_propertyFileName, null);
        FieldSource.addField(root, bundleName, fieldName);
        return new FieldSource(root, bundleName, fieldName);
    }

    private static void addField(JavaInfo root, String bundleName, String fieldName) throws Exception {
        String code = "private static final java.util.ResourceBundle " + fieldName + " = java.util.ResourceBundle.getBundle(" + StringConverter.INSTANCE.toJavaSource(root, bundleName) + "); //$NON-NLS-1$";
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(root);
        root.getEditor().addFieldDeclaration(code, new BodyDeclarationTarget(typeDeclaration, true));
    }

    protected static class ExpressionInfo
    extends AbstractBundleSource.BasicExpressionInfo {
        private final String m_bundleName;
        private final String m_fieldName;

        public ExpressionInfo(Expression expression, String bundleName, String fieldName, StringLiteral keyExpression, String key) {
            super(expression, (Expression)keyExpression, key);
            this.m_bundleName = bundleName;
            this.m_fieldName = fieldName;
        }
    }
}

