/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.RequestProcessor;
import org.eclipse.wb.gef.core.events.IEditPartListener;
import org.eclipse.wb.gef.core.events.IEditPartSelectionListener;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.draw2d.events.EventTable;
import org.eclipse.wb.internal.gef.core.CompoundCommand;
import org.eclipse.wb.internal.gef.core.EditPartVisitor;

public abstract class EditPart {
    public static final int SELECTED_NONE = 0;
    public static final int SELECTED = 1;
    public static final int SELECTED_PRIMARY = 2;
    private EditPart m_parent;
    private List<EditPart> m_children;
    private boolean m_isActive;
    private final List<EditPolicy> m_policies = Lists.newArrayList();
    private final List<Object> m_keyPolicies = Lists.newArrayList();
    private int m_selected;
    private Object m_model;
    private EventTable m_eventTable;
    private final List<RequestProcessor> m_requestProcessors = Lists.newArrayList();

    public void activate() {
        this.m_isActive = true;
        this.activateEditPolicies();
        for (EditPart childPart : this.getChildren()) {
            childPart.activate();
        }
    }

    public void deactivate() {
        for (EditPart childPart : this.getChildren()) {
            childPart.deactivate();
        }
        this.deactivateEditPolicies();
        this.m_isActive = false;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public void addNotify() {
        this.getViewer().registerEditPart(this);
        this.createEditPolicies();
        for (EditPart childPart : this.getChildren()) {
            childPart.addNotify();
        }
        this.refresh();
    }

    public void removeNotify() {
        if (this.getSelected() != 0) {
            this.getViewer().deselect(this);
        }
        for (EditPart childPart : this.getChildren()) {
            childPart.removeNotify();
        }
        this.getViewer().unregisterEditPart(this);
    }

    public List<EditPart> getChildren() {
        return this.m_children == null ? Collections.emptyList() : this.m_children;
    }

    public EditPart getParent() {
        return this.m_parent;
    }

    public void setParent(EditPart parent) {
        this.m_parent = parent;
    }

    public Object getModel() {
        return this.m_model;
    }

    public void setModel(Object model) {
        this.m_model = model;
    }

    protected void updateModel() {
    }

    protected List<?> getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public int getSelected() {
        return this.m_selected;
    }

    public void setSelected(int selected) {
        if (this.m_selected != selected) {
            this.m_selected = selected;
            this.fireSelection();
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public final void accept(EditPartVisitor visitor) {
        if (visitor.visit(this)) {
            for (EditPart childPart : this.getChildren()) {
                childPart.accept(visitor);
            }
            visitor.endVisit(this);
        }
    }

    public void addEditPartListener(IEditPartListener listener) {
        this.getEnsureEventTable().addListener(IEditPartListener.class, listener);
    }

    public void removeEditPartListener(IEditPartListener listener) {
        this.getEnsureEventTable().removeListener(IEditPartListener.class, listener);
    }

    public void addSelectionListener(IEditPartSelectionListener listener) {
        this.getEnsureEventTable().addListener(IEditPartSelectionListener.class, listener);
    }

    public void removeSelectionListener(IEditPartSelectionListener listener) {
        this.getEnsureEventTable().removeListener(IEditPartSelectionListener.class, listener);
    }

    public <T> List<T> getListeners(Class<T> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }

    private EventTable getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventTable();
        }
        return this.m_eventTable;
    }

    private void fireChildAdded(EditPart child, int index) {
        List<IEditPartListener> listeners = this.getListeners(IEditPartListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            for (IEditPartListener listener : listeners) {
                listener.childAdded(child, index);
            }
        }
    }

    private void fireRemovingChild(EditPart child, int index) {
        List<IEditPartListener> listeners = this.getListeners(IEditPartListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            for (IEditPartListener listener : listeners) {
                listener.removingChild(child, index);
            }
        }
    }

    private void fireSelection() {
        List<IEditPartSelectionListener> listeners = this.getListeners(IEditPartSelectionListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            for (IEditPartSelectionListener listener : listeners) {
                listener.selectionChanged(this);
            }
        }
    }

    public void refresh() {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected void refreshVisuals() {
    }

    protected void refreshChildren() {
        EditPart childPart;
        HashMap<Object, EditPart> modelToPart = new HashMap<Object, EditPart>();
        List<EditPart> children = this.getChildren();
        for (EditPart editPart : children) {
            modelToPart.put(editPart.getModel(), editPart);
        }
        List<?> modelChildren = this.getModelChildren();
        int modelCount = modelChildren.size();
        int partCount = children.size();
        int index = 0;
        int modelIndex = 0;
        while (modelIndex < modelCount) {
            EditPart part;
            Object model = modelChildren.get(modelIndex);
            if (index < partCount && (part = children.get(index)).getModel() == model) {
                this.updateChildVisual(part, index);
            } else {
                childPart = (EditPart)modelToPart.get(model);
                if (childPart == null) {
                    EditPart createEditPart = this.createEditPart(model);
                    if (createEditPart != null) {
                        this.addChild(createEditPart, index);
                    } else {
                        --index;
                    }
                } else {
                    if (model != childPart.getModel()) {
                        this.getViewer().unregisterEditPart(childPart);
                        childPart.setModel(model);
                        this.getViewer().registerEditPart(childPart);
                        childPart.updateModel();
                    }
                    this.removeChildVisual(childPart);
                    children.remove(childPart);
                    children.add(index, childPart);
                    this.addChildVisual(childPart, index);
                }
            }
            ++index;
            ++modelIndex;
        }
        int newPartCount = children.size();
        if (newPartCount - index > 1) {
            ArrayList deselectList = Lists.newArrayList();
            Iterators.addAll((Collection)deselectList, children.listIterator(index));
            this.getViewer().deselect(deselectList);
        }
        int i = index;
        while (i < newPartCount) {
            childPart = children.get(index);
            this.removeChild(childPart);
            ++i;
        }
        for (EditPart child : this.getChildren()) {
            child.refresh();
        }
    }

    protected EditPart createEditPart(Object model) {
        IEditPartFactory factory = this.getViewer().getEditPartFactory();
        return factory.createEditPart(this, model);
    }

    protected final void removeChild(EditPart childPart) {
        int index = this.getChildren().indexOf(childPart);
        if (index == -1) {
            return;
        }
        this.fireRemovingChild(childPart, index);
        if (this.isActive()) {
            childPart.deactivate();
        }
        childPart.removeNotify();
        this.removeChildVisual(childPart);
        this.getChildren().remove(childPart);
        childPart.setParent(null);
    }

    protected final void addChild(EditPart childPart, int index) {
        Assert.isNotNull((Object)childPart);
        if (this.m_children == null) {
            this.m_children = Lists.newArrayList();
        }
        if (index == -1) {
            index = this.m_children.size();
            this.m_children.add(childPart);
        } else {
            this.m_children.add(index, childPart);
        }
        childPart.setParent(this);
        this.addChildVisual(childPart, index);
        childPart.addNotify();
        this.fireChildAdded(childPart, index);
        if (this.isActive()) {
            childPart.activate();
        }
    }

    public IEditPartViewer getViewer() {
        return this.getParent().getViewer();
    }

    protected abstract void addChildVisual(EditPart var1, int var2);

    protected abstract void removeChildVisual(EditPart var1);

    protected void updateChildVisual(EditPart childPart, int index) {
    }

    public List<EditPolicy> getEditPolicies() {
        return this.m_policies;
    }

    public EditPolicy getEditPolicy(Object key) {
        int index = this.m_keyPolicies.indexOf(key);
        return index == -1 ? null : this.m_policies.get(index);
    }

    public void installEditPolicy(EditPolicy policy) {
        this.installEditPolicy(policy.getClass(), policy);
    }

    public void installEditPolicy(Object key, EditPolicy policy) {
        Assert.isNotNull((Object)key, (String)"Edit Policies must be installed with keys");
        int index = this.m_keyPolicies.indexOf(key);
        if (index == -1) {
            if (policy != null) {
                this.m_keyPolicies.add(key);
                this.m_policies.add(policy);
            }
        } else {
            EditPolicy oldPolicy = this.m_policies.get(index);
            if (this.isActive()) {
                oldPolicy.deactivate();
            }
            if (policy == null) {
                this.m_keyPolicies.remove(index);
                this.m_policies.remove(index);
            } else {
                this.m_policies.set(index, policy);
            }
            oldPolicy.dispose();
        }
        if (policy != null) {
            policy.setHost(this);
            if (this.isActive()) {
                policy.activate();
            }
        }
    }

    private void activateEditPolicies() {
        for (EditPolicy editPolicy : this.m_policies) {
            editPolicy.activate();
        }
    }

    private void deactivateEditPolicies() {
        for (EditPolicy editPolicy : this.m_policies) {
            editPolicy.deactivate();
        }
    }

    protected void createEditPolicies() {
    }

    private List<EditPolicy> getUnderstandingPolicies(Request request) {
        ArrayList policies = Lists.newArrayList();
        for (EditPolicy editPolicy : this.m_policies) {
            if (!editPolicy.understandsRequest(request)) continue;
            policies.add(editPolicy);
        }
        return policies;
    }

    public final void addRequestProcessor(RequestProcessor processor) {
        if (!this.m_requestProcessors.contains(processor)) {
            this.m_requestProcessors.add(processor);
        }
    }

    public final void removeRequestProcessor(RequestProcessor processor) {
        this.m_requestProcessors.remove(processor);
    }

    protected final Request processRequestProcessors(Request request) {
        try {
            for (RequestProcessor processor : this.m_requestProcessors) {
                request = processor.process(this, request);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return request;
    }

    public abstract Tool getDragTrackerTool(Request var1);

    public Command getCommand(Request request) {
        request = this.processRequestProcessors(request);
        for (EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
            Command command = editPolicy.getCommand(request);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    public CompoundCommand createCompoundCommand() {
        return new CompoundCommand();
    }

    public EditPart getTargetEditPart(Request request) {
        request = this.processRequestProcessors(request);
        EditPart target = null;
        for (EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
            EditPart newTarget = editPolicy.getTargetEditPart(request);
            if (newTarget == null) continue;
            target = newTarget;
        }
        return target;
    }

    public void performRequest(Request request) {
        request = this.processRequestProcessors(request);
        for (EditPolicy editPolicy : this.m_policies) {
            editPolicy.performRequest(request);
        }
    }

    public void showSourceFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.showSourceFeedback(request);
            }
        }
    }

    public void eraseSourceFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.eraseSourceFeedback(request);
            }
        }
    }

    public void showTargetFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.showTargetFeedback(request);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        request = this.processRequestProcessors(request);
        if (this.isActive()) {
            for (EditPolicy editPolicy : this.getUnderstandingPolicies(request)) {
                editPolicy.eraseTargetFeedback(request);
            }
        }
    }
}

