/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import java.util.Collections;
import java.util.List;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MenuObjectEditPart;
import org.eclipse.wb.internal.core.gef.policy.menu.MenuSelectionEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.menu.SubmenuAwareLayoutEditPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;

public abstract class SubmenuAwareEditPart
extends MenuObjectEditPart {
    private final IMenuObjectInfo m_object;

    public SubmenuAwareEditPart(Object toolkitModel, IMenuObjectInfo menuModel) {
        super(toolkitModel, menuModel);
        this.m_object = menuModel;
    }

    @Override
    public final Figure getContentPane() {
        return this.getViewer().getLayer("Menu Primary Layer");
    }

    @Override
    protected void addChildVisual(EditPart childPart, int index) {
        GraphicalEditPart graphicalPart = (GraphicalEditPart)childPart;
        this.getContentPane().add(graphicalPart.getFigure());
        graphicalPart.getFigure().setData(childPart);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", new SubmenuAwareLayoutEditPolicy(this.m_object));
        this.installEditPolicy("Selection Feedback", new MenuSelectionEditPolicy());
    }

    @Override
    protected final List<?> getModelChildren() {
        Object childMenu;
        EditPart selectedEditPart;
        MenuObjectEditPart menuObjectEditPart;
        IMenuObjectInfo selectedObject = null;
        List<EditPart> selectedEditParts = this.getViewer().getSelectedEditParts();
        if (!selectedEditParts.isEmpty() && (menuObjectEditPart = SubmenuAwareEditPart.getMenuObjectEditPart(selectedEditPart = selectedEditParts.get(selectedEditParts.size() - 1))) != null) {
            selectedObject = menuObjectEditPart.getMenuModel();
        }
        if ((MenuObjectInfoUtils.isParentChild(this.m_object, selectedObject) || MenuObjectInfoUtils.isParentChild(this.m_object, MenuObjectInfoUtils.m_selectingObject)) && (childMenu = this.getChildMenu()) != null) {
            return Collections.singletonList(childMenu);
        }
        return Collections.EMPTY_LIST;
    }

    private static MenuObjectEditPart getMenuObjectEditPart(EditPart editPart) {
        while (editPart != null) {
            if (editPart instanceof MenuObjectEditPart) {
                return (MenuObjectEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        return null;
    }

    protected abstract Object getChildMenu();
}

