/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class XbaseIdeCrossrefProposalProvider
extends IdeCrossrefProposalProvider {
    @Inject
    private CommonTypeComputationServices typeComputationServices;

    public ContentAssistEntry createProposal(IEObjectDescription candidate, CrossReference crossRef, ContentAssistContext context) {
        if (this.hasIdRule(crossRef)) {
            ProposalBracketInfo bracketInfo = this.getProposalBracketInfo(candidate, context);
            String proposalString = this.getQualifiedNameConverter().toString(candidate.getName()) + bracketInfo.brackets;
            int insignificantParameters = candidate instanceof IIdentifiableElementDescription ? ((IIdentifiableElementDescription)candidate).getNumberOfIrrelevantParameters() : 0;
            LightweightTypeReferenceFactory converter = this.getTypeConverter(context.getResource());
            EObject objectOrProxy = candidate.getEObjectOrProxy();
            return this.getProposalCreator().createProposal(proposalString, context, result -> {
                result.setKind("REFERENCE");
                if (objectOrProxy instanceof JvmFeature) {
                    if (bracketInfo.brackets.startsWith(" =")) {
                        this.addNameAndDescription((ContentAssistEntry)result, (JvmFeature)objectOrProxy, false, insignificantParameters, this.getQualifiedNameConverter().toString(candidate.getName()) + bracketInfo.brackets, converter);
                    } else {
                        this.addNameAndDescription((ContentAssistEntry)result, (JvmFeature)objectOrProxy, !Strings.isNullOrEmpty((String)bracketInfo.brackets), insignificantParameters, this.getQualifiedNameConverter().toString(candidate.getName()), converter);
                    }
                } else {
                    this.addNameAndDescription((ContentAssistEntry)result, objectOrProxy, this.getQualifiedNameConverter().toString(candidate.getQualifiedName()), this.getQualifiedNameConverter().toString(candidate.getName()));
                }
                int offset = context.getOffset() - context.getPrefix().length() + proposalString.length();
                result.setEscapePosition(Integer.valueOf(offset + bracketInfo.caretOffset));
                if (bracketInfo.selectionOffset != 0) {
                    result.getEditPositions().add(new TextRegion(offset += bracketInfo.selectionOffset, bracketInfo.selectionLength));
                }
                if (objectOrProxy instanceof JvmExecutable) {
                    StringBuilder parameterList = new StringBuilder();
                    this.appendParameters(parameterList, (JvmExecutable)objectOrProxy, insignificantParameters, converter);
                }
            });
        }
        return super.createProposal(candidate, crossRef, context);
    }

    protected boolean hasIdRule(CrossReference crossRef) {
        if (crossRef.getTerminal() instanceof RuleCall) {
            String ruleName = ((RuleCall)crossRef.getTerminal()).getRule().getName();
            return "IdOrSuper".equals(ruleName) || "ValidID".equals(ruleName) || "FeatureCallID".equals(ruleName);
        }
        return false;
    }

    protected ProposalBracketInfo getProposalBracketInfo(IEObjectDescription proposedDescription, ContentAssistContext contentAssistContext) {
        ProposalBracketInfo info = new ProposalBracketInfo();
        if (proposedDescription instanceof IIdentifiableElementDescription) {
            JvmIdentifiableElement jvmFeature = ((IIdentifiableElementDescription)proposedDescription).getElementOrProxy();
            if (jvmFeature instanceof JvmExecutable) {
                EList parameters = ((JvmExecutable)jvmFeature).getParameters();
                if (((IIdentifiableElementDescription)proposedDescription).getNumberOfParameters() == 1) {
                    if (((JvmExecutable)jvmFeature).getSimpleName().startsWith("set") && !((IIdentifiableElementDescription)proposedDescription).getName().getFirstSegment().startsWith("set")) {
                        info.brackets = " = value";
                        info.selectionOffset = -"value".length();
                        info.selectionLength = "value".length();
                        return info;
                    }
                    JvmTypeReference parameterType = ((JvmFormalParameter)IterableExtensions.last((Iterable)parameters)).getParameterType();
                    LightweightTypeReference light = this.getTypeConverter(contentAssistContext.getResource()).toLightweightReference(parameterType);
                    if (light.isFunctionType()) {
                        int numParameters = light.getAsFunctionTypeReference().getParameterTypes().size();
                        if (numParameters == 1) {
                            info.brackets = "[]";
                            info.caretOffset = -1;
                            return info;
                        }
                        if (numParameters == 0) {
                            info.brackets = "[|]";
                            info.caretOffset = -1;
                            return info;
                        }
                        StringBuilder b = new StringBuilder();
                        for (int i = 0; i < numParameters; ++i) {
                            if (i != 0) {
                                b.append(", ");
                            }
                            b.append("p" + (i + 1));
                        }
                        info.brackets = "[" + b.toString() + "|]";
                        info.caretOffset = -1;
                        info.selectionOffset = -b.length() - 2;
                        info.selectionLength = b.length();
                        return info;
                    }
                }
            }
            if (this.isExplicitOperationCall((IIdentifiableElementDescription)proposedDescription)) {
                info.brackets = "()";
                info.selectionOffset = -1;
            }
        }
        return info;
    }

    protected LightweightTypeReferenceFactory getTypeConverter(XtextResource context) {
        return new LightweightTypeReferenceFactory((ITypeReferenceOwner)new StandardTypeReferenceOwner(this.typeComputationServices, (Resource)context)){

            public LightweightTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                LightweightTypeReference result = super.doVisitParameterizedTypeReference(reference);
                if (result.isFunctionType()) {
                    return result.tryConvertToFunctionTypeReference(false);
                }
                return result;
            }
        };
    }

    protected void addNameAndDescription(ContentAssistEntry entry, JvmFeature feature, boolean withParents, int insignificantParameters, String shortName, LightweightTypeReferenceFactory converter) {
        StringBuilder labelBuilder = new StringBuilder(shortName);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (feature instanceof JvmOperation) {
            JvmOperation jvmOperation;
            JvmTypeReference returnType;
            if (withParents) {
                labelBuilder.append("(");
                this.appendParameters(labelBuilder, (JvmExecutable)feature, insignificantParameters, converter);
                labelBuilder.append(")");
            }
            if ((returnType = (jvmOperation = (JvmOperation)feature).getReturnType()) != null && returnType.getSimpleName() != null) {
                labelBuilder.append(" : ");
                labelBuilder.append(converter.toLightweightReference(returnType).getHumanReadableName());
            }
            descriptionBuilder.append(converter.toPlainTypeReference((JvmType)jvmOperation.getDeclaringType()).getHumanReadableName());
            if (!withParents) {
                descriptionBuilder.append(".");
                descriptionBuilder.append(jvmOperation.getSimpleName());
                descriptionBuilder.append("()");
            }
        } else if (feature instanceof JvmField) {
            String fieldType;
            labelBuilder.append(" : ");
            JvmField jvmField = (JvmField)feature;
            if (jvmField.getType() != null && (fieldType = converter.toLightweightReference(jvmField.getType()).getHumanReadableName()) != null) {
                labelBuilder.append(fieldType);
            }
            descriptionBuilder.append(converter.toPlainTypeReference((JvmType)jvmField.getDeclaringType()).getHumanReadableName());
        } else if (feature instanceof JvmConstructor && withParents) {
            labelBuilder.append("(");
            this.appendParameters(labelBuilder, (JvmExecutable)feature, insignificantParameters, converter);
            labelBuilder.append(")");
        }
        entry.setLabel(labelBuilder.toString());
        entry.setDescription(descriptionBuilder.toString());
    }

    protected void addNameAndDescription(ContentAssistEntry entry, EObject element, String qualifiedNameAsString, String shortName) {
        QualifiedName qualifiedName = this.getQualifiedNameConverter().toQualifiedName(qualifiedNameAsString);
        if (qualifiedName.getSegmentCount() > 1) {
            entry.setLabel(qualifiedName.getLastSegment());
            entry.setDescription(qualifiedNameAsString);
        } else {
            entry.setLabel(qualifiedNameAsString);
        }
    }

    protected void appendParameters(StringBuilder result, JvmExecutable executable, int insignificantParameters, LightweightTypeReferenceFactory ownedConverter) {
        EList declaredParameters = executable.getParameters();
        List relevantParameters = declaredParameters.subList(Math.min(insignificantParameters, declaredParameters.size()), declaredParameters.size());
        for (int i = 0; i < relevantParameters.size(); ++i) {
            String simpleName;
            JvmFormalParameter parameter = (JvmFormalParameter)relevantParameters.get(i);
            if (i != 0) {
                result.append(", ");
            }
            if (i == relevantParameters.size() - 1 && executable.isVarArgs() && parameter.getParameterType() instanceof JvmGenericArrayTypeReference) {
                JvmGenericArrayTypeReference parameterType = (JvmGenericArrayTypeReference)parameter.getParameterType();
                result.append(ownedConverter.toLightweightReference(parameterType.getComponentType()).getHumanReadableName());
                result.append("...");
            } else if (parameter.getParameterType() != null && (simpleName = ownedConverter.toLightweightReference(parameter.getParameterType()).getHumanReadableName()) != null) {
                result.append(simpleName);
            }
            result.append(" ");
            result.append(String.valueOf(parameter.getName()));
        }
    }

    protected boolean isExplicitOperationCall(IIdentifiableElementDescription desc) {
        return desc.getNumberOfParameters() > 0;
    }

    public static class ProposalBracketInfo {
        private String brackets = "";
        private int selectionOffset = 0;
        private int selectionLength = 0;
        private int caretOffset = 0;
    }
}

