/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;

public class CycleChecker {
    public static boolean hasDirectedCircles(LayoutEntity[] entities, LayoutRelationship[] relationships, List cycle) {
        if (!AbstractLayoutAlgorithm.verifyInput(entities, relationships)) {
            throw new RuntimeException("The endpoints of the relationships aren't contained in the entities list.");
        }
        Hashtable endPoints = new Hashtable();
        int i = 0;
        while (i < relationships.length) {
            LayoutRelationship rel = relationships[i];
            LayoutEntity subject = rel.getSourceInLayout();
            ArrayList<LayoutRelationship> rels = (ArrayList<LayoutRelationship>)endPoints.get(subject);
            if (rels == null) {
                rels = new ArrayList<LayoutRelationship>();
                endPoints.put(subject, rels);
            }
            if (!rels.contains(rel)) {
                rels.add(rel);
            }
            ++i;
        }
        boolean hasCyle = CycleChecker.hasCycle(new ArrayList<LayoutEntity>(Arrays.asList(entities)), endPoints, cycle);
        return hasCyle;
    }

    private static boolean hasCycle(List nodesToCheck, Hashtable endPoints, List cycle) {
        while (nodesToCheck.size() > 0) {
            ArrayList checkedNodes;
            Object checkNode = nodesToCheck.get(0);
            if (CycleChecker.hasCycle(checkNode, new ArrayList(), null, endPoints, checkedNodes = new ArrayList(), cycle)) {
                return true;
            }
            nodesToCheck.removeAll(checkedNodes);
        }
        return false;
    }

    private static boolean hasCycle(Object nodeToCheck, List nodePathSoFar, SimpleRelationship cameFrom, Hashtable endPoints, List nodesChecked, List cycle) {
        if (nodePathSoFar.contains(nodeToCheck)) {
            cycle.addAll(nodePathSoFar);
            cycle.add(nodeToCheck);
            return true;
        }
        nodePathSoFar.add(nodeToCheck);
        nodesChecked.add(nodeToCheck);
        List relations = (List)endPoints.get(nodeToCheck);
        if (relations != null) {
            for (SimpleRelationship rel : relations) {
                if (cameFrom != null && rel.equals(cameFrom)) continue;
                LayoutEntity currentNode = null;
                currentNode = rel.getDestinationInLayout();
                if (!CycleChecker.hasCycle(currentNode, nodePathSoFar, rel, endPoints, nodesChecked, cycle)) continue;
                return true;
            }
        }
        nodePathSoFar.remove(nodeToCheck);
        return false;
    }
}

