/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import java.util.Properties;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentLabelUpdate;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementLabelProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.ui.progress.UIJob;

public class DocumentLabelProvider
extends BaseLabelProvider {
    private VirtualDocument fDocument;

    public DocumentLabelProvider(VirtualDocument document) {
        this.fDocument = document;
    }

    public void update(Object parent, Object element, int index, IDocumentPresentation context) {
        IDocumentElementLabelProvider labelProvider = this.getLabelAdapter(element);
        if (labelProvider != null) {
            Object root = this.getDocument().getContentProvider().getRoot();
            Object base = this.getDocument().getContentProvider().getBase();
            labelProvider.update(new DocumentLabelUpdate[]{new DocumentLabelUpdate(this, context, root, base, element, index)});
        }
    }

    public void completed(DocumentLabelUpdate update) {
        if (update.isCanceled()) {
            return;
        }
        UIJob uiJob = null;
        final int index = update.getIndex();
        if (update.getElement() != null) {
            final Object element = update.getElement();
            final Properties labels = update.getLabels();
            uiJob = new UIJob("Replace line"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DocumentLabelProvider.this.getDocument().labelDone(element, index, labels);
                    return Status.OK_STATUS;
                }
            };
        } else {
            uiJob = new UIJob("Remove line"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DocumentLabelProvider.this.getDocument().removeLine(index);
                    return Status.OK_STATUS;
                }
            };
        }
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    protected VirtualDocument getDocument() {
        return this.fDocument;
    }

    protected IDocumentElementLabelProvider getLabelAdapter(Object element) {
        IDocumentElementLabelProvider adapter = null;
        if (element instanceof IDocumentElementLabelProvider) {
            adapter = (IDocumentElementLabelProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IDocumentElementLabelProvider)adaptable.getAdapter(IDocumentElementLabelProvider.class);
        }
        return adapter;
    }
}

