/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.core.model.IModuleRetrieval;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class ModulesViewEventHandler
extends DebugEventHandler {
    private IModuleRetrieval fModuleRetrieval;

    public ModulesViewEventHandler(AbstractModelProxy proxy, IModuleRetrieval moduleRetrieval) {
        super(proxy);
        this.fModuleRetrieval = moduleRetrieval;
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getKind() == 4 || event.getKind() == 8 || event.getKind() == 16;
    }

    protected void handleChange(DebugEvent event) {
        if (event.getSource() instanceof ICModule) {
            this.fireDelta((ICModule)event.getSource(), 2048);
        }
    }

    protected void handleCreate(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugTarget) {
            this.refreshRoot(event);
        } else if (source instanceof ICModule && this.accept((ICModule)source)) {
            ICModule module = (ICModule)source;
            this.fireDelta(module, 1);
        }
    }

    protected void handleTerminate(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugTarget) {
            this.refreshRoot(event);
        } else if (source instanceof ICModule) {
            this.fireDelta((ICModule)source, 2);
        }
    }

    private void fireDelta(ICModule module, int flags) {
        ModelDelta root = new ModelDelta((Object)this.fModuleRetrieval, 0);
        root.addNode((Object)module, flags);
        this.fireDelta((IModelDelta)root);
    }

    public synchronized void dispose() {
        super.dispose();
        this.fModuleRetrieval = null;
    }

    private boolean accept(ICModule module) {
        return this.fModuleRetrieval.equals(module.getAdapter(IModuleRetrieval.class));
    }
}

