/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools.doxygen;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.doxygen.DoxygenOptions;
import org.eclipse.cdt.doxygen.core.DoxygenConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.ui.text.doctools.DefaultMultilineCommentAutoEditStrategy;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DoxygenMultilineAutoEditStrategy
extends DefaultMultilineCommentAutoEditStrategy
implements DefaultMultilineCommentAutoEditStrategy.IDocCustomizer {
    private static final String SINGLELINE_COMMENT_PRECEDING_1 = "//!< ";
    private static final String SINGLELINE_COMMENT_PRECEDING_2 = "///< ";
    private static final String SINGLELINE_COMMENT_PRECEDING_3 = "/*!< ";
    private static final String SINGLELINE_COMMENT_PRECEDING_4 = "/**< ";
    private static final Pattern STYLE_1 = Pattern.compile("\\s*//!");
    private static final Pattern STYLE_2 = Pattern.compile("\\s*///");
    private static final Pattern STYLE_3 = Pattern.compile("\\s*\\/\\*+!");
    private static final Pattern STYLE_4 = Pattern.compile("\\s*\\/\\*\\*+");
    private static final String SINGLELINE_COMMENT_ENDING = " */";
    private static final String CLASS = "class ";
    private static final String ENUM = "enum ";
    private static final String THROW = "throw ";
    private static final String STRUCT = "struct ";
    private static final String UNION = "union ";
    private static final String BRIEF = "brief ";
    private static final String PRE = "pre ";
    private static final String POST = "post ";
    private static final String PARAM = "param ";
    private static final String FUNC = "fn ";
    private static final String TPARAM = "tparam ";
    private static final String RETURN = "return";
    private static final String DEF = "def ";
    private static final String NAMESPACE = "namespace ";
    private static final String PREFIX_JAVADOC = "@";
    private static final String PREFIX_NO_JAVADOC = "\\";
    protected boolean documentPureVirtuals = true;
    protected boolean documentDeclarations = true;
    private String fLineDelimiter;
    private boolean useBriefTag;
    private boolean useStructuralCommands;
    private boolean useJavadocStyle;
    private boolean newLineAfterBrief;
    private boolean usePrePostTag;
    private final DoxygenConfiguration doxygenConfiguration = (DoxygenConfiguration)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext()).get(DoxygenConfiguration.class);

    public DoxygenMultilineAutoEditStrategy(ICProject project) {
        super(project);
    }

    public DoxygenMultilineAutoEditStrategy() {
        this(null);
    }

    private void refreshPreferences() {
        Optional<IProject> project = this.getProject();
        DoxygenOptions options = project.isPresent() ? this.doxygenConfiguration.projectOptions(project.get()) : this.doxygenConfiguration.workspaceOptions();
        this.newLineAfterBrief = options.newLineAfterBrief();
        this.useBriefTag = options.useBriefTags();
        this.useJavadocStyle = options.useJavadocStyle();
        this.usePrePostTag = options.usePrePostTag();
        this.useStructuralCommands = options.useStructuralCommands();
    }

    private String getPrefix() {
        return this.useJavadocStyle ? PREFIX_JAVADOC : PREFIX_NO_JAVADOC;
    }

    private StringBuilder getBriefTag() {
        StringBuilder result = new StringBuilder();
        if (this.useBriefTag) {
            result.append(this.getPrefix()).append(BRIEF).append(this.getLineDelimiter());
            if (this.newLineAfterBrief) {
                result.append(this.getLineDelimiter());
            }
        }
        return result;
    }

    private StringBuilder getPrePostTag() {
        StringBuilder result = new StringBuilder();
        if (this.usePrePostTag) {
            result.append(this.getPrefix()).append(PRE).append(this.getLineDelimiter()).append(this.getPrefix()).append(POST).append(this.getLineDelimiter());
        }
        return result;
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    protected StringBuilder documentComposite(IASTCompositeTypeSpecifier decl, ICPPASTTemplateParameter[] templateParams) {
        StringBuilder result = new StringBuilder();
        if (this.useStructuralCommands) {
            switch (decl.getKey()) {
                case 3: {
                    result.append(this.getPrefix()).append(CLASS).append(decl.getName().getSimpleID()).append(this.getLineDelimiter());
                    break;
                }
                case 1: {
                    result.append(this.getPrefix()).append(STRUCT).append(decl.getName().getSimpleID()).append(this.getLineDelimiter());
                    break;
                }
                case 2: {
                    result.append(this.getPrefix()).append(UNION).append(decl.getName().getSimpleID()).append(this.getLineDelimiter());
                }
            }
        }
        result.append((CharSequence)this.getBriefTag()).append((CharSequence)this.documentTemplateParameters(templateParams));
        return result;
    }

    protected StringBuilder documentFunction(IASTFunctionDeclarator decl, IASTDeclSpecifier ds, ICPPASTTemplateParameter[] templateParams) {
        IASTSimpleDeclSpecifier sds;
        StringBuilder result = new StringBuilder();
        if (this.useStructuralCommands) {
            result.append(this.getPrefix()).append(FUNC).append(ASTStringUtil.getSignatureString((IASTDeclSpecifier)ds, null)).append(" ").append(ASTStringUtil.getSimpleName((IASTName)decl.getName())).append(ASTStringUtil.getSignatureString(null, (IASTDeclarator)decl)).append(this.getLineDelimiter());
        }
        result.append((CharSequence)this.getBriefTag()).append((CharSequence)this.getPrePostTag());
        result.append((CharSequence)this.documentTemplateParameters(templateParams));
        result.append((CharSequence)this.documentFunctionParameters(this.getParameterDecls(decl)));
        if (decl instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator cppDecl = (ICPPASTFunctionDeclarator)decl;
            result.append((CharSequence)this.documentExceptions(cppDecl.getExceptionSpecification(), cppDecl.getNoexceptExpression()));
        }
        boolean hasReturn = true;
        if (ds instanceof IASTSimpleDeclSpecifier && ((sds = (IASTSimpleDeclSpecifier)ds).getType() == 1 || sds.getType() == 0)) {
            hasReturn = false;
        }
        if (hasReturn) {
            result.append((CharSequence)this.documentFunctionReturn());
        }
        return result;
    }

    protected StringBuilder documentTemplateParameters(ICPPASTTemplateParameter[] templateParams) {
        StringBuilder result = new StringBuilder();
        if (templateParams == null || templateParams.length == 0) {
            return result;
        }
        ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = templateParams;
        int n = templateParams.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTTemplateParameter t = iCPPASTTemplateParameterArray[n2];
            IASTName name = CPPTemplates.getTemplateParameterName((ICPPASTTemplateParameter)t);
            result.append(this.getPrefix()).append(TPARAM).append(new String(name.getSimpleID())).append(this.getLineDelimiter());
            ++n2;
        }
        return result;
    }

    protected StringBuilder documentFunctionParameters(IASTParameterDeclaration[] decls) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < decls.length) {
            if (!this.isVoidParameter(decls[i])) {
                result.append(this.getPrefix()).append(PARAM).append(this.getParameterName(decls[i])).append(this.getLineDelimiter());
            }
            ++i;
        }
        return result;
    }

    private String getLineDelimiter() {
        return this.fLineDelimiter;
    }

    String getParameterName(IASTParameterDeclaration decl) {
        IASTDeclarator dtor = decl.getDeclarator();
        int i = 0;
        while (i < 8 && dtor.getName().getRawSignature().length() == 0 && dtor.getNestedDeclarator() != null) {
            dtor = dtor.getNestedDeclarator();
            ++i;
        }
        return dtor.getName().getRawSignature();
    }

    boolean isVoidParameter(IASTParameterDeclaration decl) {
        IASTDeclarator dtor;
        return decl.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)decl.getDeclSpecifier()).getType() == 1 && (dtor = decl.getDeclarator()).getPointerOperators().length == 0 && !(dtor instanceof IASTFunctionDeclarator) && !(dtor instanceof IASTArrayDeclarator);
    }

    protected StringBuilder documentFunctionReturn() {
        return new StringBuilder(this.getPrefix()).append(RETURN).append(this.getLineDelimiter());
    }

    protected IASTParameterDeclaration[] getParameterDecls(IASTFunctionDeclarator decl) {
        IASTParameterDeclaration[] result;
        if (decl instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator standardFunctionDecl = (IASTStandardFunctionDeclarator)decl;
            result = standardFunctionDecl.getParameters();
        } else {
            result = new IASTParameterDeclaration[]{};
        }
        return result;
    }

    @Override
    public StringBuilder customizeForDeclaration(IDocument doc, IASTNode declToDocument, ITypedRegion partition, DefaultMultilineCommentAutoEditStrategy.CustomizeOptions options) {
        ICPPASTLinkageSpecification linkageSpecification;
        IASTDeclaration[] declarations;
        this.refreshPreferences();
        this.fLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        if (declToDocument instanceof ICPPASTLinkageSpecification && (declarations = (linkageSpecification = (ICPPASTLinkageSpecification)declToDocument).getDeclarations()).length == 1) {
            boolean isCurlyExtern = false;
            IToken token = null;
            try {
                token = declarations[0].getTrailingSyntax();
            }
            catch (UnsupportedOperationException e) {
                return new StringBuilder();
            }
            catch (ExpansionOverlapsBoundaryException e) {
                return new StringBuilder();
            }
            if (token != null && token.getType() == 13) {
                isCurlyExtern = true;
            }
            if (!isCurlyExtern) {
                declToDocument = declarations[0];
            }
        }
        if (options != null && (this.useBriefTag || this.useStructuralCommands)) {
            options.addNewLine = false;
        }
        ICPPASTTemplateParameter[] params = null;
        if (declToDocument instanceof ICPPASTTemplateDeclaration) {
            params = ((ICPPASTTemplateDeclaration)declToDocument).getTemplateParameters();
        }
        while (declToDocument instanceof ICPPASTTemplateDeclaration) {
            declToDocument = ((ICPPASTTemplateDeclaration)declToDocument).getDeclaration();
        }
        if (declToDocument instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fd = (IASTFunctionDefinition)declToDocument;
            return this.documentFunction(fd.getDeclarator(), fd.getDeclSpecifier(), params);
        }
        if (declToDocument instanceof IASTPreprocessorMacroDefinition) {
            return this.documentDefine((IASTPreprocessorMacroDefinition)declToDocument);
        }
        if (declToDocument instanceof ICPPASTNamespaceDefinition) {
            return this.documentNamespace((ICPPASTNamespaceDefinition)declToDocument);
        }
        if (declToDocument instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdec = (IASTSimpleDeclaration)declToDocument;
            if (sdec.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                return this.documentComposite((IASTCompositeTypeSpecifier)sdec.getDeclSpecifier(), params);
            }
            IASTDeclarator[] dcs = sdec.getDeclarators();
            if (dcs.length == 1 && dcs[0] instanceof IASTFunctionDeclarator) {
                IASTFunctionDeclarator fdecl = (IASTFunctionDeclarator)dcs[0];
                boolean shouldDocument = this.documentDeclarations;
                if (this.documentPureVirtuals && dcs[0] instanceof ICPPASTFunctionDeclarator) {
                    ICPPASTFunctionDeclarator cppfdecl = (ICPPASTFunctionDeclarator)dcs[0];
                    boolean bl = shouldDocument = shouldDocument || cppfdecl.isPureVirtual();
                }
                if (shouldDocument) {
                    return this.documentFunction(fdecl, sdec.getDeclSpecifier(), params);
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (declToDocument instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)declToDocument).getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
            builder = this.documentEnum((IASTEnumerationSpecifier)((IASTSimpleDeclaration)declToDocument).getDeclSpecifier());
        }
        try {
            this.alterDoc(doc, declToDocument, partition);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return builder;
    }

    protected StringBuilder documentDefine(IASTPreprocessorMacroDefinition dec) {
        StringBuilder result = new StringBuilder();
        if (this.useStructuralCommands) {
            result.append(this.getPrefix()).append(DEF).append(new String(dec.getName().getSimpleID())).append(this.getLineDelimiter());
        }
        return result.append((CharSequence)this.getBriefTag());
    }

    protected StringBuilder documentNamespace(ICPPASTNamespaceDefinition dec) {
        StringBuilder result = new StringBuilder();
        if (this.useStructuralCommands) {
            result.append(this.getPrefix()).append(NAMESPACE).append(new String(dec.getName().getSimpleID())).append(this.getLineDelimiter());
        }
        return result.append((CharSequence)this.getBriefTag());
    }

    protected StringBuilder documentEnum(IASTEnumerationSpecifier dec) {
        StringBuilder result = new StringBuilder();
        if (this.useStructuralCommands) {
            result.append(this.getPrefix()).append(ENUM).append(new String(dec.getName().getSimpleID())).append(this.getLineDelimiter());
        }
        return result.append((CharSequence)this.getBriefTag());
    }

    protected StringBuilder documentExceptions(IASTTypeId[] exceptions, ICPPASTExpression noexcept) {
        StringBuilder result = new StringBuilder();
        if (exceptions == ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION || exceptions == IASTTypeId.EMPTY_TYPEID_ARRAY) {
            if (noexcept != null && noexcept != ICPPASTFunctionDeclarator.NOEXCEPT_DEFAULT && !this.isNoexceptTrue(noexcept)) {
                result.append(this.getPrefix()).append(THROW).append(this.getLineDelimiter());
            }
        } else {
            int i = 0;
            while (i < exceptions.length) {
                result.append(this.getPrefix()).append(THROW);
                if (exceptions[i] instanceof ICPPASTTypeId && ((ICPPASTTypeId)exceptions[i]).isPackExpansion()) {
                    result.append(this.getLineDelimiter());
                } else {
                    result.append(ASTStringUtil.getSignatureString((IASTDeclarator)exceptions[i].getAbstractDeclarator())).append(this.getLineDelimiter());
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isNoexceptTrue(ICPPASTExpression expr) {
        if (expr instanceof IASTLiteralExpression) {
            return ((IASTLiteralExpression)expr).getKind() == 5;
        }
        return false;
    }

    private void alterDoc(IDocument doc, IASTNode dec, ITypedRegion partition) throws BadLocationException {
        if (dec instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)dec).getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
            String preceding;
            String partComment = doc.get(partition.getOffset(), partition.getLength());
            String ending = "";
            if (STYLE_1.matcher(partComment).find()) {
                preceding = SINGLELINE_COMMENT_PRECEDING_1;
            } else if (STYLE_2.matcher(partComment).find()) {
                preceding = SINGLELINE_COMMENT_PRECEDING_2;
            } else if (STYLE_3.matcher(partComment).find()) {
                preceding = SINGLELINE_COMMENT_PRECEDING_3;
                ending = SINGLELINE_COMMENT_ENDING;
            } else if (STYLE_4.matcher(partComment).find()) {
                preceding = SINGLELINE_COMMENT_PRECEDING_4;
                ending = SINGLELINE_COMMENT_ENDING;
            } else {
                preceding = SINGLELINE_COMMENT_PRECEDING_1;
            }
            IASTEnumerationSpecifier spc = (IASTEnumerationSpecifier)((IASTSimpleDeclaration)dec).getDeclSpecifier();
            IASTEnumerationSpecifier.IASTEnumerator[] enms = spc.getEnumerators();
            boolean noCollisions = true;
            class Entry {
                final int offset;
                final int length;
                StringBuilder comment;

                Entry(int offset, int length, String comment) {
                    this.offset = offset;
                    this.length = length;
                    this.comment = new StringBuilder(comment);
                }

                public int hashCode() {
                    return this.offset;
                }

                public boolean equals(Object obj) {
                    if (obj instanceof Entry) {
                        Entry other = (Entry)obj;
                        return this.offset == other.offset;
                    }
                    return false;
                }
            }
            LinkedHashSet<Entry> entries = new LinkedHashSet<Entry>();
            IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = enms;
            int n = enms.length;
            int n2 = 0;
            while (n2 < n) {
                IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
                IASTFileLocation loc = enumerator.getName().getFileLocation();
                if (loc != null) {
                    int nodeOffset = loc.getNodeOffset() + loc.getNodeLength();
                    String cmt = String.valueOf(preceding) + enumerator.getName() + ending;
                    IRegion line = doc.getLineInformationOfOffset(nodeOffset);
                    if (!doc.get(line.getOffset(), line.getLength()).contains("//")) {
                        noCollisions &= entries.add(new Entry(line.getOffset(), line.getLength(), cmt));
                    }
                }
                ++n2;
            }
            if (noCollisions) {
                int max = Integer.MIN_VALUE;
                for (Entry e : entries) {
                    if (e.length <= max) continue;
                    max = e.length;
                }
                int addedLength = 0;
                for (Entry e : entries) {
                    int toAdd = max - e.length;
                    int j = 0;
                    while (j < toAdd) {
                        e.comment.insert(0, " ");
                        ++j;
                    }
                    doc.replace(e.offset + e.length + addedLength, 0, e.comment.toString());
                    addedLength += e.comment.length();
                }
            }
        }
    }
}

