/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IProjectChange;
import org.eclipse.dltk.core.builder.IRenameChange;
import org.eclipse.dltk.internal.core.builder.AbstractBuildChange;
import org.eclipse.dltk.internal.core.builder.ExternalModuleCollector;
import org.eclipse.dltk.internal.core.builder.Messages;

public class FullBuildChange
extends AbstractBuildChange
implements IBuildChange,
IResourceVisitor {
    private List<ISourceModule> projectModules = null;
    private List<IFile> realResources = null;
    private List<IFile> projectResources = null;
    private List<IPath> externalPaths = null;
    private Collection<IProjectFragment> externalFragments = null;
    private List<ISourceModule> externalModules = null;

    public FullBuildChange(IProject project, IProgressMonitor monitor) {
        super(project, monitor);
    }

    @Override
    public IResourceDelta getResourceDelta() {
        return null;
    }

    @Override
    public List<IPath> getDeletes(int options) {
        FullBuildChange.validateFlags(options, 8);
        return Collections.emptyList();
    }

    @Override
    public List<IRenameChange> getRenames() {
        return Collections.emptyList();
    }

    @Override
    public List<IFile> getResources(int options) throws CoreException {
        FullBuildChange.validateFlags(options, 15);
        if (FullBuildChange.checkFlag(options, 4)) {
            this.loadProjectResources();
            return Collections.unmodifiableList(this.projectResources);
        }
        this.loadSourceModules();
        return Collections.unmodifiableList(this.realResources);
    }

    private void loadProjectResources() throws CoreException {
        if (this.projectResources == null) {
            this.projectResources = new ArrayList<IFile>();
            this.project.accept((IResourceVisitor)this);
        }
    }

    @Override
    public List<ISourceModule> getSourceModules(int options) throws CoreException {
        FullBuildChange.validateFlags(options, 3);
        this.loadSourceModules();
        return Collections.unmodifiableList(this.projectModules);
    }

    private void loadSourceModules() throws CoreException {
        if (this.projectModules == null) {
            this.loadProjectResources();
            this.projectModules = new ArrayList<ISourceModule>();
            this.realResources = new ArrayList<IFile>();
            this.locateSourceModules(this.projectResources, this.projectModules, this.realResources);
        }
    }

    @Override
    public int getBuildType() {
        return 1;
    }

    @Override
    public void setBuildType(int buildType) {
        if (buildType != 1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isDependencyBuild() {
        return false;
    }

    @Override
    public IProjectChange[] getRequiredProjectChanges() {
        return NO_PROJECT_CHANGES;
    }

    public boolean visit(IResource resource) throws CoreException {
        this.checkCanceled();
        if (resource.getType() == 2) {
            this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningProjectFolder) + resource.getProjectRelativePath().toString());
        }
        if (resource.getType() == 1) {
            this.projectResources.add((IFile)resource);
            return false;
        }
        return true;
    }

    @Override
    public boolean addChangedResource(IFile file) {
        return false;
    }

    @Override
    public boolean addChangedResources(Collection<IFile> files) throws CoreException {
        return false;
    }

    private void loadExternalPaths() throws CoreException {
        if (this.externalPaths == null) {
            this.externalPaths = new ArrayList<IPath>();
            this.externalFragments = new ArrayList<IProjectFragment>();
            IProjectFragment[] allFragments = this.getScriptProject().getAllProjectFragments();
            int i = 0;
            while (i < allFragments.length) {
                IProjectFragment fragment = allFragments[i];
                if (fragment.isExternal()) {
                    IPath path = fragment.getPath();
                    this.externalPaths.add(path);
                    this.externalFragments.add(fragment);
                }
                ++i;
            }
        }
    }

    @Override
    public List<IPath> getExternalPaths(int options) throws CoreException {
        FullBuildChange.validateFlags(options, 16);
        if (options == 16) {
            return Collections.emptyList();
        }
        this.loadExternalPaths();
        return Collections.unmodifiableList(this.externalPaths);
    }

    @Override
    public List<ISourceModule> getExternalModules(int options) throws CoreException {
        FullBuildChange.validateFlags(options, 0);
        if (this.externalModules == null) {
            this.loadExternalPaths();
            ExternalModuleCollector moduleCollector = new ExternalModuleCollector(this.monitor);
            for (IProjectFragment fragment : this.externalFragments) {
                fragment.accept(moduleCollector);
            }
            this.externalModules = FullBuildChange.unmodifiableList(moduleCollector.elements);
        }
        return this.externalModules;
    }
}

