/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.req;

import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.DiffCrossReferencer;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class DefaultReqEngine
implements IReqEngine {
    private static final long CACHE_EXPIRATION_TIME = 30L;
    private static final int CACHE_INITIAL_CAPACITY = 200;
    private final Cache<CacheKey, Set<Diff>> cachedDifferences = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).initialCapacity(200).build();

    @Override
    public void computeRequirements(Comparison comparison, Monitor monitor) {
        monitor.subTask(EMFCompareMessages.getString("DefaultReqEngine.monitor.req"));
        for (Diff difference : comparison.getDifferences()) {
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            this.checkForRequiredDifferences(comparison, difference);
        }
    }

    protected void checkForRequiredDifferences(Comparison comparison, Diff difference) {
        Match match = difference.getMatch();
        EObject value = DefaultReqEngine.getValue(comparison, difference);
        DifferenceKind kind = difference.getKind();
        if (value != null) {
            boolean isDeletion;
            boolean isAddition = ComparisonUtil.isAddOrSetDiff(difference);
            boolean bl = isDeletion = !isAddition && ComparisonUtil.isDeleteOrUnsetDiff(difference);
            if (isAddition && this.isDeleteOrAddResourceAttachmentChange(comparison, difference)) {
                difference.getRequires().addAll(this.getDiffsThatShouldDependOn((ResourceAttachmentChange)difference));
            } else if (isAddition && DefaultReqEngine.isReferenceContainment(difference)) {
                difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, value.eContainer(), difference.getSource(), DifferenceKind.ADD));
                difference.getRequires().addAll(this.getDELOriginValueOnContainmentRefSingle(comparison, difference));
            } else if (isAddition && !ComparisonUtil.isFeatureMapContainment(difference)) {
                difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, value, difference.getSource(), DifferenceKind.ADD));
                EObject container = MatchUtil.getContainer(comparison, difference);
                if (container != null) {
                    difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, container, difference.getSource(), DifferenceKind.ADD));
                }
                match.getDifferences().stream().filter(diff2 -> diff2 instanceof ResourceAttachmentChange && diff2.getKind() == DifferenceKind.ADD && diff2.getSource() == difference.getSource()).forEach(arg_0 -> difference.getRequires().add(arg_0));
            } else if (isDeletion && this.isDeleteOrAddResourceAttachmentChange(comparison, difference)) {
                difference.getRequiredBy().addAll(this.getDiffsThatShouldDependOn((ResourceAttachmentChange)difference));
            } else if (isDeletion && DefaultReqEngine.isReferenceContainment(difference)) {
                difference.getRequires().addAll(this.getDELOutgoingReferences(comparison, difference));
                difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, (List<EObject>)value.eContents(), difference.getSource(), DifferenceKind.DELETE));
                difference.getRequires().addAll(this.getMOVEContainedObjects(comparison, difference));
            } else if (isDeletion && !ComparisonUtil.isFeatureMapContainment(difference)) {
                difference.getRequiredBy().addAll(this.getDifferenceOnGivenObject(comparison, value, difference.getSource(), DifferenceKind.DELETE));
            } else if (kind == DifferenceKind.MOVE && DefaultReqEngine.isReferenceContainment(difference)) {
                EObject container = value.eContainer();
                difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, container, difference.getSource(), DifferenceKind.ADD));
                difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, container, difference.getSource(), DifferenceKind.MOVE));
            } else if (!(kind != DifferenceKind.CHANGE || isAddition || isDeletion || difference instanceof FeatureMapChange)) {
                EObject originValue = MatchUtil.getOriginValue(comparison, (ReferenceChange)difference);
                difference.getRequiredBy().addAll(this.getDifferenceOnGivenObject(comparison, originValue, difference.getSource(), DifferenceKind.DELETE));
                difference.getRequires().addAll(this.getDifferenceOnGivenObject(comparison, value, difference.getSource(), DifferenceKind.ADD));
            }
        }
    }

    private boolean isDeleteOrAddResourceAttachmentChange(Comparison comparison, Diff diff) {
        EObject container;
        if (diff instanceof ResourceAttachmentChange && (diff.getKind() == DifferenceKind.ADD || diff.getKind() == DifferenceKind.DELETE) && (container = MatchUtil.getContainer(comparison, diff)) != null) {
            EList<Diff> differences = comparison.getDifferences(container);
            for (Diff containedDiff : differences) {
                if (!(containedDiff instanceof ReferenceChange) || !((ReferenceChange)containedDiff).getReference().isContainment() || containedDiff.getKind() != diff.getKind()) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Diff> getDiffsThatShouldDependOn(ResourceAttachmentChange diff) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        Comparison comparison = diff.getMatch().getComparison();
        EObject container = MatchUtil.getContainer(comparison, diff);
        for (ReferenceChange rc : Iterables.filter(comparison.getDifferences(container), ReferenceChange.class)) {
            if (diff.getSource() != rc.getSource() || diff.getKind() != rc.getKind()) continue;
            result.add(rc);
        }
        return result;
    }

    private Set<Diff> getDELOriginValueOnContainmentRefSingle(Comparison comparison, Diff sourceDifference) {
        Object originValue;
        EObject originContainer;
        Set<Diff> result = new LinkedHashSet<Diff>();
        if (!(sourceDifference instanceof ReferenceChange)) {
            return result;
        }
        EReference reference = ((ReferenceChange)sourceDifference).getReference();
        if (!reference.isMany() && (originContainer = MatchUtil.getOriginContainer(comparison, sourceDifference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference)) instanceof EObject) {
            result = this.getDifferenceOnGivenObject(comparison, (EObject)originValue, sourceDifference.getSource(), DifferenceKind.DELETE);
        }
        return result;
    }

    private Set<Diff> getDifferenceOnGivenObject(Comparison comparison, EObject object, DifferenceSource source, DifferenceKind kind) {
        return this.getDifferences(comparison, object, source, kind);
    }

    private Predicate<Diff> isRequiredContainmentChange(final EObject eObject, final DifferenceSource source, final DifferenceKind kind) {
        return new Predicate<Diff>(){

            @Override
            public boolean test(Diff diff) {
                boolean result = false;
                if (diff.getKind() == kind && diff.getSource() == source) {
                    if (diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment()) {
                        result = true;
                    } else if (diff instanceof ResourceAttachmentChange && eObject.eContainer() == null) {
                        result = true;
                    }
                }
                return result;
            }
        };
    }

    private Set<Diff> getDifferenceOnGivenObject(Comparison comparison, List<EObject> objects, DifferenceSource source, DifferenceKind kind) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        for (EObject object : objects) {
            result.addAll(this.getDifferenceOnGivenObject(comparison, object, source, kind));
        }
        return result;
    }

    private Set<Diff> getDELOutgoingReferences(Comparison comparison, Diff sourceDifference) {
        Match valueMatch;
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        EObject value = DefaultReqEngine.getValue(comparison, sourceDifference);
        if (value != null && (valueMatch = comparison.getMatch(value)) != null) {
            for (Diff candidate : Iterables.filter(valueMatch.getDifferences(), (com.google.common.base.Predicate)Predicates.or((com.google.common.base.Predicate)Predicates.instanceOf(ReferenceChange.class), (com.google.common.base.Predicate)Predicates.instanceOf(FeatureMapChange.class)))) {
                if (candidate.getSource() != sourceDifference.getSource() || candidate.getKind() != DifferenceKind.DELETE && !ComparisonUtil.isDeleteOrUnsetDiff(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private Set<ReferenceChange> getMOVEContainedObjects(Comparison comparison, Diff sourceDifference) {
        LinkedHashSet<ReferenceChange> result = new LinkedHashSet<ReferenceChange>();
        EObject value = DefaultReqEngine.getValue(comparison, sourceDifference);
        if (value != null) {
            EList contents = value.eContents();
            for (EObject content : contents) {
                EObject originObject = MatchUtil.getOriginObject(comparison, content);
                if (originObject == null) continue;
                for (ReferenceChange difference : Iterables.filter(comparison.getDifferences(originObject), ReferenceChange.class)) {
                    if (!difference.getReference().isContainment() || difference.getSource() != sourceDifference.getSource() || difference.getKind() != DifferenceKind.MOVE) continue;
                    result.add(difference);
                }
            }
        }
        return result;
    }

    private static boolean isReferenceContainment(Diff diff) {
        return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() || diff instanceof ResourceAttachmentChange || diff instanceof FeatureMapChange;
    }

    private static EObject getValue(Comparison comparison, Diff diff) {
        Object entryValue;
        Object entry;
        EObject value = null;
        if (diff instanceof ReferenceChange) {
            value = ((ReferenceChange)diff).getValue();
        } else if (diff instanceof ResourceAttachmentChange) {
            value = MatchUtil.getContainer(comparison, diff);
        } else if (diff instanceof FeatureMapChange && (entry = ((FeatureMapChange)diff).getValue()) instanceof FeatureMap.Entry && (entryValue = ((FeatureMap.Entry)entry).getValue()) instanceof EObject) {
            value = (EObject)entryValue;
        }
        return value;
    }

    private Set<Diff> getDifferences(Comparison comparison, EObject element, DifferenceSource source, DifferenceKind kind) {
        Set<Diff> result;
        CacheKey key;
        Set cached;
        if (element == null) {
            return new LinkedHashSet<Diff>();
        }
        DiffCrossReferencer crossReferencer = this.getCrossReferencer(comparison);
        if (crossReferencer == null) {
            comparison.getDifferences(element);
        }
        if ((cached = (Set)this.cachedDifferences.getIfPresent((Object)(key = new CacheKey(element, source, kind)))) != null) {
            return cached;
        }
        crossReferencer = this.getCrossReferencer(comparison);
        Match match = comparison.getMatch(element);
        if (match != null) {
            result = this.getDifferences(crossReferencer, match, this.isRequiredContainmentChange(element, source, kind));
        } else {
            Collection settings = crossReferencer.getNonNavigableInverseReferences(element, false);
            result = new LinkedHashSet<Diff>(settings.size());
            settings.stream().map(setting -> (Diff)setting.getEObject()).filter(this.isRequiredContainmentChange(element, source, kind)).forEach(result::add);
        }
        this.cachedDifferences.put((Object)key, result);
        return result;
    }

    private DiffCrossReferencer getCrossReferencer(Comparison comparison) {
        DiffCrossReferencer crossReferencer = null;
        for (Adapter adapter : comparison.eAdapters()) {
            if (!(adapter instanceof DiffCrossReferencer)) continue;
            crossReferencer = (DiffCrossReferencer)adapter;
        }
        return crossReferencer;
    }

    private Set<Diff> getDifferences(DiffCrossReferencer crossReferencer, Match match, Predicate<Diff> predicate) {
        Collection<EStructuralFeature.Setting> leftInverseReference = this.safeGetInverseReferences(crossReferencer, match.getLeft());
        Collection<EStructuralFeature.Setting> rightInverseReference = this.safeGetInverseReferences(crossReferencer, match.getRight());
        Collection<EStructuralFeature.Setting> originInverseReference = this.safeGetInverseReferences(crossReferencer, match.getOrigin());
        int maxExpectedSize = leftInverseReference.size() + rightInverseReference.size() + originInverseReference.size();
        Stream<Diff> racs = match.getDifferences().stream().filter(diff -> diff instanceof ResourceAttachmentChange).filter(predicate);
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>(maxExpectedSize * 2);
        leftInverseReference.stream().map(setting -> (Diff)setting.getEObject()).filter(predicate).forEach(result::add);
        rightInverseReference.stream().map(setting -> (Diff)setting.getEObject()).filter(predicate).forEach(result::add);
        originInverseReference.stream().map(setting -> (Diff)setting.getEObject()).filter(predicate).forEach(result::add);
        racs.forEach(result::add);
        return result;
    }

    private Collection<EStructuralFeature.Setting> safeGetInverseReferences(DiffCrossReferencer crossReferencer, EObject object) {
        Collection<Object> crossRefs = object != null ? crossReferencer.getNonNavigableInverseReferences(object, false) : Collections.emptySet();
        return crossRefs;
    }

    private static class CacheKey {
        private final EObject element;
        private final DifferenceSource source;
        private final DifferenceKind kind;

        CacheKey(EObject element, DifferenceSource source, DifferenceKind kind) {
            this.element = element;
            this.source = source;
            this.kind = kind;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                return this.element == ((CacheKey)obj).element && this.source == ((CacheKey)obj).source && this.kind == ((CacheKey)obj).kind;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.element, this.source, this.kind});
        }
    }
}

