/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.operations.SelectOperation;
import org.eclipse.gef.mvc.fx.parts.AbstractFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.DefaultSelectionFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class MarqueeOnDragHandler
extends AbstractHandler
implements IOnDragHandler {
    private boolean invalidGesture = false;
    private Point2D startPosInRoot;
    private Point2D endPosInRoot;
    private IFeedbackPart<? extends Node> feedback;

    private static double[] bbox(Point2D start, Point2D end) {
        double tmp;
        double[] dArray = new double[]{start.getX(), start.getY(), end.getX(), end.getY()};
        double[] bbox = dArray;
        if (bbox[0] > bbox[2]) {
            tmp = bbox[0];
            bbox[0] = bbox[2];
            bbox[2] = tmp;
        }
        if (bbox[1] > bbox[3]) {
            tmp = bbox[1];
            bbox[1] = bbox[3];
            bbox[3] = tmp;
        }
        return bbox;
    }

    public static List<Node> findContainedNodes(Node root, double x0, double y0, double x1, double y1) {
        ArrayList<Node> containedNodes = new ArrayList<Node>();
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(root);
        while (!nodes.isEmpty()) {
            Node current = (Node)nodes.remove();
            Bounds bounds = current.getBoundsInLocal();
            bounds = current.localToScene(bounds);
            double bx1 = bounds.getMaxX();
            double bx0 = bounds.getMinX();
            double by1 = bounds.getMaxY();
            double by0 = bounds.getMinY();
            if (bx1 < x0 || bx0 > x1 || by1 < y0 || by0 > y1) continue;
            if (bx0 >= x0 && bx1 <= x1 && by0 >= y0 && by1 <= y1) {
                containedNodes.add(current);
            }
            if (!(current instanceof Parent)) continue;
            Parent p = (Parent)current;
            nodes.addAll((Collection<Node>)p.getChildrenUnmodifiable());
        }
        return containedNodes;
    }

    @Override
    public void abortDrag() {
        if (!this.invalidGesture && this.feedback != null) {
            this.removeFeedback();
        }
    }

    protected void addFeedback() {
        if (this.feedback != null) {
            this.removeFeedback();
        }
        this.feedback = new AbstractFeedbackPart<Rectangle>(){

            @Override
            protected void doActivate() {
                super.doActivate();
                this.setRefreshVisual(true);
            }

            @Override
            protected Rectangle doCreateVisual() {
                Rectangle visual = new Rectangle();
                visual.setFill((Paint)Color.TRANSPARENT);
                visual.setStroke((Paint)MarqueeOnDragHandler.this.getPrimarySelectionColor());
                visual.setStrokeWidth(1.0);
                visual.setStrokeType(StrokeType.CENTERED);
                visual.getStrokeDashArray().setAll((Object[])new Double[]{5.0, 5.0});
                return visual;
            }

            @Override
            protected void doRefreshVisual(Rectangle visual) {
                IRootPart<Node> root = this.getRoot();
                Point2D start = visual.sceneToLocal(root.getVisual().localToScene(MarqueeOnDragHandler.this.startPosInRoot));
                Point2D end = visual.sceneToLocal(root.getVisual().localToScene(MarqueeOnDragHandler.this.endPosInRoot));
                double[] bbox = MarqueeOnDragHandler.bbox(start, end);
                visual.setX(bbox[0] - 0.5);
                visual.setY(bbox[1] - 0.5);
                visual.setWidth(bbox[2] - bbox[0]);
                visual.setHeight(bbox[3] - bbox[1]);
            }
        };
        this.getHost().getRoot().addChildren(Collections.singletonList(this.feedback));
        this.feedback.refreshVisual();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        this.endPosInRoot = this.getHost().getRoot().getVisual().sceneToLocal(e.getSceneX(), e.getSceneY());
        this.updateFeedback();
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        IRootPart<Node> root = this.getHost().getRoot();
        Object rootVisual = root.getVisual();
        this.endPosInRoot = rootVisual.sceneToLocal(e.getSceneX(), e.getSceneY());
        Point2D start = rootVisual.localToScene(this.startPosInRoot);
        Point2D end = rootVisual.localToScene(this.endPosInRoot);
        double[] bbox = MarqueeOnDragHandler.bbox(start, end);
        List<Node> nodes = MarqueeOnDragHandler.findContainedNodes((Node)rootVisual.getScene().getRoot(), bbox[0], bbox[1], bbox[2], bbox[3]);
        List<IContentPart<? extends Node>> parts = this.getParts(nodes);
        Iterator<IContentPart<? extends Node>> it = parts.iterator();
        while (it.hasNext()) {
            if (it.next().isSelectable()) continue;
            it.remove();
        }
        try {
            root.getViewer().getDomain().execute(new SelectOperation(root.getViewer(), parts), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e1) {
            throw new IllegalStateException(e1);
        }
        this.removeFeedback();
    }

    protected List<IContentPart<? extends Node>> getParts(List<Node> nodes) {
        ArrayList<IContentPart<? extends Node>> parts = new ArrayList<IContentPart<? extends Node>>();
        IViewer viewer = this.getHost().getRoot().getViewer();
        for (Node node : nodes) {
            IVisualPart<? extends Node> part = PartUtils.retrieveVisualPart(viewer, node);
            if (part == null || !(part instanceof IContentPart) || parts.contains(part)) continue;
            parts.add((IContentPart)part);
        }
        return parts;
    }

    protected Color getPrimarySelectionColor() {
        Provider connectedColorProvider = (Provider)this.getHost().getRoot().getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? DefaultSelectionFeedbackPartFactory.DEFAULT_PRIMARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    @Override
    public void hideIndicationCursor() {
    }

    protected boolean isMarquee(MouseEvent event) {
        return !this.isRegistered(event.getTarget());
    }

    protected void removeFeedback() {
        if (this.feedback != null) {
            this.getHost().getRoot().removeChild(this.feedback);
            this.feedback = null;
        }
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        boolean bl = this.invalidGesture = !this.isMarquee(e);
        if (this.invalidGesture) {
            return;
        }
        this.startPosInRoot = this.getHost().getRoot().getVisual().sceneToLocal(e.getSceneX(), e.getSceneY());
        this.endPosInRoot = new Point2D(this.startPosInRoot.getX(), this.startPosInRoot.getY());
        this.addFeedback();
    }

    protected void updateFeedback() {
        if (this.feedback != null) {
            this.feedback.refreshVisual();
        }
    }
}

