/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;

public class ResizeContentOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    private final IResizableContentPart<? extends Node> resizableContentPart;
    private Dimension initialSize;
    private Dimension finalSize;

    public ResizeContentOperation(IResizableContentPart<? extends Node> resizableContentPart, Dimension initialSize, Dimension finalSize) {
        super("Resize Content");
        this.resizableContentPart = resizableContentPart;
        this.initialSize = initialSize;
        this.finalSize = finalSize;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.resizableContentPart.getContentSize().equals((Object)this.finalSize)) {
            this.resizableContentPart.setContentSize(this.finalSize);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialSize.equals((Object)this.finalSize);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.resizableContentPart.getContentSize().equals((Object)this.initialSize)) {
            this.resizableContentPart.setContentSize(this.initialSize);
        }
        return Status.OK_STATUS;
    }
}

