/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsPreset;

public class ShowRelatedElementsPresetHelper {
    public static final String KEY_SEPARATOR = ":";
    public static final String VALUE_SEPARATOR = ",";

    private ShowRelatedElementsPresetHelper() {
    }

    public static ShowRelatedElementsPreset findPresetFromList(List list, String name) {
        for (Object obj : list) {
            assert (obj instanceof ShowRelatedElementsPreset);
            ShowRelatedElementsPreset preset = (ShowRelatedElementsPreset)obj;
            if (!preset.getName().equals(name)) continue;
            return preset;
        }
        return null;
    }

    public static List readPresets(String nameToIgnore, String[] settings, IConversionMethods conversionMethod) {
        ArrayList<ShowRelatedElementsPreset> presets = new ArrayList<ShowRelatedElementsPreset>();
        if (settings == null) {
            return presets;
        }
        int i = 0;
        while (i < settings.length) {
            ShowRelatedElementsPreset preset = null;
            String[] split = settings[i].split(KEY_SEPARATOR);
            String name = split[0];
            if (nameToIgnore == null || !name.toUpperCase().equals(nameToIgnore.toUpperCase())) {
                String ids = split[1];
                ArrayList<String> readIds = new ArrayList<String>();
                String[] splitIds = ids.split(VALUE_SEPARATOR);
                int j = 0;
                while (j < splitIds.length) {
                    if (!splitIds[j].equals(" ")) {
                        readIds.add(splitIds[j]);
                    }
                    ++j;
                }
                String custom = split[2];
                String type = split[3];
                String levels = split[4];
                preset = new ShowRelatedElementsPreset(name, false, Integer.parseInt(type), Integer.parseInt(levels));
                preset.addIds(readIds);
                if (conversionMethod == null) {
                    preset.setCustom(custom);
                } else {
                    preset.setCustom(conversionMethod.convertSerializableStringToCustomData(custom));
                }
                presets.add(preset);
            }
            ++i;
        }
        return presets;
    }

    public static String[] convertPresetsToString(List presets, IConversionMethods conversionMethod) {
        String[] array = new String[presets.size()];
        int i = 0;
        for (Object obj : presets) {
            assert (obj instanceof ShowRelatedElementsPreset);
            ShowRelatedElementsPreset preset = (ShowRelatedElementsPreset)obj;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(preset.name) + KEY_SEPARATOR);
            Iterator idsIt = preset.getIds().iterator();
            while (idsIt.hasNext()) {
                obj = idsIt.next();
                assert (obj instanceof String);
                stringBuilder.append((String)obj);
                if (!idsIt.hasNext()) continue;
                stringBuilder.append(VALUE_SEPARATOR);
            }
            stringBuilder.append(KEY_SEPARATOR);
            stringBuilder.append(conversionMethod != null ? conversionMethod.convertCustomDataToSerializableString(preset.getCustom()) : "");
            stringBuilder.append(KEY_SEPARATOR + preset.getExpansionType() + KEY_SEPARATOR + preset.getLevels());
            array[i] = stringBuilder.toString();
            ++i;
        }
        return array;
    }

    public static interface IConversionMethods {
        public Object convertSerializableStringToCustomData(String var1);

        public String convertCustomDataToSerializableString(Object var1);
    }
}

