/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.io;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.CharacterTools;
import org.eclipse.jpt.common.utility.internal.StringTools;

public final class WriterTools {
    public static void reverse(Writer writer, String string) throws IOException {
        int i = string.length();
        while (i-- > 0) {
            writer.write(string.charAt(i));
        }
    }

    public static void reverse(Writer writer, char[] string) throws IOException {
        int i = string.length;
        while (i-- > 0) {
            writer.write(string[i]);
        }
    }

    public static void center(Writer writer, String string, int length) throws IOException {
        WriterTools.center(writer, string, length, ' ');
    }

    public static void center(Writer writer, char[] string, int length) throws IOException {
        WriterTools.center(writer, string, length, ' ');
    }

    public static void center(Writer writer, String string, int length, char c) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            writer.write(string, begin, length);
        } else {
            int begin = length - stringLength >> 1;
            WriterTools.fill(writer, begin, c);
            writer.append(string);
            WriterTools.fill(writer, length - (begin + stringLength), c);
        }
    }

    public static void center(Writer writer, char[] string, int length, char c) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            writer.write(string, begin, length);
        } else {
            int begin = length - stringLength >> 1;
            WriterTools.fill(writer, begin, c);
            writer.write(string);
            WriterTools.fill(writer, length - (begin + stringLength), c);
        }
    }

    public static void pad(Writer writer, String string, int length) throws IOException {
        WriterTools.pad(writer, string, length, ' ');
    }

    public static void pad(Writer writer, char[] string, int length) throws IOException {
        WriterTools.pad(writer, string, length, ' ');
    }

    public static void pad(Writer writer, String string, int length, char c) throws IOException {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            writer.write(string);
        } else {
            WriterTools.pad_(writer, string, length, c);
        }
    }

    public static void pad(Writer writer, char[] string, int length, char c) throws IOException {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            writer.write(string);
        } else {
            WriterTools.pad_(writer, string, stringLength, length, c);
        }
    }

    public static void fit(Writer writer, String string, int length) throws IOException {
        WriterTools.fit(writer, string, length, ' ');
    }

    public static void fit(Writer writer, char[] string, int length) throws IOException {
        WriterTools.fit(writer, string, length, ' ');
    }

    public static void fit(Writer writer, String string, int length, char c) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            writer.write(string, 0, length);
        } else {
            WriterTools.pad_(writer, string, length, c);
        }
    }

    public static void fit(Writer writer, char[] string, int length, char c) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            writer.write(string, 0, length);
        } else {
            WriterTools.pad_(writer, string, stringLength, length, c);
        }
    }

    private static void pad_(Writer writer, String string, int length, char c) throws IOException {
        writer.write(string);
        WriterTools.fill(writer, string, length, c);
    }

    private static void fill(Writer writer, String string, int length, char c) throws IOException {
        WriterTools.fill(writer, string.length(), length, c);
    }

    private static void pad_(Writer writer, char[] string, int stringLength, int length, char c) throws IOException {
        writer.write(string);
        WriterTools.fill(writer, stringLength, length, c);
    }

    private static void fill(Writer writer, int stringLength, int length, char c) throws IOException {
        WriterTools.fill(writer, length - stringLength, c);
    }

    private static void fill(Writer writer, int length, char c) throws IOException {
        writer.write(ArrayTools.fill(new char[length], c));
    }

    public static void zeroPad(Writer writer, String string, int length) throws IOException {
        WriterTools.frontPad(writer, string, length, '0');
    }

    public static void zeroPad(Writer writer, char[] string, int length) throws IOException {
        WriterTools.frontPad(writer, string, length, '0');
    }

    public static void frontPad(Writer writer, String string, int length, char c) throws IOException {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            writer.write(string);
        } else {
            WriterTools.frontPad_(writer, string, length, c);
        }
    }

    public static void frontPad(Writer writer, char[] string, int length, char c) throws IOException {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            writer.write(string);
        } else {
            WriterTools.frontPad_(writer, string, stringLength, length, c);
        }
    }

    public static void zeroFit(Writer writer, String string, int length) throws IOException {
        WriterTools.frontFit(writer, string, length, '0');
    }

    public static void zeroFit(Writer writer, char[] string, int length) throws IOException {
        WriterTools.frontFit(writer, string, length, '0');
    }

    public static void frontFit(Writer writer, String string, int length, char c) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            writer.write(string, stringLength - length, length);
        } else {
            WriterTools.frontPad_(writer, string, length, c);
        }
    }

    public static void frontFit(Writer writer, char[] string, int length, char c) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            writer.write(string, stringLength - length, length);
        } else {
            WriterTools.frontPad_(writer, string, stringLength, length, c);
        }
    }

    private static void frontPad_(Writer writer, String string, int length, char c) throws IOException {
        WriterTools.fill(writer, string, length, c);
        writer.write(string);
    }

    private static void frontPad_(Writer writer, char[] string, int stringLength, int length, char c) throws IOException {
        WriterTools.fill(writer, stringLength, length, c);
        writer.write(string);
    }

    public static void repeat(Writer writer, String string, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            writer.write(string, 0, length);
        } else {
            WriterTools.repeat(writer, string, length, stringLength);
        }
    }

    private static void repeat(Writer writer, String string, int length, int stringLength) throws IOException {
        do {
            writer.write(string);
        } while (stringLength <= (length -= stringLength));
        if (length > 0) {
            writer.write(string, 0, length);
        }
    }

    public static void repeat(Writer writer, char[] string, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            writer.write(string);
        } else if (stringLength > length) {
            writer.write(string, 0, length);
        } else {
            WriterTools.repeat(writer, string, length, stringLength);
        }
    }

    private static void repeat(Writer writer, char[] string, int length, int stringLength) throws IOException {
        do {
            writer.write(string);
        } while (stringLength <= (length -= stringLength));
        if (length > 0) {
            writer.write(string, 0, length);
        }
    }

    public static void separate(Writer writer, String string, char separator, int segmentSize) throws IOException {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length();
        if (stringLength <= segmentSize) {
            writer.write(string);
        } else {
            WriterTools.separate(writer, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(Writer writer, String string, char separator, int segmentSize, int stringLength) throws IOException {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (segCount == segmentSize) {
                writer.write(separator);
                segCount = 0;
            }
            ++segCount;
            writer.write(c);
            ++i;
        }
    }

    public static void separate(Writer writer, char[] string, char separator, int segmentSize) throws IOException {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length;
        if (stringLength <= segmentSize) {
            writer.write(string);
        } else {
            WriterTools.separate(writer, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(Writer writer, char[] string, char separator, int segmentSize, int stringLength) throws IOException {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (segCount == segmentSize) {
                writer.write(separator);
                segCount = 0;
            }
            ++segCount;
            writer.write(c);
            ++i;
        }
    }

    public static void quote(Writer writer, String string) throws IOException {
        WriterTools.delimit(writer, string, '\"');
    }

    public static void quote(Writer writer, char[] string) throws IOException {
        WriterTools.delimit(writer, string, '\"');
    }

    public static void delimit(Writer writer, String string, char delimiter) throws IOException {
        writer.write(delimiter);
        int stringLength = string.length();
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (c == delimiter) {
                writer.write(c);
            }
            writer.write(c);
            ++i;
        }
        writer.write(delimiter);
    }

    public static void delimit(Writer writer, char[] string, char delimiter) throws IOException {
        writer.write(delimiter);
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == delimiter) {
                writer.write(c);
            }
            writer.write(c);
            ++n2;
        }
        writer.write(delimiter);
    }

    public static void delimit(Writer writer, String string, String delimiter) throws IOException {
        int delimiterLength = delimiter.length();
        switch (delimiterLength) {
            case 0: {
                writer.write(string);
                break;
            }
            case 1: {
                WriterTools.delimit(writer, string, delimiter.charAt(0));
                break;
            }
            default: {
                WriterTools.delimit(writer, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(Writer writer, String string, String delimiter, int delimiterLength) throws IOException {
        writer.write(delimiter, 0, delimiterLength);
        writer.write(string);
        writer.write(delimiter, 0, delimiterLength);
    }

    public static void delimit(Writer writer, char[] string, char[] delimiter) throws IOException {
        int delimiterLength = delimiter.length;
        switch (delimiterLength) {
            case 0: {
                writer.write(string);
                break;
            }
            case 1: {
                WriterTools.delimit(writer, string, delimiter[0]);
                break;
            }
            default: {
                WriterTools.delimit(writer, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(Writer writer, char[] string, char[] delimiter, int delimiterLength) throws IOException {
        writer.write(delimiter, 0, delimiterLength);
        writer.write(string);
        writer.write(delimiter, 0, delimiterLength);
    }

    public static void undelimit(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        WriterTools.undelimit_(writer, string, stringLength);
    }

    private static void undelimit_(Writer writer, String string, int stringLength) throws IOException {
        char delimiter;
        char c = delimiter = string.charAt(0);
        char next = string.charAt(1);
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            writer.write(c);
            next = string.charAt(++i);
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string.charAt(++i);
        } while (i != last);
    }

    public static void undelimit(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + String.valueOf(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        WriterTools.undelimit_(writer, string, stringLength);
    }

    private static void undelimit_(Writer writer, char[] string, int stringLength) throws IOException {
        char delimiter;
        char c = delimiter = string[0];
        char next = string[1];
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            writer.write(c);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimit(Writer writer, String string, int count) throws IOException {
        if (count == 0) {
            writer.write(string);
            return;
        }
        int resultLength = string.length() - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        writer.write(string, count, resultLength);
    }

    public static void undelimit(Writer writer, char[] string, int count) throws IOException {
        if (count == 0) {
            writer.write(string);
            return;
        }
        int resultLength = string.length - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + String.valueOf(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        writer.write(string, count, resultLength);
    }

    public static void removeFirstOccurrence(Writer writer, String string, char c) throws IOException {
        int index = string.indexOf(c);
        if (index == -1) {
            writer.write(string);
        } else {
            WriterTools.removeCharAtIndex(writer, string, index);
        }
    }

    private static void removeCharAtIndex(Writer writer, String string, int index) throws IOException {
        int last = string.length() - 1;
        if (index == 0) {
            writer.write(string, 1, last);
        } else {
            writer.write(string, 0, index);
            if (index != last) {
                writer.write(string, index + 1, last - index);
            }
        }
    }

    public static void removeFirstOccurrence(Writer writer, char[] string, char c) throws IOException {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            writer.write(string);
        } else {
            WriterTools.removeCharAtIndex(writer, string, index);
        }
    }

    private static void removeCharAtIndex(Writer writer, char[] string, int index) throws IOException {
        int last = string.length - 1;
        if (index == 0) {
            writer.write(string, 1, last);
        } else if (index == last) {
            writer.write(string, 0, last);
        } else {
            writer.write(string, 0, index);
            writer.write(string, index + 1, last - index);
        }
    }

    public static void removeAllOccurrences(Writer writer, String string, char c) throws IOException {
        int first = string.indexOf(c);
        if (first == -1) {
            writer.write(string);
        } else {
            WriterTools.removeAllOccurrences(writer, string, c, first);
        }
    }

    private static void removeAllOccurrences(Writer writer, String string, char c, int first) throws IOException {
        writer.write(string, 0, first);
        int stringLength = string.length();
        int i = first;
        while (i < stringLength) {
            char d = string.charAt(i);
            if (d != c) {
                writer.write(d);
            }
            ++i;
        }
    }

    public static void removeAllOccurrences(Writer writer, char[] string, char c) throws IOException {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            writer.write(string);
        } else {
            WriterTools.removeAllOccurrences(writer, string, c, first);
        }
    }

    private static void removeAllOccurrences(Writer writer, char[] string, char c, int first) throws IOException {
        writer.write(string, 0, first);
        int stringLength = string.length;
        int i = first;
        while (i < stringLength) {
            char d = string[i];
            if (d != c) {
                writer.write(d);
            }
            ++i;
        }
    }

    public static void removeAllSpaces(Writer writer, String string) throws IOException {
        WriterTools.removeAllOccurrences(writer, string, ' ');
    }

    public static void removeAllSpaces(Writer writer, char[] string) throws IOException {
        WriterTools.removeAllOccurrences(writer, string, ' ');
    }

    public static void removeAllWhitespace(Writer writer, String string) throws IOException {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            writer.write(string);
        } else {
            WriterTools.removeAllWhitespace(writer, string, first);
        }
    }

    private static void removeAllWhitespace(Writer writer, String string, int first) throws IOException {
        writer.write(string, 0, first);
        int stringLength = string.length();
        int i = first;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                writer.write(c);
            }
            ++i;
        }
    }

    public static void removeAllWhitespace(Writer writer, char[] string) throws IOException {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            writer.write(string);
        } else {
            WriterTools.removeAllWhitespace(writer, string, first);
        }
    }

    private static void removeAllWhitespace(Writer writer, char[] string, int first) throws IOException {
        writer.write(string, 0, first);
        int stringLength = string.length;
        int i = first;
        while (i < stringLength) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                writer.write(c);
            }
            ++i;
        }
    }

    public static void compressWhitespace(Writer writer, String string) throws IOException {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            writer.write(string);
        } else {
            WriterTools.compressWhitespace(writer, string, first);
        }
    }

    private static void compressWhitespace(Writer writer, String string, int first) throws IOException {
        writer.write(string, 0, first);
        int stringLength = string.length();
        int i = first;
        char c = string.charAt(i);
        block0: while (true) {
            writer.write(32);
            while (++i < stringLength) {
                c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                do {
                    writer.write(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string.charAt(i)));
                continue block0;
            }
            break;
        }
    }

    public static void compressWhitespace(Writer writer, char[] string) throws IOException {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            writer.write(string);
        } else {
            WriterTools.compressWhitespace(writer, string, first);
        }
    }

    private static void compressWhitespace(Writer writer, char[] string, int first) throws IOException {
        writer.write(string, 0, first);
        int stringLength = string.length;
        int i = first;
        char c = string[i];
        block0: while (true) {
            writer.write(32);
            while (++i < stringLength) {
                c = string[i];
                if (Character.isWhitespace(c)) continue;
                do {
                    writer.write(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string[i]));
                continue block0;
            }
            break;
        }
    }

    public static void capitalize(Writer writer, String string) throws IOException {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            writer.write(string);
        } else {
            WriterTools.capitalize_(writer, string);
        }
    }

    private static void capitalize_(Writer writer, String string) throws IOException {
        writer.write(Character.toUpperCase(string.charAt(0)));
        writer.write(string, 1, string.length() - 1);
    }

    public static void capitalize(Writer writer, char[] string) throws IOException {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            writer.write(string);
        } else {
            WriterTools.capitalize_(writer, string);
        }
    }

    private static void capitalize_(Writer writer, char[] string) throws IOException {
        writer.write(Character.toUpperCase(string[0]));
        writer.write(string, 1, string.length - 1);
    }

    public static void uncapitalize(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (StringTools.needNotBeUncapitalized(string, stringLength)) {
            writer.write(string);
        } else {
            WriterTools.uncapitalize(writer, string, stringLength);
        }
    }

    private static void uncapitalize(Writer writer, String string, int stringLength) throws IOException {
        writer.write(Character.toLowerCase(string.charAt(0)));
        writer.write(string, 1, stringLength - 1);
    }

    public static void uncapitalize(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (CharArrayTools.needNotBeUncapitalized(string, stringLength)) {
            writer.write(string);
        } else {
            WriterTools.uncapitalize(writer, string, stringLength);
        }
    }

    private static void uncapitalize(Writer writer, char[] string, int stringLength) throws IOException {
        writer.write(Character.toLowerCase(string[0]));
        writer.write(string, 1, stringLength - 1);
    }

    public static void convertToHexString(Writer writer, byte[] bytes) throws IOException {
        int bytesLength = bytes.length;
        if (bytesLength != 0) {
            WriterTools.convertToHexString(writer, bytes, bytesLength);
        }
    }

    private static void convertToHexString(Writer writer, byte[] bytes, int bytesLength) throws IOException {
        char[] digits = CharacterTools.DIGITS;
        int i = 0;
        while (i < bytesLength) {
            int b = bytes[i] & 0xFF;
            writer.write(digits[b >> 4]);
            writer.write(digits[b & 0xF]);
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(Writer writer, String camelCaseString) throws IOException {
        int stringLength = camelCaseString.length();
        if (stringLength != 0) {
            WriterTools.convertCamelCaseToAllCaps_(writer, camelCaseString, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps_(Writer writer, String camelCaseString, int stringLength) throws IOException {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                writer.write(95);
            }
            writer.write(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(Writer writer, char[] camelCaseString) throws IOException {
        int stringLength = camelCaseString.length;
        if (stringLength != 0) {
            WriterTools.convertCamelCaseToAllCaps_(writer, camelCaseString, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps_(Writer writer, char[] camelCaseString, int stringLength) throws IOException {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                writer.write(95);
            }
            writer.write(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(Writer writer, String camelCaseString, int maxLength) throws IOException {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length()) != 0) {
            WriterTools.convertCamelCaseToAllCaps(writer, camelCaseString, maxLength, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps(Writer writer, String camelCaseString, int maxLength, int stringLength) throws IOException {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int writerLength = 0;
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                writer.write(95);
                if (++writerLength == maxLength) {
                    return;
                }
            }
            writer.write(Character.toUpperCase(c));
            if (++writerLength == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(Writer writer, char[] camelCaseString, int maxLength) throws IOException {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length) != 0) {
            WriterTools.convertCamelCaseToAllCaps(writer, camelCaseString, maxLength, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps(Writer writer, char[] camelCaseString, int maxLength, int stringLength) throws IOException {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int writerLength = 0;
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                writer.write(95);
                if (++writerLength == maxLength) {
                    return;
                }
            }
            writer.write(Character.toUpperCase(c));
            if (++writerLength == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(Writer writer, String allCapsString) throws IOException {
        WriterTools.convertAllCapsToCamelCase(writer, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(Writer writer, char[] allCapsString) throws IOException {
        WriterTools.convertAllCapsToCamelCase(writer, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(Writer writer, String allCapsString, boolean capitalizeFirstLetter) throws IOException {
        int stringLength = allCapsString.length();
        if (stringLength != 0) {
            WriterTools.convertAllCapsToCamelCase(writer, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    private static void convertAllCapsToCamelCase(Writer writer, String allCapsString, boolean capitalizeFirstLetter, int stringLength) throws IOException {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString.charAt(i);
            if (c != '_') {
                if (first) {
                    first = false;
                    writer.write(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    writer.write(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(Writer writer, char[] allCapsString, boolean capitalizeFirstLetter) throws IOException {
        int stringLength = allCapsString.length;
        if (stringLength != 0) {
            WriterTools.convertAllCapsToCamelCase(writer, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    private static void convertAllCapsToCamelCase(Writer writer, char[] allCapsString, boolean capitalizeFirstLetter, int stringLength) throws IOException {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    writer.write(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    writer.write(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength == 0) {
            writer.write("\"\"");
        } else {
            WriterTools.convertToJavaStringLiteral(writer, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteral(Writer writer, String string, int stringLength) throws IOException {
        writer.write(34);
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToJavaStringLiteral(writer, string.charAt(i));
            ++i;
        }
        writer.write(34);
    }

    public static void convertToJavaStringLiteralContent(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength != 0) {
            WriterTools.convertToJavaStringLiteralContent(writer, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteralContent(Writer writer, String string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToJavaStringLiteral(writer, string.charAt(i));
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength == 0) {
            writer.write("\"\"");
        } else {
            WriterTools.convertToJavaStringLiteral(writer, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteral(Writer writer, char[] string, int stringLength) throws IOException {
        writer.write(34);
        WriterTools.convertToJavaStringLiteralContent(writer, string, stringLength);
        writer.write(34);
    }

    public static void convertToJavaStringLiteralContent(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength != 0) {
            WriterTools.convertToJavaStringLiteralContent(writer, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteralContent(Writer writer, char[] string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToJavaStringLiteral(writer, string[i]);
            ++i;
        }
    }

    private static void convertToJavaStringLiteral(Writer writer, char c) throws IOException {
        switch (c) {
            case '\b': {
                writer.write("\\b");
                break;
            }
            case '\t': {
                writer.write("\\t");
                break;
            }
            case '\n': {
                writer.write("\\n");
                break;
            }
            case '\f': {
                writer.write("\\f");
                break;
            }
            case '\r': {
                writer.write("\\r");
                break;
            }
            case '\"': {
                writer.write("\\\"");
                break;
            }
            case '\\': {
                writer.write("\\\\");
                break;
            }
            default: {
                writer.write(c);
            }
        }
    }

    public static void convertToXmlAttributeValue(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength == 0) {
            writer.write("\"\"");
        } else {
            WriterTools.convertToXmlAttributeValue(writer, string, stringLength);
        }
    }

    private static void convertToXmlAttributeValue(Writer writer, String string, int stringLength) throws IOException {
        int index = string.indexOf(34);
        if (index == -1) {
            WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string, stringLength);
        } else {
            index = string.indexOf(39);
            if (index == -1) {
                WriterTools.convertToSingleQuotedXmlAttributeValue(writer, string, stringLength);
            } else {
                WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string, stringLength);
            }
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValue(Writer writer, String string, int stringLength) throws IOException {
        writer.write(34);
        WriterTools.convertToDoubleQuotedXmlAttributeValueContent(writer, string, stringLength);
        writer.write(34);
    }

    private static void convertToSingleQuotedXmlAttributeValue(Writer writer, String string, int stringLength) throws IOException {
        writer.write(39);
        WriterTools.convertToSingleQuotedXmlAttributeValueContent(writer, string, stringLength);
        writer.write(39);
    }

    public static void convertToDoubleQuotedXmlAttributeValue(Writer writer, String string) throws IOException {
        WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string, string.length());
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength != 0) {
            WriterTools.convertToDoubleQuotedXmlAttributeValueContent(writer, string, stringLength);
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(Writer writer, String string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string.charAt(i));
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(Writer writer, String string) throws IOException {
        WriterTools.convertToSingleQuotedXmlAttributeValue(writer, string, string.length());
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength != 0) {
            WriterTools.convertToSingleQuotedXmlAttributeValueContent(writer, string, stringLength);
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(Writer writer, String string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToSingleQuotedXmlAttributeValueContent(writer, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlAttributeValue(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength == 0) {
            writer.write("\"\"");
        } else {
            WriterTools.convertToXmlAttributeValue(writer, string, stringLength);
        }
    }

    private static void convertToXmlAttributeValue(Writer writer, char[] string, int stringLength) throws IOException {
        int index = ArrayTools.indexOf(string, '\"');
        if (index == -1) {
            WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string, stringLength);
        } else {
            index = ArrayTools.indexOf(string, '\'');
            if (index == -1) {
                WriterTools.convertToSingleQuotedXmlAttributeValue(writer, string, stringLength);
            } else {
                WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string, stringLength);
            }
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValue(Writer writer, char[] string, int stringLength) throws IOException {
        writer.write(34);
        WriterTools.convertToDoubleQuotedXmlAttributeValueContent(writer, string, stringLength);
        writer.write(34);
    }

    private static void convertToSingleQuotedXmlAttributeValue(Writer writer, char[] string, int stringLength) throws IOException {
        writer.write(39);
        WriterTools.convertToSingleQuotedXmlAttributeValueContent(writer, string, stringLength);
        writer.write(39);
    }

    public static void convertToDoubleQuotedXmlAttributeValue(Writer writer, char[] string) throws IOException {
        WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string, string.length);
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength != 0) {
            WriterTools.convertToDoubleQuotedXmlAttributeValueContent(writer, string, stringLength);
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(Writer writer, char[] string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToDoubleQuotedXmlAttributeValue(writer, string[i]);
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(Writer writer, char[] string) throws IOException {
        WriterTools.convertToSingleQuotedXmlAttributeValue(writer, string, string.length);
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength != 0) {
            WriterTools.convertToSingleQuotedXmlAttributeValueContent(writer, string, stringLength);
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(Writer writer, char[] string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToSingleQuotedXmlAttributeValueContent(writer, string[i]);
            ++i;
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValue(Writer writer, char c) throws IOException {
        switch (c) {
            case '\"': {
                writer.write("&quot;");
                break;
            }
            case '&': {
                writer.write("&amp;");
                break;
            }
            case '<': {
                writer.write("&lt;");
                break;
            }
            default: {
                writer.write(c);
            }
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(Writer writer, char c) throws IOException {
        switch (c) {
            case '\'': {
                writer.write("&apos;");
                break;
            }
            case '&': {
                writer.write("&amp;");
                break;
            }
            case '<': {
                writer.write("&lt;");
                break;
            }
            default: {
                writer.write(c);
            }
        }
    }

    public static void convertToXmlElementText(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength != 0) {
            WriterTools.convertToXmlElementText(writer, string, stringLength);
        }
    }

    private static void convertToXmlElementText(Writer writer, String string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToXmlElementText(writer, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlElementText(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength != 0) {
            WriterTools.convertToXmlElementText(writer, string, stringLength);
        }
    }

    private static void convertToXmlElementText(Writer writer, char[] string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            WriterTools.convertToXmlElementText(writer, string[i]);
            ++i;
        }
    }

    private static void convertToXmlElementText(Writer writer, char c) throws IOException {
        switch (c) {
            case '&': {
                writer.write("&amp;");
                break;
            }
            case '<': {
                writer.write("&lt;");
                break;
            }
            default: {
                writer.write(c);
            }
        }
    }

    public static void convertToXmlElementCDATA(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength == 0) {
            writer.write("<![CDATA[]]>");
        } else {
            WriterTools.convertToXmlElementCDATA(writer, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATA(Writer writer, String string, int stringLength) throws IOException {
        writer.write("<![CDATA[");
        WriterTools.convertToXmlElementCDATAContent(writer, string, stringLength);
        writer.write("]]>");
    }

    public static void convertToXmlElementCDATAContent(Writer writer, String string) throws IOException {
        int stringLength = string.length();
        if (stringLength != 0) {
            WriterTools.convertToXmlElementCDATAContent(writer, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATAContent(Writer writer, String string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            writer.write(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string.charAt(i);
                writer.write(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string.charAt(i);
                    if (c == '>') {
                        writer.write("&gt;");
                    } else {
                        writer.write(c);
                    }
                }
            }
            ++i;
        }
    }

    public static void convertToXmlElementCDATA(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength == 0) {
            writer.write("<![CDATA[]]>");
        } else {
            WriterTools.convertToXmlElementCDATA(writer, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATA(Writer writer, char[] string, int stringLength) throws IOException {
        writer.write("<![CDATA[");
        WriterTools.convertToXmlElementCDATAContent(writer, string, stringLength);
        writer.write("]]>");
    }

    public static void convertToXmlElementCDATAContent(Writer writer, char[] string) throws IOException {
        int stringLength = string.length;
        if (stringLength != 0) {
            WriterTools.convertToXmlElementCDATAContent(writer, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATAContent(Writer writer, char[] string, int stringLength) throws IOException {
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            writer.write(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string[i];
                writer.write(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string[i];
                    if (c == '>') {
                        writer.write("&gt;");
                    } else {
                        writer.write(c);
                    }
                }
            }
            ++i;
        }
    }

    private WriterTools() {
        throw new UnsupportedOperationException();
    }
}

