/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.common.internal.finder.AbstractMatcher;
import org.eclipse.jst.jsf.common.internal.finder.VisitorMatcher;
import org.eclipse.jst.jsf.common.internal.finder.acceptor.FileMatchingAcceptor;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.common.internal.resource.ResourceManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceTracker;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.resources.AbstractJSFResourceLocator;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.IWorkspaceJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResourceChangeListener;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifierFactory;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResourceContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceResourceManager
extends ResourceManager<IResource> {
    private final AbstractVirtualComponentQuery _vcQuery;
    private final IProject _project;
    private final AbstractJSFResourceLocator _locator;
    private final ContentTypeResolver _contentTypeResolver;
    private final ResourceIdentifierFactory _factory;

    public WorkspaceResourceManager(IProject project, AbstractVirtualComponentQuery vcQuery, AbstractJSFResourceLocator locator, ContentTypeResolver contentTypeResolver) {
        super(project.getWorkspace());
        this._project = project;
        this._vcQuery = vcQuery;
        this._locator = locator;
        this._contentTypeResolver = contentTypeResolver;
        this._factory = new ResourceIdentifierFactory();
    }

    protected JSFResourceTracker createNewInstance(IResource resource) {
        boolean isJSFResource = !this.getRootResourceFolder().getParent().equals((Object)resource);
        return new JSFResourceTracker(resource, isJSFResource);
    }

    public void initResources() {
        IFolder folder = this.getRootResourceFolder();
        if (folder != null) {
            try {
                this.track((IResource)folder.getParent());
                this.track((IResource)folder);
            }
            catch (Exception e1) {
                JSFCorePlugin.log(e1, "While trying to locate JSF resources in the workspace");
            }
            if (folder.isAccessible()) {
                this.trackAllInFolder((IContainer)folder);
            }
        }
    }

    private List<IWorkspaceJSFResourceFragment> trackAllInFolder(IContainer folder) {
        VisitorMatcher matcher = new VisitorMatcher((Object)"", "", (VisitorMatcher.MatchingAcceptor)new FileMatchingAcceptor(), Collections.singletonList(new AbstractMatcher.AlwaysMatcher()));
        ArrayList<IWorkspaceJSFResourceFragment> newFragments = new ArrayList<IWorkspaceJSFResourceFragment>();
        try {
            Collection foundResources = (Collection)matcher.find((Object)folder);
            for (IResource res : foundResources) {
                try {
                    newFragments.add(this.track(res));
                }
                catch (ResourceIdentifierFactory.InvalidIdentifierException invalidIdentifierException) {
                }
                catch (ObjectManager.ManagedObjectException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "Problem adding managed object for resource: " + res);
                }
            }
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, "While trying to locate JSF resources in the workspace");
        }
        return newFragments;
    }

    private IWorkspaceJSFResourceFragment track(IResource res) throws ObjectManager.ManagedObjectException, ResourceIdentifierFactory.InvalidIdentifierException {
        IPath fullPath = res.getFullPath().makeRelativeTo(this.getRootResourceFolder().getFullPath());
        JSFResourceTracker tracker = (JSFResourceTracker)this.getInstance(res);
        JSFResourceFragment jsfRes = null;
        if (res.getType() == 1) {
            try {
                jsfRes = new WorkspaceJSFResource(this._factory.createLibraryResource(fullPath.toString()), res, this._contentTypeResolver);
            }
            catch (ResourceIdentifierFactory.InvalidIdentifierException e) {
                this.unmanageResource(res);
                tracker.dispose();
                throw e;
            }
        } else {
            jsfRes = new WorkspaceJSFResourceContainer(this._factory.createLibraryFragment(fullPath.toString()), (IContainer)res);
        }
        tracker.setJsfResource((IWorkspaceJSFResourceFragment)((Object)jsfRes));
        this.addLifecycleEventListener((IResourceLifecycleListener)tracker);
        return jsfRes;
    }

    public IFolder getRootResourceFolder() {
        IVirtualFolder webContentFolder = this._vcQuery.getWebContentFolder(this._project);
        if (webContentFolder != null && webContentFolder.getUnderlyingFolder().isAccessible()) {
            return webContentFolder.getUnderlyingFolder().getFolder((IPath)new Path("resources"));
        }
        return null;
    }

    public List<IResource> getResources() {
        return new ArrayList<IResource>(this.getManagedResources());
    }

    public List<IJSFResourceFragment> getJSFResources() {
        ArrayList<IJSFResourceFragment> jsfResources = new ArrayList<IJSFResourceFragment>();
        Map jsfResourceTrackers = this.getPerResourceObjects();
        for (Map.Entry entry : jsfResourceTrackers.entrySet()) {
            JSFResourceTracker jsfResourceTracker = (JSFResourceTracker)((ResourceSingletonObjectManager.ManagedResourceObject)entry.getValue()).getManagedObject();
            if (!jsfResourceTracker.isJSFResource()) continue;
            jsfResources.add(jsfResourceTracker.getJsfResource());
        }
        return jsfResources;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JSFResourceTracker
    extends ResourceTracker<IResource> {
        private IWorkspaceJSFResourceFragment _jsfResource;
        private final boolean _isJSFResource;

        public JSFResourceTracker(IResource resource, boolean isJSFResource) {
            super(resource);
            this._isJSFResource = isJSFResource;
        }

        public boolean isJSFResource() {
            return this._isJSFResource;
        }

        protected void fireResourceInAccessible(IResource affectedResource, ResourceLifecycleEvent.ReasonType reasonType) {
            if (reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED_FROM_CONTAINER || reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER) {
                try {
                    List<JSFResourceTracker> trackers = this.getTrackers(affectedResource);
                    for (JSFResourceTracker tracker : trackers) {
                        IWorkspaceJSFResourceFragment jsfResource = tracker.getJsfResource();
                        WorkspaceResourceManager.this.removeLifecycleEventListener((IResourceLifecycleListener)tracker);
                        WorkspaceResourceManager.this._locator.fireChangeEvent(new JSFResourceChangeListener.JSFResourceChangedEvent(WorkspaceResourceManager.this._locator, jsfResource, null, JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.REMOVED));
                    }
                }
                catch (ObjectManager.ManagedObjectException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "Processing an inaccessible resource event");
                }
            }
        }

        private List<JSFResourceTracker> getTrackers(IResource res) throws ObjectManager.ManagedObjectException {
            JSFResourceTracker tracker = (JSFResourceTracker)WorkspaceResourceManager.this.getInstance(res);
            ArrayList<JSFResourceTracker> allChildren = new ArrayList<JSFResourceTracker>();
            allChildren.add(tracker);
            if (res instanceof IContainer) {
                IPath parentPath = res.getFullPath();
                for (Map.Entry trackerEntry : WorkspaceResourceManager.this.getPerResourceObjects().entrySet()) {
                    IPath trackerPath = ((IResource)trackerEntry.getKey()).getFullPath();
                    if (!parentPath.isPrefixOf(trackerPath) || parentPath.equals((Object)trackerPath)) continue;
                    allChildren.add((JSFResourceTracker)((ResourceSingletonObjectManager.ManagedResourceObject)trackerEntry.getValue()).getManagedObject());
                }
            }
            return allChildren;
        }

        protected void fireResourceChanged(IResource affectedResource, ResourceLifecycleEvent.ReasonType reasonType) {
            WorkspaceResourceManager.this._locator.fireChangeEvent(new JSFResourceChangeListener.JSFResourceChangedEvent(WorkspaceResourceManager.this._locator, this._jsfResource, this._jsfResource, JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.CHANGED));
        }

        protected void fireResourceAdded(IResource affectedResource, ResourceLifecycleEvent.ReasonType reasonType) {
            IContainer parent;
            if ((reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED_TO_CONTAINER || reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER) && (parent = affectedResource.getParent()) != null && parent.isAccessible()) {
                try {
                    IWorkspaceJSFResourceFragment newJsfRes = WorkspaceResourceManager.this.track(affectedResource);
                    this.fireNewJSFResourceEvent(newJsfRes);
                    if (reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER && affectedResource instanceof IContainer) {
                        List newFragments = WorkspaceResourceManager.this.trackAllInFolder((IContainer)affectedResource);
                        for (IWorkspaceJSFResourceFragment frag : newFragments) {
                            this.fireNewJSFResourceEvent(frag);
                        }
                    }
                }
                catch (ObjectManager.ManagedObjectException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "While adding new resource " + affectedResource);
                }
                catch (ResourceIdentifierFactory.InvalidIdentifierException invalidIdentifierException) {
                    JSFCorePlugin.log(1, "While adding new resource " + affectedResource);
                }
            }
        }

        private void fireNewJSFResourceEvent(IWorkspaceJSFResourceFragment newJsfRes) {
            JSFResourceChangeListener.JSFResourceChangedEvent event = new JSFResourceChangeListener.JSFResourceChangedEvent(WorkspaceResourceManager.this._locator, null, newJsfRes, JSFResourceChangeListener.JSFResourceChangedEvent.CHANGE_TYPE.ADDED);
            WorkspaceResourceManager.this._locator.fireChangeEvent(event);
        }

        protected boolean isInteresting(ResourceLifecycleEvent event) {
            boolean isInteresting = false;
            ResourceLifecycleEvent.ReasonType reasonType = event.getReasonType();
            switch (event.getEventType()) {
                case RESOURCE_ADDED: {
                    IResource resource = this.getResource();
                    boolean bl = isInteresting = (reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED_TO_CONTAINER || reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER) && event.getAffectedResource().getParent().equals((Object)resource);
                    if (!resource.equals((Object)WorkspaceResourceManager.this._vcQuery.getWebContentFolder(WorkspaceResourceManager.this._project).getUnderlyingFolder())) break;
                    isInteresting &= event.getAffectedResource().equals((Object)WorkspaceResourceManager.this.getRootResourceFolder());
                    break;
                }
                case RESOURCE_INACCESSIBLE: {
                    IResource resource = this.getResource();
                    boolean bl = isInteresting = (reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED_FROM_CONTAINER || reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER) && event.getAffectedResource().getParent().equals((Object)resource);
                    if (!resource.equals((Object)WorkspaceResourceManager.this._vcQuery.getWebContentFolder(WorkspaceResourceManager.this._project).getUnderlyingFolder())) break;
                    isInteresting &= event.getAffectedResource().equals((Object)WorkspaceResourceManager.this.getRootResourceFolder());
                    break;
                }
                default: {
                    isInteresting = super.isInteresting(event);
                }
            }
            return isInteresting;
        }

        public final IWorkspaceJSFResourceFragment getJsfResource() {
            return this._jsfResource;
        }

        public final void setJsfResource(IWorkspaceJSFResourceFragment jsfResource) {
            this._jsfResource = jsfResource;
        }
    }
}

