/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.PropertyNameValidationVisitor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ManagedPropertyValidationVisitor
extends EObjectValidationVisitor {
    public ManagedPropertyValidationVisitor(String version) {
        super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedProperty(), version);
    }

    protected void doValidate(EObject object, List messages, IFile file) {
        ManagedPropertyType managedPropertyType = (ManagedPropertyType)object;
        if (managedPropertyType.getPropertyName() == null || managedPropertyType.getPropertyClass() == null) {
            return;
        }
        String propertyName = managedPropertyType.getPropertyName().getTextContent();
        String propertyClass = managedPropertyType.getPropertyClass().getTextContent();
        if (propertyName == null || propertyClass == null || "".equals(propertyName.trim()) || "".equals(propertyClass.trim())) {
            return;
        }
        IMessage message = null;
        MapEntriesType eObj = null;
        if (managedPropertyType.getMapEntries() != null) {
            eObj = managedPropertyType.getMapEntries();
            message = AppConfigValidationUtil.validateMapEntries(propertyName, propertyClass, eObj, file.getProject());
        } else if (managedPropertyType.getListEntries() != null) {
            eObj = managedPropertyType.getListEntries();
            message = AppConfigValidationUtil.validateListEntries(propertyName, propertyClass, (ListEntriesType)eObj, file.getProject());
        }
        ManagedPropertyValidationVisitor.addMessageInfo(messages, message, (EObject)eObj, file);
    }

    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return new EObjectValidationVisitor[]{new PropertyNameValidationVisitor((EStructuralFeature)FacesConfigPackage.eINSTANCE.getManagedPropertyType_PropertyName(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedBeanClass(), this.getVersion())};
    }
}

