/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataTableInsertColumnCommand
extends DesignerCommand {
    Element _dataTable;
    Element _child;
    int _index;

    public DataTableInsertColumnCommand(IHTMLGraphicalViewer viewer, Element dataTable, int index) {
        super(CommandResources.getString("DataTableInsertColumnCommand.Label.InsertColumn"), viewer);
        this._dataTable = dataTable;
        this._index = index;
    }

    public boolean canExecute() {
        if (this._index < 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/html", (String)"h");
        this._child = this._dataTable.getOwnerDocument().createElement(String.valueOf(prefix) + ":column");
        this.createHeaderFooter(this._child);
        NodeList children = this._dataTable.getChildNodes();
        int count = 0;
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node)) {
                if (this._index == count) {
                    this._dataTable.insertBefore(this._child, node);
                    return;
                }
                ++count;
            }
            ++i;
        }
        this._dataTable.insertBefore(this._child, null);
        this.formatNode(this._child);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._dataTable);
    }

    private void createHeaderFooter(Element column) {
        boolean hasHeader = false;
        boolean hasFooter = false;
        NodeList children = this._dataTable.getChildNodes();
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node)) {
                if (!hasHeader && JSFDOMUtil.findFacet((Element)node, "header") != null) {
                    hasHeader = true;
                }
                if (!hasFooter && JSFDOMUtil.findFacet((Element)node, "footer") != null) {
                    hasFooter = true;
                }
            }
            ++i;
        }
        if (hasHeader) {
            Element facet = this.createFacet();
            facet.setAttribute("name", "header");
            Element ele = this.createDefaultElement();
            facet.appendChild(ele);
            column.appendChild(facet);
        }
        if (hasFooter) {
            Element facet = this.createFacet();
            facet.setAttribute("name", "footer");
            Element ele = this.createDefaultElement();
            facet.appendChild(ele);
            column.appendChild(facet);
        }
    }

    private Element createFacet() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/core", (String)"f");
        Element ele = this._dataTable.getOwnerDocument().createElement("facet");
        ele.setPrefix(prefix);
        return ele;
    }

    private Element createDefaultElement() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/html", (String)"h");
        Element ele = this._dataTable.getOwnerDocument().createElement("outputText");
        ele.setPrefix(prefix);
        ele.setAttribute("value", "Column");
        return ele;
    }
}

