/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.axis.creation.ui.plugin.WebServiceAxisCreationUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.common.ComboWithHistory;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class BeanConfigWidget
extends SimpleWidgetDataContributor {
    private Button rpcEncodedButton_;
    private Button rpcLiteralButton_;
    private Button docLiteralButton_;
    private Listener statusListener_;
    private JavaWSDLParameter javaParameter_;
    private final String INFOPOP_PBCF_PAGE = "PBCF0001";
    private String wsdlFolder_;
    private ComboWithHistory wsdlFileText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FILE = "PBCF0007";
    private Tree methodsTree_;
    private final String INFOPOP_PBME_TREE_METHODS = "PBME0002";
    private Button selectAllMethodsButton_;
    private final String INFOPOP_PBME_BUTTON_SELECT_ALL = "PBME0010";
    private Button deselectAllMethodsButton_;
    private final String INFOPOP_PBME_BUTTON_DESELECT_ALL = "PBME0011";
    private Button showMappingsCheckbox_;
    private String INFOPOP_P2N_SHOW_MAPPINGS = "PBCF0016";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId_ = "org.eclipse.jst.ws.axis.creation.ui";
        UIUtils uiUtils = new UIUtils(pluginId_);
        UIUtils baseConUiUtils = new UIUtils(pluginId_);
        this.statusListener_ = statusListener;
        parent.setToolTipText(AxisCreationUIMessages.TOOLTIP_PBCF_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(pluginId_) + "." + "PBCF0001");
        Composite configGroup = uiUtils.createComposite(parent, 2);
        this.wsdlFileText_ = uiUtils.createComboWithHistory(configGroup, AxisCreationUIMessages.LABEL_OUTPUT_FILE_NAME, AxisCreationUIMessages.TOOLTIP_PBCF_TEXT_WSDL_FILE, "PBCF0007", 2052, WebServiceAxisCreationUIPlugin.getInstance().getDialogSettings());
        this.wsdlFileText_.addListener(24, statusListener);
        Group methodsGroup = baseConUiUtils.createGroup(parent, ConsumptionUIMessages.LABEL_METHODS, null, null);
        methodsGroup.setLayoutData((Object)uiUtils.createFillAll());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        methodsGroup.setLayout((Layout)layout);
        this.methodsTree_ = uiUtils.createTree((Composite)methodsGroup, AxisCreationUIMessages.TOOLTIP_PBME_TREE_METHODS, "PBME0002", 2850);
        this.methodsTree_.addListener(13, statusListener);
        Composite selectButtons = uiUtils.createComposite((Composite)methodsGroup, 2);
        this.selectAllMethodsButton_ = baseConUiUtils.createPushButton(selectButtons, ConsumptionUIMessages.BUTTON_SELECT_ALL, ConsumptionUIMessages.TOOLTIP_PBME_BUTTON_SELECT_ALL, "PBME0010");
        this.selectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanConfigWidget.this.handleSelectAll(true);
            }
        });
        this.deselectAllMethodsButton_ = baseConUiUtils.createPushButton(selectButtons, ConsumptionUIMessages.BUTTON_DESELECT_ALL, ConsumptionUIMessages.TOOLTIP_PBME_BUTTON_DESELECT_ALL, "PBME0011");
        this.deselectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanConfigWidget.this.handleSelectAll(false);
            }
        });
        Group styleGroup = uiUtils.createGroup(parent, AxisCreationUIMessages.LABEL_STYLE_USE, null, null);
        this.docLiteralButton_ = uiUtils.createRadioButton((Composite)styleGroup, AxisCreationUIMessages.STYLE_DOC_LITERAL, null, null);
        this.rpcLiteralButton_ = uiUtils.createRadioButton((Composite)styleGroup, AxisCreationUIMessages.STYLE_RPC_LITERAL, null, null);
        this.rpcEncodedButton_ = uiUtils.createRadioButton((Composite)styleGroup, AxisCreationUIMessages.STYLE_RPC_ENCODED, null, null);
        this.showMappingsCheckbox_ = uiUtils.createCheckbox(parent, AxisCreationUIMessages.LABEL_EXPLORE_MAPPINGS_BEAN2XML, AxisCreationUIMessages.TOOLTIP_P2N_SHOW_MAPPINGS, this.INFOPOP_P2N_SHOW_MAPPINGS);
        return this;
    }

    public void handleSelectAll(boolean value) {
        TreeItem[] items = this.methodsTree_.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(value);
            ++i;
        }
        this.statusListener_.handleEvent(null);
    }

    public void setCustomizeServiceMappings(boolean value) {
        this.showMappingsCheckbox_.setSelection(value);
    }

    public boolean getCustomizeServiceMappings() {
        return this.showMappingsCheckbox_ == null ? false : this.showMappingsCheckbox_.getSelection();
    }

    public void setJavaParameter(JavaWSDLParameter javaParameter) {
        String style;
        this.javaParameter_ = javaParameter;
        String wsdlLocation = javaParameter.getOutputWsdlLocation();
        Path wsdlPath = new Path(wsdlLocation);
        this.wsdlFolder_ = wsdlPath.removeLastSegments(1).toString();
        this.wsdlFileText_.setText(wsdlPath.lastSegment());
        this.methodsTree_.removeAll();
        Hashtable methods = javaParameter.getMethods();
        Enumeration e = methods.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            TreeItem item = new TreeItem(this.methodsTree_, 0);
            item.setData((Object)name);
            item.setText(name);
            item.setChecked(((Boolean)methods.get(name)).booleanValue());
        }
        TreeItem[] items = this.methodsTree_.getItems();
        if (items.length > 0) {
            this.methodsTree_.setSelection(new TreeItem[]{items[0]});
        }
        if ((style = javaParameter.getStyle()).equals("RPC")) {
            this.rpcEncodedButton_.setSelection(true);
        } else if (style.equals("DOCUMENT")) {
            this.rpcLiteralButton_.setSelection(true);
        } else {
            this.docLiteralButton_.setSelection(true);
        }
    }

    public JavaWSDLParameter getJavaParameter() {
        IPath wsdlPath = new Path(this.wsdlFolder_.trim()).append(this.wsdlFileText_.getText().trim());
        String wsdlLocation = wsdlPath.toString();
        this.javaParameter_.setOutputWsdlLocation(wsdlLocation);
        this.javaParameter_.setInputWsdlLocation(new File(wsdlLocation).toURI().toString());
        Hashtable<String, Boolean> methods = new Hashtable<String, Boolean>();
        TreeItem[] items = this.methodsTree_.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            methods.put((String)item.getData(), new Boolean(item.getChecked()));
            ++i;
        }
        this.javaParameter_.setMethods(methods);
        if (this.rpcEncodedButton_.getSelection()) {
            this.javaParameter_.setStyle("RPC");
            this.javaParameter_.setUse("ENCODED");
        } else if (this.rpcLiteralButton_.getSelection()) {
            this.javaParameter_.setStyle("DOCUMENT");
            this.javaParameter_.setUse("LITERAL");
        } else {
            this.javaParameter_.setStyle("WRAPPED");
            this.javaParameter_.setUse("LITERAL");
        }
        return this.javaParameter_;
    }

    public IStatus getStatus() {
        IStatus result = null;
        if (this.wsdlFileText_.getText().equals("")) {
            result = StatusUtils.errorStatus((String)AxisCreationUIMessages.PAGE_MSG_NO_FILE_SPECIFIED);
        } else {
            TreeItem[] items = this.methodsTree_.getItems();
            boolean itemSelected = false;
            int index = 0;
            while (index < items.length) {
                if (items[index].getChecked()) {
                    itemSelected = true;
                    break;
                }
                ++index;
            }
            if (!itemSelected) {
                result = StatusUtils.errorStatus((String)AxisCreationUIMessages.PAGE_MSG_NO_METHOD_SELECTED);
            }
        }
        return result;
    }

    public void externalize() {
        super.externalize();
        this.wsdlFileText_.storeWidgetHistory("org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean.BeanConfigWidget.wsdlFileText_");
    }

    public void internalize() {
        this.wsdlFileText_.removeListener(24, this.statusListener_);
        this.wsdlFileText_.restoreWidgetHistory("org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean.BeanConfigWidget.wsdlFileText_");
        this.wsdlFileText_.addListener(24, this.statusListener_);
    }
}

