// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.11,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.archetype.metadata;

/**
 * 
 *         A fileset defines the way the project's files located in
 * the jar file are used by the Archetype Plugin to generate a
 * project.
 *         If file or directory name contains
 * <code>__<i>property</i>__</code> pattern, it is replaced with
 * corresponding property value.
 *         
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class FileSet
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Filesets can be filtered, which means the
     * selected files will be used as
     *             <a
     * href="http://velocity.apache.org/engine/releases/velocity-1.5/user-guide.html">Velocity
     * templates</a>.
     *             They can be non-filtered, which means the
     * selected files will be copied without modification.
     *           
     */
    private boolean filtered = false;

    /**
     * Filesets can be packaged, which means the selected files
     * will be generated/copied in a directory
     *            structure that is prepended by the package
     * property. They can be non-packaged, which means that the
     * selected
     *            files will be generated/copied without that
     * prepend.
     */
    private boolean packaged = false;

    /**
     * Encoding to use when filtering content.
     */
    private String encoding;

    /**
     * The directory where the files will be searched for, which is
     * also the directory where the
     *            project's files will be generated.
     */
    private String directory;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get the directory where the files will be searched for,
     * which is also the directory where the
     *            project's files will be generated.
     * 
     * @return String
     */
    public String getDirectory()
    {
        return this.directory;
    } //-- String getDirectory()

    /**
     * Get encoding to use when filtering content.
     * 
     * @return String
     */
    public String getEncoding()
    {
        return this.encoding;
    } //-- String getEncoding()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get filesets can be filtered, which means the selected files
     * will be used as
     *             <a
     * href="http://velocity.apache.org/engine/releases/velocity-1.5/user-guide.html">Velocity
     * templates</a>.
     *             They can be non-filtered, which means the
     * selected files will be copied without modification.
     * 
     * @return boolean
     */
    public boolean isFiltered()
    {
        return this.filtered;
    } //-- boolean isFiltered()

    /**
     * Get filesets can be packaged, which means the selected files
     * will be generated/copied in a directory
     *            structure that is prepended by the package
     * property. They can be non-packaged, which means that the
     * selected
     *            files will be generated/copied without that
     * prepend.
     * 
     * @return boolean
     */
    public boolean isPackaged()
    {
        return this.packaged;
    } //-- boolean isPackaged()

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set the directory where the files will be searched for,
     * which is also the directory where the
     *            project's files will be generated.
     * 
     * @param directory
     */
    public void setDirectory( String directory )
    {
        this.directory = directory;
    } //-- void setDirectory( String )

    /**
     * Set encoding to use when filtering content.
     * 
     * @param encoding
     */
    public void setEncoding( String encoding )
    {
        this.encoding = encoding;
    } //-- void setEncoding( String )

    /**
     * Set exclusion definition "à la" Ant.
     * 
     * @param excludes
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set filesets can be filtered, which means the selected files
     * will be used as
     *             <a
     * href="http://velocity.apache.org/engine/releases/velocity-1.5/user-guide.html">Velocity
     * templates</a>.
     *             They can be non-filtered, which means the
     * selected files will be copied without modification.
     * 
     * @param filtered
     */
    public void setFiltered( boolean filtered )
    {
        this.filtered = filtered;
    } //-- void setFiltered( boolean )

    /**
     * Set inclusion definition "à la" Ant.
     * 
     * @param includes
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set filesets can be packaged, which means the selected files
     * will be generated/copied in a directory
     *            structure that is prepended by the package
     * property. They can be non-packaged, which means that the
     * selected
     *            files will be generated/copied without that
     * prepend.
     * 
     * @param packaged
     */
    public void setPackaged( boolean packaged )
    {
        this.packaged = packaged;
    } //-- void setPackaged( boolean )

    
    public String toString()
    {
        return
            getDirectory() + " ("
                + ( isFiltered() ? "Filtered" : "Copied" )
                + "-"
                + ( isPackaged() ? "Packaged" : "Flat" )
            + ") ["
                + org.codehaus.plexus.util.StringUtils.join( getIncludes().iterator(), ", " )
                + " -- "
                + org.codehaus.plexus.util.StringUtils.join( getExcludes().iterator(), ", " )
            + "]";

    }
                    
}
