/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.tests.common.AbstractMavenProjectTestCase;
import org.eclipse.m2e.tests.common.RequireMavenExecutionContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

@RequireMavenExecutionContext
public abstract class AbstractLifecycleMappingTest
extends AbstractMavenProjectTestCase {
    protected IMavenProjectRegistry mavenProjectManager;
    protected IProjectConfigurationManager projectConfigurationManager;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mavenProjectManager = MavenPlugin.getMavenProjectRegistry();
        this.projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.projectConfigurationManager = null;
        this.mavenProjectManager = null;
        super.tearDown();
    }

    protected IMavenProjectFacade importMavenProject(String basedir, String pomName) throws Exception {
        ResolverConfiguration configuration = new ResolverConfiguration();
        IProject[] project = this.importProjects(basedir, new String[]{pomName}, configuration);
        this.waitForJobsToComplete();
        return this.mavenProjectManager.create(project[0], monitor);
    }

    private LifecycleMappingMetadataSource loadLifecycleMappingMetadataSourceInternal(File metadataFile) throws IOException, XmlPullParserException {
        Assert.assertTrue((String)("File does not exist:" + metadataFile.getAbsolutePath()), (boolean)metadataFile.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(metadataFile);){
            return LifecycleMappingFactory.createLifecycleMappingMetadataSource((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected LifecycleMappingMetadataSource loadLifecycleMappingMetadataSource(String metadataFilename) throws IOException, XmlPullParserException {
        return this.loadLifecycleMappingMetadataSourceInternal(new File(metadataFilename));
    }

    protected MavenProjectFacade newMavenProjectFacade(IFile pom) throws CoreException {
        MavenProject mavenProject = MavenPlugin.getMaven().readProject(pom.getLocation().toFile(), monitor);
        return new MavenProjectFacade(MavenPluginActivator.getDefault().getMavenProjectManagerImpl(), pom, mavenProject, (IProjectConfiguration)new ResolverConfiguration());
    }

    protected List<MojoExecutionKey> getNotCoveredMojoExecutions(IMavenProjectFacade facade) {
        ArrayList<MojoExecutionKey> result = new ArrayList<MojoExecutionKey>();
        facade.getMojoExecutionMapping().forEach((key, executions) -> {
            if ((executions == null || executions.isEmpty()) && LifecycleMappingFactory.isInterestingPhase((String)key.lifecyclePhase())) {
                result.add((MojoExecutionKey)key);
            }
        });
        return result;
    }

    protected LifecycleMappingResult calculateLifecycleMapping(MavenProjectFacade facade) throws CoreException {
        MavenProject mavenProject = facade.getMavenProject(monitor);
        List mojoExecutions = facade.getMojoExecutions(monitor);
        String lifecycleMappingId = facade.getConfiguration().getLifecycleMappingId();
        return LifecycleMappingFactory.calculateLifecycleMapping((MavenProject)mavenProject, (List)mojoExecutions, (String)lifecycleMappingId, (IProgressMonitor)monitor);
    }
}

