/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.snapshot.ClassHistogramRecordBuilder;
import org.eclipse.mat.parser.internal.snapshot.ClassLoaderHistogramRecordBuilder;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.HistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

public class HistogramBuilder
extends HistogramRecord {
    private static final long serialVersionUID = 2L;
    protected HashMapIntObject<Object> data = new HashMapIntObject();

    public HistogramBuilder(String label) {
        super(label);
    }

    public void put(ClassHistogramRecord record) {
        Object previous = this.data.put(record.getClassId(), (Object)record);
        if (previous != null) {
            throw new IllegalArgumentException(Messages.HistogramBuilder_Error_FailedToStoreInHistogram);
        }
    }

    public void add(int classId, int objectId, long heapSize) {
        ClassHistogramRecordBuilder object = (ClassHistogramRecordBuilder)((Object)this.data.get(classId));
        if (object == null) {
            object = new ClassHistogramRecordBuilder(null, classId);
            this.data.put(classId, (Object)object);
        }
        object.add(objectId, heapSize);
    }

    public Histogram toHistogram(SnapshotImpl snapshot, boolean isDefaultHistogram) throws SnapshotException {
        ArrayList<ClassHistogramRecord> classHistogramRecords = new ArrayList<ClassHistogramRecord>(this.data.size());
        HashMapIntObject cl2builder = new HashMapIntObject();
        Iterator e = this.data.values();
        while (e.hasNext()) {
            Object obj = e.next();
            ClassHistogramRecord record = obj instanceof ClassHistogramRecordBuilder ? ((ClassHistogramRecordBuilder)((Object)obj)).toClassHistogramRecord() : (ClassHistogramRecord)obj;
            ClassImpl clasz = (ClassImpl)snapshot.getObject(record.getClassId());
            record.setLabel(clasz.getName());
            classHistogramRecords.add(record);
            int classLoaderId = clasz.getClassLoaderId();
            ClassLoaderHistogramRecordBuilder clRec = (ClassLoaderHistogramRecordBuilder)((Object)cl2builder.get(classLoaderId));
            if (clRec == null) {
                IObject classLoader = snapshot.getObject(classLoaderId);
                String label = classLoader.getClassSpecificName();
                if (label == null) {
                    label = classLoader.getTechnicalName();
                }
                long retainedHeapSize = isDefaultHistogram ? ClassLoaderImpl.doGetRetainedHeapSizeOfObjects(snapshot, classLoaderId, false, false, null) : 0L;
                clRec = new ClassLoaderHistogramRecordBuilder(label, classLoaderId, retainedHeapSize);
                cl2builder.put(classLoaderId, (Object)clRec);
            }
            clRec.add(record);
        }
        int numberOfObjectsOverall = 0;
        long usedHeapSizeOverall = 0L;
        long retainedHeapSizeOverall = 0L;
        ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords = new ArrayList<ClassLoaderHistogramRecord>(cl2builder.size());
        Iterator e2 = cl2builder.values();
        while (e2.hasNext()) {
            ClassLoaderHistogramRecordBuilder builder = (ClassLoaderHistogramRecordBuilder)((Object)e2.next());
            classLoaderHistogramRecords.add(builder.toClassLoaderHistogramRecord(isDefaultHistogram));
            numberOfObjectsOverall = (int)((long)numberOfObjectsOverall + builder.getNumberOfObjects());
            usedHeapSizeOverall += builder.getUsedHeapSize();
            retainedHeapSizeOverall += builder.getRetainedHeapSize();
        }
        if (isDefaultHistogram) {
            VoidProgressListener listener = new VoidProgressListener();
            for (ClassHistogramRecord r : classHistogramRecords) {
                r.calculateRetainedSize((ISnapshot)snapshot, false, true, (IProgressListener)listener);
            }
        }
        return new Histogram(this.getLabel(), classHistogramRecords, classLoaderHistogramRecords, (long)numberOfObjectsOverall, usedHeapSizeOverall, retainedHeapSizeOverall, isDefaultHistogram);
    }
}

