/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.oomph.setup.internal.core.util.IndexManager;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.Messages;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class IndexManagerDialog
extends AbstractSetupDialog {
    public static final String TITLE = Messages.IndexManagerDialog_title;
    public static final String DESCRIPTION = Messages.IndexManagerDialog_description;
    private static final int REMOVE_ID = 1025;
    private final IndexManager indexManager = new IndexManager();
    private TableViewer indexViewer;
    private Button removeButton;
    private Map<URI, String> originalIndexChoices;
    private Map<URI, String> indexChoices;
    private Map<URI, Boolean> indexAvailability;
    private IndexScope indexScope = IndexScope.LOCAL;
    private URI originalIndexLocation;

    public IndexManagerDialog(Shell parentShell) {
        super(parentShell, Messages.IndexManagerDialog_dialogTitle, 750, 300, SetupUIPlugin.INSTANCE, true);
        this.indexChoices = this.indexManager.getIndexLabels(true);
        this.originalIndexChoices = new LinkedHashMap<URI, String>(this.indexChoices);
        if (!this.originalIndexChoices.isEmpty()) {
            this.originalIndexLocation = this.originalIndexChoices.keySet().iterator().next();
        }
        new Job(Messages.IndexManagerDialog_availabilityCheckerJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                IndexManagerDialog.this.indexAvailability = IndexManagerDialog.this.indexManager.getIndexAvailability(false);
                UIUtil.asyncExec((Control)IndexManagerDialog.this.indexViewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).IndexManagerDialog.this.indexViewer.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return String.valueOf(DESCRIPTION) + ".";
    }

    protected void createUI(Composite parent) {
        this.indexViewer = new TableViewer(parent, 770);
        this.indexViewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.indexViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return IndexManagerDialog.this.indexChoices.entrySet().toArray();
            }
        });
        ColumnViewerInformationControlToolTipSupport columnViewerInformationControlToolTipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.indexViewer, new LocationListener(){

            public void changing(LocationEvent event) {
            }

            public void changed(LocationEvent event) {
            }
        });
        class MyLabelProvider
        extends CellLabelProvider
        implements ILabelProvider {
            private final Color gray;
            private final Font normalFont;
            private final Font italicFont;
            private final Font boldFont;
            private final /* synthetic */ ColumnViewerInformationControlToolTipSupport val$columnViewerInformationControlToolTipSupport;

            MyLabelProvider(ColumnViewerInformationControlToolTipSupport columnViewerInformationControlToolTipSupport) {
                this.val$columnViewerInformationControlToolTipSupport = columnViewerInformationControlToolTipSupport;
                this.gray = IndexManagerDialog.this.indexViewer.getTable().getDisplay().getSystemColor(16);
                this.normalFont = IndexManagerDialog.this.indexViewer.getTable().getFont();
                this.italicFont = ExtendedFontRegistry.INSTANCE.getFont(this.normalFont, (Object)IItemFontProvider.ITALIC_FONT);
                this.boldFont = ExtendedFontRegistry.INSTANCE.getFont(this.normalFont, (Object)IItemFontProvider.BOLD_FONT);
            }

            public String getText(Object element) {
                return IndexManagerDialog.this.asMapEntry(element).getValue();
            }

            public Image getImage(Object element) {
                return SetupUIPlugin.INSTANCE.getSWTImage("full/obj16/Index");
            }

            public String getToolTipText(Object element) {
                URI indexLocation = IndexManagerDialog.this.asMapEntry(element).getKey();
                Map indexNames = IndexManagerDialog.this.indexManager.getIndexNames(true);
                StringBuilder result = new StringBuilder();
                String nameLine = "<divs style='white-space:nowrap;'><b>" + Messages.IndexManagerDialog_tooltip_name + "</b>:&nbsp;" + (String)indexNames.get(indexLocation) + "</div>\n";
                result.append(nameLine);
                String locationLine = "<div style='white-space:nowrap;'><b>" + Messages.IndexManagerDialog_tooltip_location + "</b>:&nbsp;" + indexLocation + "</div>\n";
                result.append(locationLine);
                String availabilityLine = "<div style='white-space:nowrap;'><b>" + Messages.IndexManagerDialog_tooltip_availability + "</b>:&nbsp;" + (IndexManagerDialog.this.indexAvailability == null ? Messages.IndexManagerDialog_tooltip_availability_unknown : (IndexManagerDialog.this.indexAvailability.get(indexLocation) != false ? Messages.IndexManagerDialog_tooltip_availability_available : Messages.IndexManagerDialog_tooltip_availability_unavailable)) + "</div><br/><br/>\n";
                result.append(availabilityLine);
                try {
                    AbstractHoverInformationControlManager hoverInformationControlManager = (AbstractHoverInformationControlManager)ReflectUtil.getValue((String)"hoverInformationControlManager", (Object)this.val$columnViewerInformationControlToolTipSupport);
                    int max = Math.max(nameLine.length(), locationLine.length());
                    hoverInformationControlManager.setSizeConstraints(max, 6, false, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return result.toString();
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                cell.setImage(this.getImage(element));
                URI indexLocation = IndexManagerDialog.this.asMapEntry(element).getKey();
                if (!IndexManagerDialog.this.originalIndexChoices.containsKey(indexLocation)) {
                    cell.setForeground(this.gray);
                }
                if (indexLocation.equals(IndexManagerDialog.this.originalIndexLocation)) {
                    cell.setFont(this.boldFont);
                } else if (IndexManagerDialog.this.indexAvailability != null && !IndexManagerDialog.this.indexAvailability.get(indexLocation).booleanValue()) {
                    cell.setFont(this.italicFont);
                } else {
                    cell.setFont(this.normalFont);
                }
                cell.setText(String.valueOf(this.getText(element)) + "  ");
            }
        }
        final MyLabelProvider labelProvider = new MyLabelProvider(columnViewerInformationControlToolTipSupport);
        this.indexViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        final TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.indexViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.indexViewer));
        this.indexViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                focusCellManager.getFocusCell();
                IndexManagerDialog.this.updateEnablement();
            }
        });
        this.indexViewer.setInput((Object)this.indexManager);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.indexViewer.getTable(), 2048);
        this.indexViewer.setCellEditors(new CellEditor[]{textCellEditor});
        this.indexViewer.setColumnProperties(new String[]{"label"});
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.indexViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 3 || event.eventType == 1 && event.keyCode == 0x100000B;
            }
        };
        TableViewerEditor.create((TableViewer)this.indexViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)32);
        this.indexViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                IndexManagerDialog.this.asMapEntry(((TableItem)element).getData()).setValue((String)value);
                IndexManagerDialog.this.indexViewer.refresh(true);
            }

            public Object getValue(Object element, String property) {
                return labelProvider.getText(element).trim();
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        if (!this.indexChoices.isEmpty()) {
            this.indexViewer.setSelection((ISelection)new StructuredSelection(this.indexChoices.entrySet().iterator().next()));
        }
    }

    protected Control createButtonBar(Composite parent) {
        return this.createButtonBarWithControls(parent);
    }

    protected void createControlsForButtonBar(Composite parent) {
        this.createLabel(parent, "  " + Messages.IndexManagerDialog_scopeLabel);
        final Combo indexCombo = this.createCombo(parent);
        String[] items = new String[]{Messages.IndexManagerDialog_indexCombo_local, Messages.IndexManagerDialog_indexCombo_localAndGlobal, Messages.IndexManagerDialog_indexCombo_global};
        indexCombo.setItems(items);
        indexCombo.select(0);
        indexCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexScope oldIndexScope = IndexManagerDialog.this.indexScope;
                IndexManagerDialog.this.indexScope = IndexScope.values()[indexCombo.getSelectionIndex()];
                switch (IndexManagerDialog.this.indexScope) {
                    case LOCAL: {
                        if (oldIndexScope == IndexScope.GLOBAL) {
                            IndexManagerDialog.this.indexChoices = IndexManagerDialog.this.indexManager.getIndexLabels(true);
                            break;
                        }
                        IndexManagerDialog.this.indexChoices.keySet().retainAll(IndexManagerDialog.this.indexManager.getIndexLabels(true).keySet());
                        break;
                    }
                    case LOCAL_AND_GLOBAL: {
                        if (oldIndexScope == IndexScope.GLOBAL) {
                            IndexManagerDialog.this.indexChoices = IndexManagerDialog.this.indexManager.getIndexLabels(false);
                            break;
                        }
                        for (Map.Entry entry : IndexManagerDialog.this.indexManager.getIndexLabels(false).entrySet()) {
                            if (IndexManagerDialog.this.indexChoices.containsKey(entry.getKey())) continue;
                            IndexManagerDialog.this.indexChoices.put((URI)entry.getKey(), (String)entry.getValue());
                        }
                        break;
                    }
                    case GLOBAL: {
                        IndexManagerDialog.this.indexChoices = IndexManagerDialog.this.indexManager.getGlobalIndexManager().getIndexLabels(true);
                    }
                }
                IndexManagerDialog.this.indexViewer.refresh();
                IndexManagerDialog.this.indexViewer.refresh();
                IndexManagerDialog.this.updateEnablement();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.removeButton = this.createButton(parent, 1025, Messages.IndexManagerDialog_removeButton_text, false);
        this.removeButton.setEnabled(false);
        super.createButtonsForButtonBar(parent);
        this.updateEnablement();
    }

    protected void updateEnablement() {
        if (this.removeButton != null) {
            this.removeButton.setEnabled(!this.indexViewer.getSelection().isEmpty());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            IStructuredSelection selection = (IStructuredSelection)this.indexViewer.getSelection();
            List list = selection.toList();
            Map.Entry<URI, String> newSelection = null;
            boolean visitedRemovedEntry = false;
            for (Map.Entry<URI, String> entry : this.indexChoices.entrySet()) {
                if (list.contains(entry)) {
                    visitedRemovedEntry = true;
                    if (newSelection == null) continue;
                    break;
                }
                newSelection = entry;
                if (visitedRemovedEntry) break;
            }
            this.indexChoices.entrySet().removeAll(list);
            if (newSelection != null) {
                this.indexViewer.setSelection((ISelection)new StructuredSelection(newSelection));
            }
            this.indexViewer.refresh();
        }
        super.buttonPressed(buttonId);
    }

    protected Map.Entry<URI, String> asMapEntry(Object object) {
        Map.Entry result = (Map.Entry)object;
        return result;
    }

    public String getHelpPath() {
        return String.valueOf(SetupUIPlugin.INSTANCE.getSymbolicName()) + "/html/IndexManagementHelp.html";
    }

    protected void okPressed() {
        IndexManager indexManager = this.indexScope == IndexScope.GLOBAL ? this.indexManager.getGlobalIndexManager() : this.indexManager;
        boolean local = this.indexScope != IndexScope.LOCAL_AND_GLOBAL;
        Map indexChoices = indexManager.getIndexLabels(true);
        LinkedHashSet removedURIs = new LinkedHashSet(indexChoices.keySet());
        removedURIs.removeAll(this.indexChoices.keySet());
        for (URI indexLocation : removedURIs) {
            indexManager.remove(indexLocation, local);
        }
        LinkedHashSet<URI> addedURIs = new LinkedHashSet<URI>(this.indexChoices.keySet());
        addedURIs.removeAll(indexChoices.keySet());
        if (!addedURIs.isEmpty()) {
            Map indexNames = indexManager.getIndexNames(false);
            for (URI indexLocation : addedURIs) {
                indexManager.addIndex(indexLocation, (String)indexNames.get(indexLocation), true);
                indexManager.setLabel(indexLocation, this.indexChoices.get(indexLocation), local);
                this.indexChoices.remove(indexLocation);
            }
            URI originalFirstIndexLocation = this.indexChoices.keySet().iterator().next();
            indexManager.addIndex(originalFirstIndexLocation, (String)indexNames.get(originalFirstIndexLocation), true);
        }
        for (Map.Entry<URI, String> entry : this.indexChoices.entrySet()) {
            if (((String)indexChoices.get(entry.getKey())).equals(entry.getValue())) continue;
            indexManager.setLabel(entry.getKey(), entry.getValue(), local);
        }
        super.okPressed();
    }

    public static enum IndexScope {
        LOCAL,
        LOCAL_AND_GLOBAL,
        GLOBAL;

    }
}

